/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.MapKey;
import dagger.MembersInjector;
import dagger.internal.Factory;
import dagger.internal.InstanceFactory;
import dagger.internal.MapFactory;
import dagger.internal.MapProviderFactory;
import dagger.internal.MembersInjectors;
import dagger.internal.ScopedProvider;
import dagger.internal.SetFactory;
import dagger.internal.codegen.AutoValue_ComponentGenerator_MemberSelect;
import dagger.internal.codegen.AutoValue_ComponentGenerator_ProxyClassAndField;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentProcessor;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.DependencyRequestMapper;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.KeyVariableNamer;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MethodSignature;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.SourceFiles;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.ClassWriter;
import dagger.internal.codegen.writer.ConstructorWriter;
import dagger.internal.codegen.writer.FieldWriter;
import dagger.internal.codegen.writer.JavaWriter;
import dagger.internal.codegen.writer.MethodWriter;
import dagger.internal.codegen.writer.ParameterizedTypeName;
import dagger.internal.codegen.writer.Snippet;
import dagger.internal.codegen.writer.StringLiteral;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.TypeNames;
import dagger.internal.codegen.writer.VoidName;
import dagger.producers.Producer;
import dagger.producers.internal.Producers;
import dagger.producers.internal.SetProducer;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementKindVisitor6;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class ComponentGenerator
extends SourceFileGenerator<BindingGraph> {
    private final Types types;
    private final Diagnostic.Kind nullableValidationType;

    ComponentGenerator(Filer filer, Types types, Diagnostic.Kind nullableValidationType) {
        super(filer);
        this.types = types;
        this.nullableValidationType = nullableValidationType;
    }

    @Override
    ClassName nameGeneratedType(BindingGraph input) {
        ClassName componentDefinitionClassName = ClassName.fromTypeElement(input.componentDescriptor().componentDefinitionType());
        String componentName = "Dagger" + componentDefinitionClassName.classFileName().replace('$', '_');
        return componentDefinitionClassName.topLevelClassName().peerNamed(componentName);
    }

    @Override
    Iterable<? extends Element> getOriginatingElements(BindingGraph input) {
        return ImmutableSet.of((Object)input.componentDescriptor().componentDefinitionType());
    }

    @Override
    Optional<? extends Element> getElementForErrorReporting(BindingGraph input) {
        return Optional.of((Object)input.componentDescriptor().componentDefinitionType());
    }

    @Override
    ImmutableSet<JavaWriter> write(ClassName componentName, BindingGraph input) {
        TypeElement componentDefinitionType = input.componentDescriptor().componentDefinitionType();
        ClassName componentDefinitionTypeName = ClassName.fromTypeElement(componentDefinitionType);
        JavaWriter writer = JavaWriter.inPackage(componentName.packageName());
        ClassWriter componentWriter = writer.addClass(componentName.simpleName());
        componentWriter.annotate(Generated.class).setValue(ComponentProcessor.class.getCanonicalName());
        componentWriter.addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        switch (componentDefinitionType.getKind()) {
            case CLASS: {
                Preconditions.checkState((boolean)componentDefinitionType.getModifiers().contains((Object)Modifier.ABSTRACT));
                componentWriter.setSuperType(componentDefinitionTypeName);
                break;
            }
            case INTERFACE: {
                componentWriter.addImplementedType(componentDefinitionTypeName);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        HashSet javaWriters = Sets.newHashSet();
        javaWriters.add(writer);
        this.writeComponent(input, componentDefinitionTypeName, componentWriter, javaWriters);
        return ImmutableSet.copyOf((Collection)javaWriters);
    }

    private ImmutableMap<BindingKey, MemberSelect> writeComponent(BindingGraph input, ClassName componentDefinitionTypeName, ClassWriter componentWriter, Set<JavaWriter> proxyWriters) {
        ClassWriter builderWriter = componentWriter.addNestedClass("Builder");
        builderWriter.addModifiers(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL);
        builderWriter.addConstructor().addModifiers(Modifier.PRIVATE, new Modifier[0]);
        MethodWriter builderFactoryMethod = componentWriter.addMethod(builderWriter, "builder");
        builderFactoryMethod.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        builderFactoryMethod.body().addSnippet("return new %s();", builderWriter.name());
        ImmutableMap componentContributionNames = ImmutableMap.copyOf((Map)Maps.asMap((Set)Sets.union((Set)Sets.union((Set)input.transitiveModules().keySet(), input.componentDescriptor().dependencies()), (Set)input.componentDescriptor().executorDependency().asSet()), (Function)Functions.compose((Function)CaseFormat.UPPER_CAMEL.converterTo(CaseFormat.LOWER_CAMEL), (Function)new Function<TypeElement, String>(){

            public String apply(TypeElement input) {
                return input.getSimpleName().toString();
            }
        })));
        ConstructorWriter constructorWriter = componentWriter.addConstructor();
        constructorWriter.addModifiers(Modifier.PRIVATE, new Modifier[0]);
        constructorWriter.addParameter(builderWriter, "builder");
        constructorWriter.body().addSnippet("assert builder != null;", new Object[0]);
        MethodWriter buildMethod = builderWriter.addMethod(componentDefinitionTypeName, "build");
        buildMethod.addModifiers(Modifier.PUBLIC, new Modifier[0]);
        boolean requiresBuilder = false;
        HashMap componentContributionFields = Maps.newHashMap();
        for (Map.Entry entry : componentContributionNames.entrySet()) {
            TypeElement contributionElement = (TypeElement)entry.getKey();
            String contributionName = (String)entry.getValue();
            FieldWriter builderField = builderWriter.addField(contributionElement, contributionName);
            builderField.addModifiers(Modifier.PRIVATE, new Modifier[0]);
            componentContributionFields.put(contributionElement, MemberSelect.instanceSelect(componentWriter.name(), Snippet.format("builder.%s", builderField.name())));
            MethodWriter builderMethod = builderWriter.addMethod(builderWriter, contributionName);
            builderMethod.addModifiers(Modifier.PUBLIC, new Modifier[0]);
            builderMethod.addParameter(contributionElement, contributionName);
            builderMethod.body().addSnippet("if (%s == null) {", contributionName).addSnippet("  throw new NullPointerException(%s);", StringLiteral.forValue(contributionName)).addSnippet("}", new Object[0]).addSnippet("this.%s = %s;", builderField.name(), contributionName).addSnippet("return this;", new Object[0]);
            if (Util.componentCanMakeNewInstances(contributionElement)) {
                buildMethod.body().addSnippet("if (%s == null) {", builderField.name()).addSnippet("  this.%s = new %s();", builderField.name(), ClassName.fromTypeElement(contributionElement)).addSnippet("}", new Object[0]);
                continue;
            }
            requiresBuilder = true;
            buildMethod.body().addSnippet("if (%s == null) {", builderField.name()).addSnippet("  throw new IllegalStateException(\"%s must be set\");", builderField.name()).addSnippet("}", new Object[0]);
        }
        if (!requiresBuilder) {
            MethodWriter factoryMethod = componentWriter.addMethod(componentDefinitionTypeName, "create");
            factoryMethod.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
            factoryMethod.body().addSnippet("return builder().build();", new Object[0]);
        }
        HashMap memberSelectSnippetsBuilder = Maps.newHashMap();
        HashMap multibindingContributionSnippetsBuilder = Maps.newHashMap();
        ImmutableSet.Builder enumBindingKeysBuilder = ImmutableSet.builder();
        HashMap packageProxies = Maps.newHashMap();
        this.writeFields(input, componentWriter, proxyWriters, memberSelectSnippetsBuilder, (Map<ContributionBinding, Snippet>)ImmutableMap.of(), multibindingContributionSnippetsBuilder, (ImmutableSet.Builder<BindingKey>)enumBindingKeysBuilder, packageProxies);
        buildMethod.body().addSnippet("return new %s(this);", componentWriter.name());
        ImmutableMap memberSelectSnippets = ImmutableMap.copyOf((Map)memberSelectSnippetsBuilder);
        ImmutableMap multibindingContributionSnippets = ImmutableMap.copyOf((Map)multibindingContributionSnippetsBuilder);
        ImmutableSet enumBindingKeys = enumBindingKeysBuilder.build();
        this.initializeFrameworkTypes(input, componentWriter, constructorWriter, (Optional<ClassName>)Optional.of((Object)builderWriter.name()), componentContributionFields, (ImmutableMap<BindingKey, MemberSelect>)memberSelectSnippets, (ImmutableMap<ContributionBinding, Snippet>)ImmutableMap.of(), (ImmutableMap<ContributionBinding, Snippet>)multibindingContributionSnippets);
        this.writeInterfaceMethods(input, componentWriter, (ImmutableMap<BindingKey, MemberSelect>)memberSelectSnippets, (ImmutableSet<BindingKey>)enumBindingKeys);
        for (Map.Entry subgraphEntry : input.subgraphs().entrySet()) {
            this.writeSubcomponent(componentWriter, proxyWriters, componentContributionFields, (ImmutableMap<BindingKey, MemberSelect>)memberSelectSnippets, (ImmutableMap<ContributionBinding, Snippet>)multibindingContributionSnippets, (ExecutableElement)subgraphEntry.getKey(), (BindingGraph)subgraphEntry.getValue());
        }
        return memberSelectSnippets;
    }

    private void writeSubcomponent(ClassWriter componentWriter, Set<JavaWriter> proxyWriters, Map<TypeElement, MemberSelect> parentContributionFields, ImmutableMap<BindingKey, MemberSelect> parentMemberSelectSnippets, ImmutableMap<ContributionBinding, Snippet> parentMultibindingContributionSnippets, ExecutableElement subcomponentFactoryMethod, BindingGraph subgraph) {
        MemberSelect moduleSelect;
        String actualModuleName;
        FieldWriter contributionField;
        String preferredModuleName;
        TypeName subcomponentType = TypeNames.forTypeMirror(subcomponentFactoryMethod.getReturnType());
        ClassWriter subcomponentWriter = componentWriter.addNestedClass(subgraph.componentDescriptor().componentDefinitionType().getSimpleName() + "Impl");
        subcomponentWriter.addModifiers(Modifier.PRIVATE, Modifier.FINAL);
        subcomponentWriter.addImplementedType(subcomponentType);
        MethodWriter componentMethod = componentWriter.addMethod(subcomponentType, subcomponentFactoryMethod.getSimpleName().toString());
        componentMethod.addModifiers(Modifier.PUBLIC, new Modifier[0]);
        componentMethod.annotate(Override.class);
        ConstructorWriter constructorWriter = subcomponentWriter.addConstructor();
        constructorWriter.addModifiers(Modifier.PRIVATE, new Modifier[0]);
        constructorWriter.body();
        HashMap componentContributionFields = Maps.newHashMap(parentContributionFields);
        ImmutableList.Builder subcomponentConstructorParameters = ImmutableList.builder();
        for (VariableElement variableElement : subcomponentFactoryMethod.getParameters()) {
            TypeElement moduleType = MoreTypes.asTypeElement(variableElement.asType());
            Verify.verify((boolean)subgraph.transitiveModules().containsKey((Object)moduleType));
            componentMethod.addParameter(TypeNames.forTypeMirror(variableElement.asType()), variableElement.getSimpleName().toString());
            if (componentContributionFields.containsKey(moduleType)) continue;
            preferredModuleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, moduleType.getSimpleName().toString());
            contributionField = subcomponentWriter.addField(moduleType, preferredModuleName);
            contributionField.addModifiers(Modifier.PRIVATE, Modifier.FINAL);
            actualModuleName = contributionField.name();
            constructorWriter.addParameter(TypeNames.forTypeMirror(variableElement.asType()), actualModuleName);
            constructorWriter.body().addSnippet(Snippet.format(Joiner.on((char)'\n').join((Object)"if (%s == null) {", (Object)"  throw new NullPointerException();", new Object[]{"}"}), actualModuleName));
            constructorWriter.body().addSnippet(Snippet.format("this.%1$s = %1$s;", actualModuleName));
            moduleSelect = MemberSelect.instanceSelect(subcomponentWriter.name(), Snippet.format(actualModuleName, new Object[0]));
            componentContributionFields.put(moduleType, moduleSelect);
            subcomponentConstructorParameters.add((Object)Snippet.format("%s", variableElement.getSimpleName()));
        }
        Sets.SetView uninitializedModules = Sets.difference((Set)subgraph.transitiveModules().keySet(), componentContributionFields.keySet());
        for (TypeElement moduleType : uninitializedModules) {
            preferredModuleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, moduleType.getSimpleName().toString());
            contributionField = subcomponentWriter.addField(moduleType, preferredModuleName);
            contributionField.addModifiers(Modifier.PRIVATE, Modifier.FINAL);
            actualModuleName = contributionField.name();
            constructorWriter.body().addSnippet(Snippet.format("this.%s = new %s();", actualModuleName, ClassName.fromTypeElement(moduleType)));
            moduleSelect = MemberSelect.instanceSelect(subcomponentWriter.name(), Snippet.format(actualModuleName, new Object[0]));
            componentContributionFields.put(moduleType, moduleSelect);
        }
        componentMethod.body().addSnippet("return new %s(%s);", subcomponentWriter.name(), Snippet.makeParametersSnippet((Iterable<Snippet>)subcomponentConstructorParameters.build()));
        HashMap hashMap = Maps.newHashMap();
        HashMap multibindingContributionSnippetsBuilder = Maps.newHashMap();
        ImmutableSet.Builder enumBindingKeysBuilder = ImmutableSet.builder();
        HashMap packageProxies = Maps.newHashMap();
        this.writeFields(subgraph, subcomponentWriter, proxyWriters, hashMap, (Map<ContributionBinding, Snippet>)parentMultibindingContributionSnippets, multibindingContributionSnippetsBuilder, (ImmutableSet.Builder<BindingKey>)enumBindingKeysBuilder, packageProxies);
        for (Map.Entry parentBindingEntry : parentMemberSelectSnippets.entrySet()) {
            if (hashMap.containsKey(parentBindingEntry.getKey())) continue;
            hashMap.put(parentBindingEntry.getKey(), parentBindingEntry.getValue());
        }
        ImmutableMap memberSelectSnippets = ImmutableMap.copyOf((Map)hashMap);
        ImmutableMap multibindingContributionSnippets = ImmutableMap.copyOf((Map)multibindingContributionSnippetsBuilder);
        ImmutableSet enumBindingKeys = enumBindingKeysBuilder.build();
        this.initializeFrameworkTypes(subgraph, subcomponentWriter, constructorWriter, (Optional<ClassName>)Optional.absent(), componentContributionFields, (ImmutableMap<BindingKey, MemberSelect>)memberSelectSnippets, parentMultibindingContributionSnippets, (ImmutableMap<ContributionBinding, Snippet>)multibindingContributionSnippets);
        this.writeInterfaceMethods(subgraph, subcomponentWriter, (ImmutableMap<BindingKey, MemberSelect>)memberSelectSnippets, (ImmutableSet<BindingKey>)enumBindingKeys);
        for (Map.Entry subgraphEntry : subgraph.subgraphs().entrySet()) {
            this.writeSubcomponent(subcomponentWriter, proxyWriters, componentContributionFields, (ImmutableMap<BindingKey, MemberSelect>)memberSelectSnippets, (ImmutableMap<ContributionBinding, Snippet>)new ImmutableMap.Builder().putAll(parentMultibindingContributionSnippets).putAll((Map)multibindingContributionSnippets).build(), (ExecutableElement)subgraphEntry.getKey(), (BindingGraph)subgraphEntry.getValue());
        }
    }

    private void writeFields(BindingGraph input, ClassWriter componentWriter, Set<JavaWriter> proxyWriters, Map<BindingKey, MemberSelect> memberSelectSnippetsBuilder, Map<ContributionBinding, Snippet> parentMultibindingContributionSnippetsBuilder, Map<ContributionBinding, Snippet> multibindingContributionSnippetsBuilder, ImmutableSet.Builder<BindingKey> enumBindingKeysBuilder, Map<String, ProxyClassAndField> packageProxies) {
        for (BindingGraph.ResolvedBindings resolvedBindings : input.resolvedBindings().values()) {
            this.writeField(componentWriter, proxyWriters, memberSelectSnippetsBuilder, parentMultibindingContributionSnippetsBuilder, multibindingContributionSnippetsBuilder, enumBindingKeysBuilder, packageProxies, resolvedBindings);
        }
    }

    private void writeField(ClassWriter componentWriter, Set<JavaWriter> proxyWriters, Map<BindingKey, MemberSelect> memberSelectSnippetsBuilder, Map<ContributionBinding, Snippet> parentMultibindingContributionSnippetsBuilder, Map<ContributionBinding, Snippet> multibindingContributionSnippetsBuilder, ImmutableSet.Builder<BindingKey> enumBindingKeysBuilder, Map<String, ProxyClassAndField> packageProxies, BindingGraph.ResolvedBindings resolvedBindings) {
        ImmutableSet<? extends ContributionBinding> contributionBindings;
        EnumSet<Modifier> fieldModifiers;
        ClassWriter classWithFields;
        Optional proxySelector;
        String bindingPackage;
        BindingKey bindingKey = resolvedBindings.bindingKey();
        if (bindingKey.kind().equals((Object)BindingKey.Kind.CONTRIBUTION) && resolvedBindings.ownedContributionBindings().isEmpty() && !ContributionBinding.bindingTypeFor(resolvedBindings.contributionBindings()).isMultibinding()) {
            return;
        }
        if (resolvedBindings.bindings().size() == 1) {
            MembersInjectionBinding membersInjectionBinding;
            if (bindingKey.kind().equals((Object)BindingKey.Kind.CONTRIBUTION)) {
                ProvisionBinding provisionBinding;
                ContributionBinding contributionBinding = (ContributionBinding)Iterables.getOnlyElement(resolvedBindings.contributionBindings());
                if (contributionBinding instanceof ProvisionBinding && (provisionBinding = (ProvisionBinding)contributionBinding).factoryCreationStrategy().equals((Object)ProvisionBinding.FactoryCreationStrategy.ENUM_INSTANCE) && !provisionBinding.scope().isPresent()) {
                    enumBindingKeysBuilder.add((Object)bindingKey);
                    memberSelectSnippetsBuilder.put(bindingKey, MemberSelect.staticSelect(SourceFiles.factoryNameForProvisionBinding(provisionBinding), Snippet.format("create()", new Object[0])));
                    return;
                }
            } else if (bindingKey.kind().equals((Object)BindingKey.Kind.MEMBERS_INJECTION) && (membersInjectionBinding = (MembersInjectionBinding)Iterables.getOnlyElement(resolvedBindings.membersInjectionBindings())).injectionStrategy().equals((Object)MembersInjectionBinding.Strategy.NO_OP)) {
                enumBindingKeysBuilder.add((Object)bindingKey);
                memberSelectSnippetsBuilder.put(bindingKey, MemberSelect.staticMethodInvocationWithCast(ClassName.fromClass(MembersInjectors.class), Snippet.format("noOp()", new Object[0]), ClassName.fromClass(MembersInjector.class)));
                return;
            }
        }
        if ((bindingPackage = (String)Binding.bindingPackageFor(resolvedBindings.bindings()).or((Object)componentWriter.name().packageName())).equals(componentWriter.name().packageName())) {
            proxySelector = Optional.absent();
            classWithFields = componentWriter;
            fieldModifiers = EnumSet.of(Modifier.PRIVATE);
        } else {
            ProxyClassAndField proxyClassAndField = packageProxies.get(bindingPackage);
            if (proxyClassAndField == null) {
                JavaWriter proxyJavaWriter = JavaWriter.inPackage(bindingPackage);
                proxyWriters.add(proxyJavaWriter);
                ClassWriter proxyWriter = proxyJavaWriter.addClass(componentWriter.name().simpleName() + "_PackageProxy");
                proxyWriter.annotate(Generated.class).setValue(ComponentProcessor.class.getCanonicalName());
                proxyWriter.addModifiers(Modifier.PUBLIC, Modifier.FINAL);
                FieldWriter proxyFieldWriter = componentWriter.addField(proxyWriter.name(), bindingPackage.replace('.', '_') + "_Proxy");
                proxyFieldWriter.addModifiers(Modifier.PRIVATE, Modifier.FINAL);
                proxyFieldWriter.setInitializer("new %s()", proxyWriter.name());
                proxyClassAndField = ProxyClassAndField.create(proxyWriter, proxyFieldWriter);
                packageProxies.put(bindingPackage, proxyClassAndField);
            }
            proxySelector = Optional.of((Object)proxyClassAndField.proxyFieldWriter().name());
            classWithFields = proxyClassAndField.proxyWriter();
            fieldModifiers = EnumSet.of(Modifier.PUBLIC);
        }
        if (bindingKey.kind().equals((Object)BindingKey.Kind.CONTRIBUTION) && ContributionBinding.bindingTypeFor(contributionBindings = resolvedBindings.contributionBindings()).isMultibinding()) {
            int contributionNumber = 0;
            for (ContributionBinding contributionBinding : contributionBindings) {
                if (contributionBinding.isSyntheticBinding()) continue;
                ++contributionNumber;
                if (parentMultibindingContributionSnippetsBuilder.containsKey(contributionBinding)) continue;
                FrameworkField contributionBindingField = ComponentGenerator.frameworkFieldForSyntheticContributionBinding(bindingKey, contributionNumber, contributionBinding);
                FieldWriter contributionField = classWithFields.addField(contributionBindingField.frameworkType(), contributionBindingField.name());
                contributionField.addModifiers(fieldModifiers);
                ImmutableList contributionSelectTokens = new ImmutableList.Builder().addAll((Iterable)proxySelector.asSet()).add((Object)contributionField.name()).build();
                multibindingContributionSnippetsBuilder.put(contributionBinding, Snippet.memberSelectSnippet((Iterable<? extends Object>)contributionSelectTokens));
            }
        }
        FrameworkField bindingField = this.frameworkFieldForResolvedBindings(resolvedBindings);
        FieldWriter frameworkField = classWithFields.addField(bindingField.frameworkType(), bindingField.name());
        frameworkField.addModifiers(fieldModifiers);
        ImmutableList memberSelectTokens = new ImmutableList.Builder().addAll((Iterable)proxySelector.asSet()).add((Object)frameworkField.name()).build();
        memberSelectSnippetsBuilder.put(bindingKey, MemberSelect.instanceSelect(componentWriter.name(), Snippet.memberSelectSnippet((Iterable<? extends Object>)memberSelectTokens)));
    }

    private void writeInterfaceMethods(BindingGraph input, ClassWriter componentWriter, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets, ImmutableSet<BindingKey> enumBindingKeys) throws AssertionError {
        HashSet interfaceMethods = Sets.newHashSet();
        block5: for (ComponentDescriptor.ComponentMethodDescriptor componentMethod : input.componentDescriptor().componentMethods()) {
            if (!componentMethod.dependencyRequest().isPresent()) continue;
            DependencyRequest interfaceRequest = (DependencyRequest)componentMethod.dependencyRequest().get();
            ExecutableElement requestElement = MoreElements.asExecutable(interfaceRequest.requestElement());
            ExecutableType requestType = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(input.componentDescriptor().componentDefinitionType().asType()), requestElement));
            MethodSignature signature = MethodSignature.fromExecutableType(requestElement.getSimpleName().toString(), requestType);
            if (interfaceMethods.contains(signature)) continue;
            interfaceMethods.add(signature);
            MethodWriter interfaceMethod = requestType.getReturnType().getKind().equals((Object)TypeKind.VOID) ? componentWriter.addMethod(VoidName.VOID, requestElement.getSimpleName().toString()) : componentWriter.addMethod(requestType.getReturnType(), requestElement.getSimpleName().toString());
            interfaceMethod.annotate(Override.class);
            interfaceMethod.addModifiers(Modifier.PUBLIC, new Modifier[0]);
            BindingKey bindingKey = interfaceRequest.bindingKey();
            switch (interfaceRequest.kind()) {
                case MEMBERS_INJECTOR: {
                    MemberSelect membersInjectorSelect = (MemberSelect)memberSelectSnippets.get((Object)bindingKey);
                    List<? extends VariableElement> parameters = requestElement.getParameters();
                    if (parameters.isEmpty()) {
                        interfaceMethod.body().addSnippet("return %s;", membersInjectorSelect.getSnippetFor(componentWriter.name()));
                        break;
                    }
                    VariableElement parameter = (VariableElement)Iterables.getOnlyElement(parameters);
                    Name parameterName = parameter.getSimpleName();
                    interfaceMethod.addParameter(TypeNames.forTypeMirror((TypeMirror)Iterables.getOnlyElement(requestType.getParameterTypes())), parameterName.toString());
                    interfaceMethod.body().addSnippet("%s.injectMembers(%s);", membersInjectorSelect.getSnippetFor(componentWriter.name()), parameterName);
                    if (requestType.getReturnType().getKind().equals((Object)TypeKind.VOID)) continue block5;
                    interfaceMethod.body().addSnippet("return %s;", parameterName);
                    break;
                }
                case INSTANCE: {
                    if (enumBindingKeys.contains((Object)bindingKey) && !MoreTypes.asDeclared(bindingKey.key().type()).getTypeArguments().isEmpty()) {
                        ParameterizedTypeName factoryType = ParameterizedTypeName.create(Provider.class, TypeNames.forTypeMirror(requestType.getReturnType()));
                        interfaceMethod.body().addSnippet("%s factory = %s;", factoryType, ((MemberSelect)memberSelectSnippets.get((Object)bindingKey)).getSnippetFor(componentWriter.name()));
                        interfaceMethod.body().addSnippet("return factory.get();", new Object[0]);
                        break;
                    }
                }
                case LAZY: 
                case PRODUCED: 
                case PRODUCER: 
                case PROVIDER: 
                case FUTURE: {
                    interfaceMethod.body().addSnippet("return %s;", SourceFiles.frameworkTypeUsageStatement(((MemberSelect)memberSelectSnippets.get((Object)bindingKey)).getSnippetFor(componentWriter.name()), interfaceRequest.kind()));
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
    }

    private void initializeFrameworkTypes(BindingGraph input, ClassWriter componentWriter, ConstructorWriter constructorWriter, Optional<ClassName> builderName, Map<TypeElement, MemberSelect> componentContributionFields, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets, ImmutableMap<ContributionBinding, Snippet> parentMultibindingContributionSnippets, ImmutableMap<ContributionBinding, Snippet> multibindingContributionSnippets) throws AssertionError {
        List partitions = Lists.partition((List)input.resolvedBindings().keySet().asList(), (int)100);
        for (int i = 0; i < partitions.size(); ++i) {
            MethodWriter initializeMethod = componentWriter.addMethod(VoidName.VOID, "initialize" + (i == 0 ? "" : Integer.valueOf(i)));
            initializeMethod.body();
            initializeMethod.addModifiers(Modifier.PRIVATE, new Modifier[0]);
            if (builderName.isPresent()) {
                initializeMethod.addParameter((TypeName)builderName.get(), "builder").addModifiers(Modifier.FINAL, new Modifier[0]);
                constructorWriter.body().addSnippet("%s(builder);", initializeMethod.name());
            } else {
                constructorWriter.body().addSnippet("%s();", initializeMethod.name());
            }
            block10: for (BindingKey bindingKey : (List)partitions.get(i)) {
                Snippet memberSelectSnippet = ((MemberSelect)memberSelectSnippets.get((Object)bindingKey)).getSnippetFor(componentWriter.name());
                BindingGraph.ResolvedBindings resolvedBindings = (BindingGraph.ResolvedBindings)input.resolvedBindings().get((Object)bindingKey);
                block0 : switch (bindingKey.kind()) {
                    case CONTRIBUTION: {
                        ImmutableSet<? extends ContributionBinding> bindings = resolvedBindings.contributionBindings();
                        switch (ContributionBinding.bindingTypeFor(bindings)) {
                            case SET: {
                                boolean hasOnlyProvisions = Iterables.all(bindings, (Predicate)Predicates.instanceOf(ProvisionBinding.class));
                                ImmutableList.Builder parameterSnippets = ImmutableList.builder();
                                for (ContributionBinding binding : bindings) {
                                    if (multibindingContributionSnippets.containsKey((Object)binding)) {
                                        Snippet initializeSnippet = this.initializeFactoryForContributionBinding(binding, input, componentWriter.name(), componentContributionFields, memberSelectSnippets);
                                        Snippet snippet = (Snippet)multibindingContributionSnippets.get((Object)binding);
                                        initializeMethod.body().addSnippet("this.%s = %s;", snippet, initializeSnippet);
                                        parameterSnippets.add((Object)snippet);
                                        continue;
                                    }
                                    if (parentMultibindingContributionSnippets.containsKey((Object)binding)) {
                                        parameterSnippets.add(parentMultibindingContributionSnippets.get((Object)binding));
                                        continue;
                                    }
                                    throw new IllegalStateException();
                                }
                                Snippet initializeSetSnippet = Snippet.format("%s.create(%s)", hasOnlyProvisions ? ClassName.fromClass(SetFactory.class) : ClassName.fromClass(SetProducer.class), Snippet.makeParametersSnippet((Iterable<Snippet>)parameterSnippets.build()));
                                initializeMethod.body().addSnippet("this.%s = %s;", memberSelectSnippet, initializeSetSnippet);
                                break block0;
                            }
                            case MAP: {
                                if (Sets.filter(bindings, (Predicate)Predicates.instanceOf(ProductionBinding.class)).isEmpty()) {
                                    ImmutableSet<? extends ContributionBinding> provisionBindings = bindings;
                                    for (ProvisionBinding provisionBinding : provisionBindings) {
                                        if (this.isNonProviderMap(provisionBinding) || !multibindingContributionSnippets.containsKey((Object)provisionBinding)) continue;
                                        Snippet snippet = (Snippet)multibindingContributionSnippets.get((Object)provisionBinding);
                                        initializeMethod.body().addSnippet("this.%s = %s;", snippet, this.initializeFactoryForProvisionBinding(provisionBinding, componentWriter.name(), input.componentDescriptor().dependencyMethodIndex(), componentContributionFields, memberSelectSnippets));
                                    }
                                    if (provisionBindings.isEmpty()) continue block10;
                                    Snippet initializeMapSnippet = this.initializeMapBinding(componentWriter.name(), memberSelectSnippets, (ImmutableMap<ContributionBinding, Snippet>)new ImmutableMap.Builder().putAll(parentMultibindingContributionSnippets).putAll(multibindingContributionSnippets).build(), (Set<ProvisionBinding>)provisionBindings);
                                    initializeMethod.body().addSnippet("this.%s = %s;", memberSelectSnippet, initializeMapSnippet);
                                    break block0;
                                }
                                throw new IllegalStateException("producer map bindings not implemented yet");
                            }
                            case UNIQUE: {
                                ContributionBinding binding;
                                if (resolvedBindings.ownedContributionBindings().isEmpty()) continue block10;
                                binding = (ContributionBinding)Iterables.getOnlyElement(bindings);
                                if (binding instanceof ProvisionBinding) {
                                    ProvisionBinding provisionBinding = (ProvisionBinding)binding;
                                    if (provisionBinding.factoryCreationStrategy().equals((Object)ProvisionBinding.FactoryCreationStrategy.ENUM_INSTANCE) && !provisionBinding.scope().isPresent()) continue block10;
                                    initializeMethod.body().addSnippet("this.%s = %s;", memberSelectSnippet, this.initializeFactoryForProvisionBinding(provisionBinding, componentWriter.name(), input.componentDescriptor().dependencyMethodIndex(), componentContributionFields, memberSelectSnippets));
                                    break block0;
                                }
                                if (binding instanceof ProductionBinding) {
                                    ProductionBinding productionBinding = (ProductionBinding)binding;
                                    initializeMethod.body().addSnippet("this.%s = %s;", memberSelectSnippet, this.initializeFactoryForProductionBinding(productionBinding, input, componentWriter.name(), input.componentDescriptor().dependencyMethodIndex(), componentContributionFields, memberSelectSnippets));
                                    break block0;
                                }
                                throw new AssertionError();
                            }
                            default: {
                                throw new IllegalStateException();
                            }
                        }
                    }
                    case MEMBERS_INJECTION: {
                        MembersInjectionBinding binding = (MembersInjectionBinding)Iterables.getOnlyElement(resolvedBindings.membersInjectionBindings());
                        if (binding.injectionStrategy().equals((Object)MembersInjectionBinding.Strategy.NO_OP)) continue block10;
                        initializeMethod.body().addSnippet("this.%s = %s;", memberSelectSnippet, this.initializeMembersInjectorForBinding(componentWriter.name(), binding, memberSelectSnippets));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
        }
    }

    private static FrameworkField frameworkFieldForSyntheticContributionBinding(BindingKey bindingKey, int contributionNumber, ContributionBinding contributionBinding) throws AssertionError {
        switch (contributionBinding.bindingType()) {
            case MAP: {
                return FrameworkField.createForMapBindingContribution(contributionBinding.frameworkClass(), BindingKey.create(bindingKey.kind(), contributionBinding.key()), KeyVariableNamer.INSTANCE.apply(bindingKey.key()) + "Contribution" + contributionNumber);
            }
            case SET: {
                return FrameworkField.createWithTypeFromKey(contributionBinding.frameworkClass(), bindingKey, KeyVariableNamer.INSTANCE.apply(bindingKey.key()) + "Contribution" + contributionNumber);
            }
            case UNIQUE: {
                return FrameworkField.createWithTypeFromKey(contributionBinding.frameworkClass(), bindingKey, KeyVariableNamer.INSTANCE.apply(bindingKey.key()) + "Contribution" + contributionNumber);
            }
        }
        throw new AssertionError();
    }

    private static Class<?> frameworkClassForResolvedBindings(BindingGraph.ResolvedBindings resolvedBindings) {
        switch (resolvedBindings.bindingKey().kind()) {
            case CONTRIBUTION: {
                for (ContributionBinding binding : resolvedBindings.contributionBindings()) {
                    if (!(binding instanceof ProductionBinding)) continue;
                    return Producer.class;
                }
                return Provider.class;
            }
            case MEMBERS_INJECTION: {
                return MembersInjector.class;
            }
        }
        throw new AssertionError();
    }

    private FrameworkField frameworkFieldForResolvedBindings(BindingGraph.ResolvedBindings resolvedBindings) {
        BindingKey bindingKey = resolvedBindings.bindingKey();
        switch (bindingKey.kind()) {
            case CONTRIBUTION: {
                ImmutableSet<? extends ContributionBinding> contributionBindings = resolvedBindings.contributionBindings();
                ContributionBinding.BindingType bindingsType = ProvisionBinding.bindingTypeFor(contributionBindings);
                switch (bindingsType) {
                    case SET: 
                    case MAP: {
                        return FrameworkField.createWithTypeFromKey(ComponentGenerator.frameworkClassForResolvedBindings(resolvedBindings), bindingKey, KeyVariableNamer.INSTANCE.apply(bindingKey.key()));
                    }
                    case UNIQUE: {
                        ContributionBinding binding = (ContributionBinding)Iterables.getOnlyElement(contributionBindings);
                        return FrameworkField.createWithTypeFromKey(ComponentGenerator.frameworkClassForResolvedBindings(resolvedBindings), bindingKey, binding.bindingElement().accept(new ElementKindVisitor6<String, Void>(){

                            @Override
                            public String visitExecutableAsConstructor(ExecutableElement e, Void p) {
                                return e.getEnclosingElement().accept(this, null);
                            }

                            @Override
                            public String visitExecutableAsMethod(ExecutableElement e, Void p) {
                                return e.getSimpleName().toString();
                            }

                            @Override
                            public String visitType(TypeElement e, Void p) {
                                return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, e.getSimpleName().toString());
                            }
                        }, null));
                    }
                }
                throw new AssertionError();
            }
            case MEMBERS_INJECTION: {
                return FrameworkField.createWithTypeFromKey(MembersInjector.class, bindingKey, CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, ((Binding)Iterables.getOnlyElement(resolvedBindings.bindings())).bindingElement().getSimpleName().toString()));
            }
        }
        throw new AssertionError();
    }

    private Snippet initializeFactoryForContributionBinding(ContributionBinding binding, BindingGraph input, ClassName componentName, Map<TypeElement, MemberSelect> componentContributionFields, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets) {
        if (binding instanceof ProvisionBinding) {
            return this.initializeFactoryForProvisionBinding((ProvisionBinding)binding, componentName, input.componentDescriptor().dependencyMethodIndex(), componentContributionFields, memberSelectSnippets);
        }
        if (binding instanceof ProductionBinding) {
            return this.initializeFactoryForProductionBinding((ProductionBinding)binding, input, componentName, input.componentDescriptor().dependencyMethodIndex(), componentContributionFields, memberSelectSnippets);
        }
        throw new AssertionError();
    }

    private Snippet initializeFactoryForProvisionBinding(ProvisionBinding binding, ClassName componentName, ImmutableMap<ExecutableElement, TypeElement> dependencyMethodIndex, Map<TypeElement, MemberSelect> contributionFields, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets) {
        switch (binding.bindingKind()) {
            case COMPONENT: {
                return Snippet.format("%s.<%s>create(this)", ClassName.fromClass(InstanceFactory.class), TypeNames.forTypeMirror(binding.key().type()));
            }
            case COMPONENT_PROVISION: {
                if (binding.nullableType().isPresent() || this.nullableValidationType.equals((Object)Diagnostic.Kind.WARNING)) {
                    Snippet nullableSnippet = binding.nullableType().isPresent() ? Snippet.format("@%s ", TypeNames.forTypeMirror((TypeMirror)binding.nullableType().get())) : Snippet.format("", new Object[0]);
                    return Snippet.format(Joiner.on((char)'\n').join((Object)"new %s<%2$s>() {", (Object)"  %5$s@Override public %2$s get() {", new Object[]{"    return %3$s.%4$s();", "  }", "}"}), ClassName.fromClass(Factory.class), TypeNames.forTypeMirror(binding.key().type()), contributionFields.get(dependencyMethodIndex.get((Object)binding.bindingElement())).getSnippetFor(componentName), binding.bindingElement().getSimpleName().toString(), nullableSnippet);
                }
                StringLiteral failMsg = StringLiteral.forValue("Cannot return null from a non-@Nullable component method");
                return Snippet.format(Joiner.on((char)'\n').join((Object)"new %s<%2$s>() {", (Object)"  @Override public %2$s get() {", new Object[]{"    %2$s provided = %3$s.%4$s();", "    if (provided == null) {", "      throw new NullPointerException(%5$s);", "    }", "    return provided;", "  }", "}"}), ClassName.fromClass(Factory.class), TypeNames.forTypeMirror(binding.key().type()), contributionFields.get(dependencyMethodIndex.get((Object)binding.bindingElement())).getSnippetFor(componentName), binding.bindingElement().getSimpleName().toString(), failMsg);
            }
            case INJECTION: 
            case PROVISION: {
                ArrayList parameters = Lists.newArrayListWithCapacity((int)(binding.dependencies().size() + 1));
                if (binding.bindingKind().equals((Object)ProvisionBinding.Kind.PROVISION)) {
                    parameters.add(contributionFields.get(binding.contributedBy().get()).getSnippetFor(componentName));
                }
                parameters.addAll(this.getDependencyParameters(componentName, (Iterable<DependencyRequest>)binding.implicitDependencies(), memberSelectSnippets));
                Snippet factorySnippet = Snippet.format("%s.create(%s)", SourceFiles.factoryNameForProvisionBinding(binding), Snippet.makeParametersSnippet(parameters));
                return binding.scope().isPresent() ? Snippet.format("%s.create(%s)", ClassName.fromClass(ScopedProvider.class), factorySnippet) : factorySnippet;
            }
        }
        throw new AssertionError();
    }

    private Snippet initializeFactoryForProductionBinding(ProductionBinding binding, BindingGraph bindingGraph, ClassName componentName, ImmutableMap<ExecutableElement, TypeElement> dependencyMethodIndex, Map<TypeElement, MemberSelect> contributionFields, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets) {
        switch (binding.bindingKind()) {
            case COMPONENT_PRODUCTION: {
                return Snippet.format(Joiner.on((char)'\n').join((Object)"new %s<%2$s>() {", (Object)"  @Override public %3$s<%2$s> get() {", new Object[]{"    return %4$s.%5$s();", "  }", "}"}), ClassName.fromClass(Producer.class), TypeNames.forTypeMirror(binding.key().type()), ClassName.fromClass(ListenableFuture.class), contributionFields.get(dependencyMethodIndex.get((Object)binding.bindingElement())).getSnippetFor(componentName), binding.bindingElement().getSimpleName().toString());
            }
            case IMMEDIATE: 
            case FUTURE_PRODUCTION: {
                ArrayList parameters = Lists.newArrayListWithCapacity((int)(binding.dependencies().size() + 2));
                parameters.add(contributionFields.get(binding.bindingTypeElement()).getSnippetFor(componentName));
                parameters.add(contributionFields.get(bindingGraph.componentDescriptor().executorDependency().get()).getSnippetFor(componentName));
                parameters.addAll(this.getProducerDependencyParameters(bindingGraph, componentName, (Iterable<DependencyRequest>)binding.dependencies(), memberSelectSnippets));
                return Snippet.format("new %s(%s)", SourceFiles.factoryNameForProductionBinding(binding), Snippet.makeParametersSnippet(parameters));
            }
        }
        throw new AssertionError();
    }

    private Snippet initializeMembersInjectorForBinding(ClassName componentName, MembersInjectionBinding binding, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets) {
        switch (binding.injectionStrategy()) {
            case NO_OP: {
                return Snippet.format("%s.noOp()", ClassName.fromClass(MembersInjectors.class));
            }
            case DELEGATE: {
                DependencyRequest parentInjectorRequest = (DependencyRequest)binding.parentInjectorRequest().get();
                return Snippet.format("%s.delegatingTo(%s)", ClassName.fromClass(MembersInjectors.class), ((MemberSelect)memberSelectSnippets.get((Object)parentInjectorRequest.bindingKey())).getSnippetFor(componentName));
            }
            case INJECT_MEMBERS: {
                List<Snippet> parameters = this.getDependencyParameters(componentName, (Iterable<DependencyRequest>)binding.implicitDependencies(), memberSelectSnippets);
                return Snippet.format("%s.create(%s)", SourceFiles.membersInjectorNameForMembersInjectionBinding(binding), Snippet.makeParametersSnippet(parameters));
            }
        }
        throw new AssertionError();
    }

    private List<Snippet> getDependencyParameters(ClassName componentName, Iterable<DependencyRequest> dependencies, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (Collection requestsForKey : SourceFiles.indexDependenciesByUnresolvedKey(this.types, dependencies).asMap().values()) {
            BindingKey key = (BindingKey)Iterables.getOnlyElement((Iterable)FluentIterable.from((Iterable)requestsForKey).transform((Function)new Function<DependencyRequest, BindingKey>(){

                public BindingKey apply(DependencyRequest request) {
                    return request.bindingKey();
                }
            }).toSet());
            parameters.add((Object)((MemberSelect)memberSelectSnippets.get((Object)key)).getSnippetWithRawTypeCastFor(componentName));
        }
        return parameters.build();
    }

    private List<Snippet> getProducerDependencyParameters(BindingGraph bindingGraph, ClassName componentName, Iterable<DependencyRequest> dependencies, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets) {
        ImmutableList.Builder parameters = ImmutableList.builder();
        for (Collection requestsForKey : SourceFiles.indexDependenciesByUnresolvedKey(this.types, dependencies).asMap().values()) {
            BindingKey key = (BindingKey)Iterables.getOnlyElement((Iterable)FluentIterable.from((Iterable)requestsForKey).transform((Function)new Function<DependencyRequest, BindingKey>(){

                public BindingKey apply(DependencyRequest request) {
                    return request.bindingKey();
                }
            }));
            BindingGraph.ResolvedBindings resolvedBindings = (BindingGraph.ResolvedBindings)bindingGraph.resolvedBindings().get((Object)key);
            Class<?> frameworkClass = DependencyRequestMapper.FOR_PRODUCER.getFrameworkClass(requestsForKey);
            if (ComponentGenerator.frameworkClassForResolvedBindings(resolvedBindings).equals(Provider.class) && frameworkClass.equals(Producer.class)) {
                parameters.add((Object)Snippet.format("%s.producerFromProvider(%s)", ClassName.fromClass(Producers.class), ((MemberSelect)memberSelectSnippets.get((Object)key)).getSnippetFor(componentName)));
                continue;
            }
            parameters.add((Object)((MemberSelect)memberSelectSnippets.get((Object)key)).getSnippetFor(componentName));
        }
        return parameters.build();
    }

    private Snippet initializeMapBinding(ClassName componentName, ImmutableMap<BindingKey, MemberSelect> memberSelectSnippets, ImmutableMap<ContributionBinding, Snippet> multibindingContributionSnippets, Set<ProvisionBinding> bindings) {
        Iterator<ProvisionBinding> iterator = bindings.iterator();
        ProvisionBinding firstBinding = iterator.next();
        if (this.isNonProviderMap(firstBinding)) {
            return Snippet.format("%s.create(%s)", ClassName.fromClass(MapFactory.class), ((MemberSelect)memberSelectSnippets.get((Object)((DependencyRequest)Iterables.getOnlyElement(firstBinding.dependencies())).bindingKey())).getSnippetFor(componentName));
        }
        DeclaredType mapType = MoreTypes.asDeclared(firstBinding.key().type());
        DeclaredType mapKeyType = Util.getKeyTypeOfMap(mapType);
        TypeMirror mapValueType = Util.getProvidedValueTypeOfMap(mapType);
        StringBuilder snippetFormatBuilder = new StringBuilder("%s.<%s, %s>builder(%d)");
        for (int i = 0; i < bindings.size(); ++i) {
            snippetFormatBuilder.append("\n    .put(%s, %s)");
        }
        snippetFormatBuilder.append("\n    .build()");
        ArrayList argsBuilder = Lists.newArrayList();
        argsBuilder.add(ClassName.fromClass(MapProviderFactory.class));
        argsBuilder.add(TypeNames.forTypeMirror(mapKeyType));
        argsBuilder.add(TypeNames.forTypeMirror(mapValueType));
        argsBuilder.add(bindings.size());
        this.writeEntry(argsBuilder, firstBinding, (Snippet)multibindingContributionSnippets.get((Object)firstBinding));
        while (iterator.hasNext()) {
            ProvisionBinding binding = iterator.next();
            this.writeEntry(argsBuilder, binding, (Snippet)multibindingContributionSnippets.get((Object)binding));
        }
        return Snippet.format(snippetFormatBuilder.toString(), argsBuilder.toArray(new Object[0]));
    }

    private void writeEntry(List<Object> argsBuilder, Binding binding, Snippet factory) {
        AnnotationMirror mapKeyAnnotationMirror = (AnnotationMirror)Iterables.getOnlyElement(ConfigurationAnnotations.getMapKeys(binding.bindingElement()));
        Map<? extends ExecutableElement, ? extends AnnotationValue> map = mapKeyAnnotationMirror.getElementValues();
        MapKey mapKey = mapKeyAnnotationMirror.getAnnotationType().asElement().getAnnotation(MapKey.class);
        if (!mapKey.unwrapValue()) {
            FluentIterable originIterable = FluentIterable.from(AnnotationMirrors.getAnnotationValuesWithDefaults(mapKeyAnnotationMirror).values());
            FluentIterable annotationValueNames = originIterable.transform((Function)new Function<AnnotationValue, Snippet>(){

                public Snippet apply(AnnotationValue value) {
                    return ComponentGenerator.this.getValueSnippet(value);
                }
            });
            ImmutableList.Builder snippets = ImmutableList.builder();
            for (Snippet snippet : annotationValueNames) {
                snippets.add((Object)snippet);
            }
            argsBuilder.add(Snippet.format("%sCreator.create(%s)", TypeNames.forTypeMirror(mapKeyAnnotationMirror.getAnnotationType()), Snippet.makeParametersSnippet((Iterable<Snippet>)snippets.build())));
            argsBuilder.add(factory);
        } else {
            argsBuilder.add(((Map.Entry)Iterables.getOnlyElement(map.entrySet())).getValue());
            argsBuilder.add(factory);
        }
    }

    private Snippet getValueSnippet(AnnotationValue value) {
        SimpleAnnotationValueVisitor6<Snippet, Void> mapKeyVisitor = new SimpleAnnotationValueVisitor6<Snippet, Void>(){

            @Override
            public Snippet visitEnumConstant(VariableElement c, Void p) {
                return Snippet.format("%s.%s", TypeNames.forTypeMirror(c.getEnclosingElement().asType()), c.getSimpleName());
            }

            @Override
            public Snippet visitAnnotation(AnnotationMirror a, Void p) {
                if (a.getElementValues().isEmpty()) {
                    return Snippet.format("@%s", TypeNames.forTypeMirror(a.getAnnotationType()));
                }
                Map<ExecutableElement, AnnotationValue> map = AnnotationMirrors.getAnnotationValuesWithDefaults(a);
                ImmutableList.Builder snippets = ImmutableList.builder();
                for (Map.Entry<ExecutableElement, AnnotationValue> entry : map.entrySet()) {
                    snippets.add((Object)Snippet.format("%s = %s", TypeNames.forTypeMirror(entry.getKey().asType()), ComponentGenerator.this.getValueSnippet(entry.getValue())));
                }
                return Snippet.format("@%s(%s)", TypeNames.forTypeMirror(a.getAnnotationType()), Snippet.makeParametersSnippet((Iterable<Snippet>)snippets.build()));
            }

            @Override
            public Snippet visitType(TypeMirror t, Void p) {
                return Snippet.format("%s", TypeNames.forTypeMirror(t));
            }

            @Override
            public Snippet visitString(String s, Void p) {
                return Snippet.format("\"%s\"", s);
            }

            @Override
            protected Snippet defaultAction(Object o, Void v) {
                return Snippet.format("%s", o);
            }

            @Override
            public Snippet visitArray(List<? extends AnnotationValue> values, Void v) {
                ImmutableList.Builder snippets = ImmutableList.builder();
                for (int i = 0; i < values.size(); ++i) {
                    snippets.add((Object)values.get(i).accept(this, null));
                }
                return Snippet.format("[%s]", Snippet.makeParametersSnippet((Iterable<Snippet>)snippets.build()));
            }
        };
        return value.accept(mapKeyVisitor, null);
    }

    private boolean isNonProviderMap(Binding binding) {
        TypeMirror bindingType = binding.key().type();
        return MoreTypes.isTypeOf(Map.class, bindingType) && !MoreTypes.isTypeOf(Provider.class, MoreTypes.asDeclared(bindingType).getTypeArguments().get(1));
    }

    static abstract class MemberSelect {
        MemberSelect() {
        }

        static MemberSelect instanceSelect(ClassName owningClass, Snippet snippet) {
            return new AutoValue_ComponentGenerator_MemberSelect((Optional<TypeName>)Optional.absent(), owningClass, false, snippet);
        }

        static MemberSelect staticSelect(ClassName owningClass, Snippet snippet) {
            return new AutoValue_ComponentGenerator_MemberSelect((Optional<TypeName>)Optional.absent(), owningClass, true, snippet);
        }

        static MemberSelect staticMethodInvocationWithCast(ClassName owningClass, Snippet snippet, TypeName castType) {
            return new AutoValue_ComponentGenerator_MemberSelect((Optional<TypeName>)Optional.of((Object)castType), owningClass, true, snippet);
        }

        abstract Optional<TypeName> selectedCast();

        abstract ClassName owningClass();

        abstract boolean staticMember();

        abstract Snippet snippet();

        private Snippet qualifiedSelectSnippet() {
            return Snippet.format("%s" + (this.staticMember() ? "" : ".this") + ".%s", this.owningClass(), this.snippet());
        }

        Snippet getSnippetWithRawTypeCastFor(ClassName usingClass) {
            Snippet snippet = this.getSnippetFor(usingClass);
            return this.selectedCast().isPresent() ? Snippet.format("(%s) %s", this.selectedCast().get(), snippet) : snippet;
        }

        Snippet getSnippetFor(ClassName usingClass) {
            return this.owningClass().equals(usingClass) ? this.snippet() : this.qualifiedSelectSnippet();
        }
    }

    static abstract class ProxyClassAndField {
        ProxyClassAndField() {
        }

        abstract ClassWriter proxyWriter();

        abstract FieldWriter proxyFieldWriter();

        static ProxyClassAndField create(ClassWriter proxyWriter, FieldWriter proxyFieldWriter) {
            return new AutoValue_ComponentGenerator_ProxyClassAndField(proxyWriter, proxyFieldWriter);
        }
    }
}

