/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingGraphValidator;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentGenerator;
import dagger.internal.codegen.ComponentProcessingStep;
import dagger.internal.codegen.ComponentValidator;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.DependencyRequestFormatter;
import dagger.internal.codegen.DependencyRequestMapper;
import dagger.internal.codegen.FactoryGenerator;
import dagger.internal.codegen.InjectBindingRegistry;
import dagger.internal.codegen.InjectConstructorValidator;
import dagger.internal.codegen.InjectFieldValidator;
import dagger.internal.codegen.InjectMethodValidator;
import dagger.internal.codegen.InjectProcessingStep;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.KeyFormatter;
import dagger.internal.codegen.MapKeyGenerator;
import dagger.internal.codegen.MapKeyProcessingStep;
import dagger.internal.codegen.MapKeyValidator;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MembersInjectorGenerator;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.ModuleProcessingStep;
import dagger.internal.codegen.ModuleValidator;
import dagger.internal.codegen.ProducerFactoryGenerator;
import dagger.internal.codegen.ProducerModuleProcessingStep;
import dagger.internal.codegen.ProducesMethodValidator;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProductionBindingFormatter;
import dagger.internal.codegen.ProductionComponentProcessingStep;
import dagger.internal.codegen.ProductionComponentValidator;
import dagger.internal.codegen.ProvidesMethodValidator;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.ProvisionBindingFormatter;
import dagger.internal.codegen.SourceFileGenerationException;
import dagger.internal.codegen.ValidationType;
import dagger.producers.ProducerModule;
import dagger.producers.Produces;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@AutoService(value=Processor.class)
public final class ComponentProcessor
extends BasicAnnotationProcessor {
    private InjectBindingRegistry injectBindingRegistry;
    private static final String DISABLE_INTER_COMPONENT_SCOPE_VALIDATION_KEY = "dagger.disableInterComponentScopeValidation";
    private static final String NULLABLE_VALIDATION_KEY = "dagger.nullableValidation";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedOptions() {
        return ImmutableSet.of((Object)DISABLE_INTER_COMPONENT_SCOPE_VALIDATION_KEY, (Object)NULLABLE_VALIDATION_KEY);
    }

    protected Iterable<BasicAnnotationProcessor.ProcessingStep> initSteps() {
        Messager messager = this.processingEnv.getMessager();
        Types types = this.processingEnv.getTypeUtils();
        Elements elements = this.processingEnv.getElementUtils();
        Filer filer = this.processingEnv.getFiler();
        Diagnostic.Kind nullableDiagnosticType = (Diagnostic.Kind)((Object)ComponentProcessor.nullableValidationType(this.processingEnv).diagnosticKind().get());
        MethodSignatureFormatter methodSignatureFormatter = new MethodSignatureFormatter(types);
        ProvisionBindingFormatter provisionBindingFormatter = new ProvisionBindingFormatter(methodSignatureFormatter);
        ProductionBindingFormatter productionBindingFormatter = new ProductionBindingFormatter(methodSignatureFormatter);
        DependencyRequestFormatter dependencyRequestFormatter = new DependencyRequestFormatter(types);
        KeyFormatter keyFormatter = new KeyFormatter();
        InjectConstructorValidator injectConstructorValidator = new InjectConstructorValidator();
        InjectFieldValidator injectFieldValidator = new InjectFieldValidator();
        InjectMethodValidator injectMethodValidator = new InjectMethodValidator();
        ModuleValidator moduleValidator = new ModuleValidator(types, elements, methodSignatureFormatter, Module.class, Provides.class);
        ProvidesMethodValidator providesMethodValidator = new ProvidesMethodValidator(elements);
        ComponentValidator componentValidator = new ComponentValidator(elements, types, moduleValidator);
        MapKeyValidator mapKeyValidator = new MapKeyValidator();
        ModuleValidator producerModuleValidator = new ModuleValidator(types, elements, methodSignatureFormatter, ProducerModule.class, Produces.class);
        ProducesMethodValidator producesMethodValidator = new ProducesMethodValidator(elements);
        ProductionComponentValidator productionComponentValidator = new ProductionComponentValidator();
        Key.Factory keyFactory = new Key.Factory(types, elements);
        FactoryGenerator factoryGenerator = new FactoryGenerator(filer, DependencyRequestMapper.FOR_PROVIDER, nullableDiagnosticType);
        MembersInjectorGenerator membersInjectorGenerator = new MembersInjectorGenerator(filer, elements, types, DependencyRequestMapper.FOR_PROVIDER);
        ComponentGenerator componentGenerator = new ComponentGenerator(filer, types, nullableDiagnosticType);
        ProducerFactoryGenerator producerFactoryGenerator = new ProducerFactoryGenerator(filer, DependencyRequestMapper.FOR_PRODUCER);
        DependencyRequest.Factory dependencyRequestFactory = new DependencyRequest.Factory(keyFactory);
        ProvisionBinding.Factory provisionBindingFactory = new ProvisionBinding.Factory(elements, types, keyFactory, dependencyRequestFactory);
        ProductionBinding.Factory productionBindingFactory = new ProductionBinding.Factory(types, keyFactory, dependencyRequestFactory);
        MembersInjectionBinding.Factory membersInjectionBindingFactory = new MembersInjectionBinding.Factory(elements, types, keyFactory, dependencyRequestFactory);
        this.injectBindingRegistry = new InjectBindingRegistry(elements, types, messager, provisionBindingFactory, factoryGenerator, membersInjectionBindingFactory, membersInjectorGenerator);
        ComponentDescriptor.Factory componentDescriptorFactory = new ComponentDescriptor.Factory(elements, types, dependencyRequestFactory);
        BindingGraph.Factory bindingGraphFactory = new BindingGraph.Factory(elements, types, this.injectBindingRegistry, keyFactory, dependencyRequestFactory, provisionBindingFactory, productionBindingFactory);
        MapKeyGenerator mapKeyGenerator = new MapKeyGenerator(filer);
        BindingGraphValidator bindingGraphValidator = new BindingGraphValidator(types, this.injectBindingRegistry, ComponentProcessor.scopeValidationType(this.processingEnv), nullableDiagnosticType, provisionBindingFormatter, productionBindingFormatter, methodSignatureFormatter, dependencyRequestFormatter, keyFormatter);
        return ImmutableList.of((Object)new MapKeyProcessingStep(messager, mapKeyValidator, mapKeyGenerator), (Object)new InjectProcessingStep(messager, injectConstructorValidator, injectFieldValidator, injectMethodValidator, provisionBindingFactory, membersInjectionBindingFactory, this.injectBindingRegistry), (Object)new ModuleProcessingStep(messager, moduleValidator, providesMethodValidator, provisionBindingFactory, factoryGenerator), (Object)new ComponentProcessingStep(messager, componentValidator, bindingGraphValidator, componentDescriptorFactory, bindingGraphFactory, componentGenerator), (Object)new ProducerModuleProcessingStep(messager, producerModuleValidator, producesMethodValidator, productionBindingFactory, producerFactoryGenerator), (Object)new ProductionComponentProcessingStep(messager, productionComponentValidator, bindingGraphValidator, componentDescriptorFactory, bindingGraphFactory, componentGenerator));
    }

    @Override
    protected void postProcess() {
        try {
            this.injectBindingRegistry.generateSourcesForRequiredBindings();
        }
        catch (SourceFileGenerationException e) {
            e.printMessageTo(this.processingEnv.getMessager());
        }
    }

    private static ValidationType scopeValidationType(ProcessingEnvironment processingEnv) {
        return ComponentProcessor.validationTypeFor(processingEnv, DISABLE_INTER_COMPONENT_SCOPE_VALIDATION_KEY, ValidationType.ERROR, EnumSet.allOf(ValidationType.class));
    }

    private static ValidationType nullableValidationType(ProcessingEnvironment processingEnv) {
        return ComponentProcessor.validationTypeFor(processingEnv, NULLABLE_VALIDATION_KEY, ValidationType.ERROR, EnumSet.of(ValidationType.ERROR, ValidationType.WARNING));
    }

    private static ValidationType validationTypeFor(ProcessingEnvironment processingEnv, String key, ValidationType defaultValue, Set<ValidationType> validValues) {
        Map<String, String> options = processingEnv.getOptions();
        if (options.containsKey(key)) {
            try {
                ValidationType type = ValidationType.valueOf(options.get(key).toUpperCase());
                if (!validValues.contains((Object)type)) {
                    throw new IllegalArgumentException();
                }
                return type;
            }
            catch (IllegalArgumentException e) {
                processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Processor option -A" + key + " may only have the values " + validValues + " (case insensitive), found: " + options.get(key));
            }
        }
        return defaultValue;
    }
}

