/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import dagger.Component;
import dagger.Module;
import dagger.Subcomponent;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ModuleValidator;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.ValidationReport;
import dagger.internal.codegen.Validator;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

final class ComponentValidator
implements Validator<TypeElement> {
    private final Elements elements;
    private final Types types;
    private final ModuleValidator moduleValidator;

    ComponentValidator(Elements elements, Types types, ModuleValidator moduleValidator) {
        this.elements = elements;
        this.types = types;
        this.moduleValidator = moduleValidator;
    }

    @Override
    public ValidationReport<TypeElement> validate(TypeElement subject) {
        ValidationReport.Builder<TypeElement> builder = ValidationReport.Builder.about(subject);
        if (!(subject.getKind().equals((Object)ElementKind.INTERFACE) || subject.getKind().equals((Object)ElementKind.CLASS) && subject.getModifiers().contains((Object)Modifier.ABSTRACT))) {
            builder.addItem("@Component may only be applied to an interface or abstract class", subject);
        }
        List<? extends Element> members = this.elements.getAllMembers(subject);
        block4: for (ExecutableElement method : ElementFilter.methodsIn(members)) {
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            List<? extends VariableElement> parameters = method.getParameters();
            TypeMirror returnType = method.getReturnType();
            Optional<AnnotationMirror> subcomponentAnnotation = returnType.accept(new SimpleTypeVisitor6<Optional<AnnotationMirror>, Void>(){

                @Override
                protected Optional<AnnotationMirror> defaultAction(TypeMirror e, Void p) {
                    return Optional.absent();
                }

                @Override
                public Optional<AnnotationMirror> visitDeclared(DeclaredType t, Void p) {
                    return MoreElements.getAnnotationMirror(t.asElement(), Subcomponent.class);
                }
            }, null);
            if (subcomponentAnnotation.isPresent()) {
                this.validateSubcomponentMethod(builder, method, parameters, returnType, subcomponentAnnotation);
                continue;
            }
            switch (parameters.size()) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    VariableElement onlyParameter = (VariableElement)Iterables.getOnlyElement(parameters);
                    if (returnType.getKind().equals((Object)TypeKind.VOID) || this.types.isSameType(returnType, onlyParameter.asType())) continue block4;
                    builder.addItem("Members injection methods may only return the injected type or void.", method);
                    continue block4;
                }
            }
            builder.addItem("This method isn't a valid provision method, members injection method or subcomponent factory method. Dagger cannot implement this method", method);
        }
        AnnotationMirror componentMirror = (AnnotationMirror)MoreElements.getAnnotationMirror(subject, Component.class).get();
        ImmutableList<TypeMirror> moduleTypes = ConfigurationAnnotations.getComponentModules(componentMirror);
        this.moduleValidator.validateReferencedModules(subject, builder, moduleTypes);
        return builder.build();
    }

    private void validateSubcomponentMethod(ValidationReport.Builder<TypeElement> builder, ExecutableElement method, List<? extends VariableElement> parameters, TypeMirror returnType, Optional<AnnotationMirror> subcomponentAnnotation) {
        ImmutableSet<TypeElement> moduleTypes = MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentModules((AnnotationMirror)subcomponentAnnotation.get()));
        ImmutableSet<TypeElement> transitiveModules = ConfigurationAnnotations.getTransitiveModules(this.types, this.elements, moduleTypes);
        ImmutableSet requiredModules = FluentIterable.from(transitiveModules).filter((Predicate)new Predicate<TypeElement>(){

            public boolean apply(TypeElement input) {
                return !Util.componentCanMakeNewInstances(input);
            }
        }).toSet();
        HashSet variableTypes = Sets.newHashSet();
        for (VariableElement variableElement : parameters) {
            Optional<TypeElement> moduleType = variableElement.asType().accept(new SimpleTypeVisitor6<Optional<TypeElement>, Void>(){

                @Override
                protected Optional<TypeElement> defaultAction(TypeMirror e, Void p) {
                    return Optional.absent();
                }

                @Override
                public Optional<TypeElement> visitDeclared(DeclaredType t, Void p) {
                    return MoreElements.isAnnotationPresent(t.asElement(), Module.class) ? Optional.of((Object)MoreTypes.asTypeElement(t)) : Optional.absent();
                }
            }, null);
            if (moduleType.isPresent()) {
                if (variableTypes.contains(moduleType.get())) {
                    builder.addItem(String.format("A module may only occur once an an argument in a Subcomponent factory method, but %s was already passed.", ((TypeElement)moduleType.get()).getQualifiedName()), variableElement);
                }
                if (!transitiveModules.contains(moduleType.get())) {
                    builder.addItem(String.format("%s is present as an argument to the %s factory method, but is not one of the modules used to implement the subcomponent.", ((TypeElement)moduleType.get()).getQualifiedName(), MoreTypes.asTypeElement(returnType).getQualifiedName()), method);
                }
                variableTypes.add(moduleType.get());
                continue;
            }
            builder.addItem(String.format("Subcomponent factory methods may only accept modules, but %s is not.", variableElement.asType()), variableElement);
        }
        Sets.SetView missingModules = Sets.difference((Set)requiredModules, (Set)ImmutableSet.copyOf((Collection)variableTypes));
        if (!missingModules.isEmpty()) {
            builder.addItem(String.format("%s requires modules which have no visible default constructors. Add the following modules as parameters to this method: %s", MoreTypes.asTypeElement(returnType).getQualifiedName(), Joiner.on((String)", ").join((Iterable)missingModules)), method);
        }
    }
}

