/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Formatter;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.Types;

final class DependencyRequestFormatter
extends Formatter<DependencyRequest> {
    private final Types types;

    DependencyRequestFormatter(Types types) {
        this.types = types;
    }

    @Override
    public String format(final DependencyRequest request) {
        Element requestElement = request.requestElement();
        Optional<AnnotationMirror> qualifier = InjectionAnnotations.getQualifier(requestElement);
        return requestElement.accept(new SimpleElementVisitor6<String, Optional<AnnotationMirror>>(){

            @Override
            public String visitExecutable(ExecutableElement method, Optional<AnnotationMirror> qualifier) {
                StringBuilder builder = new StringBuilder("    ");
                if (method.getParameters().isEmpty()) {
                    DependencyRequestFormatter.this.appendEnclosingTypeAndMemberName(method, builder).append("()\n").append("    ").append("    ").append("[component method with return type: ");
                    if (qualifier.isPresent()) {
                        builder.append(qualifier.get()).append(' ');
                    }
                    builder.append(method.getReturnType()).append(']');
                } else {
                    VariableElement componentMethodParameter = (VariableElement)Iterables.getOnlyElement(method.getParameters());
                    DependencyRequestFormatter.this.appendEnclosingTypeAndMemberName(method, builder).append("(");
                    DependencyRequestFormatter.this.appendParameter(componentMethodParameter, componentMethodParameter.asType(), builder);
                    builder.append(")\n");
                    builder.append("    ").append("    ").append("[component injection method for type: ").append(componentMethodParameter.asType()).append(']');
                }
                return builder.toString();
            }

            @Override
            public String visitVariable(VariableElement variable, Optional<AnnotationMirror> qualifier) {
                StringBuilder builder = new StringBuilder("    ");
                TypeMirror resolvedVariableType = MoreTypes.asMemberOf(DependencyRequestFormatter.this.types, request.enclosingType(), variable);
                if (variable.getKind().equals((Object)ElementKind.PARAMETER)) {
                    ExecutableElement methodOrConstructor = MoreElements.asExecutable(variable.getEnclosingElement());
                    ExecutableType resolvedMethodOrConstructor = MoreTypes.asExecutable(DependencyRequestFormatter.this.types.asMemberOf(request.enclosingType(), methodOrConstructor));
                    DependencyRequestFormatter.this.appendEnclosingTypeAndMemberName(methodOrConstructor, builder).append('(');
                    List<? extends VariableElement> parameters = methodOrConstructor.getParameters();
                    List<? extends TypeMirror> parameterTypes = resolvedMethodOrConstructor.getParameterTypes();
                    Preconditions.checkState((parameters.size() == parameterTypes.size() ? 1 : 0) != 0);
                    for (int i = 0; i < parameters.size(); ++i) {
                        DependencyRequestFormatter.this.appendParameter(parameters.get(i), parameterTypes.get(i), builder);
                        if (i == parameters.size() - 1) continue;
                        builder.append(", ");
                    }
                    builder.append(")\n").append("    ").append("    ").append("[parameter: ");
                } else {
                    DependencyRequestFormatter.this.appendEnclosingTypeAndMemberName(variable, builder).append("\n").append("    ").append("    ").append("[injected field of type: ");
                }
                if (qualifier.isPresent()) {
                    builder.append(qualifier.get()).append(' ');
                }
                builder.append(resolvedVariableType).append(' ').append(variable.getSimpleName()).append(']');
                return builder.toString();
            }

            @Override
            public String visitType(TypeElement e, Optional<AnnotationMirror> p) {
                return "";
            }

            @Override
            protected String defaultAction(Element element, Optional<AnnotationMirror> ignore) {
                throw new IllegalStateException("Invalid request " + (Object)((Object)element.getKind()) + " element " + element);
            }
        }, qualifier);
    }

    private StringBuilder appendParameter(VariableElement parameter, TypeMirror type, StringBuilder builder) {
        return builder.append(type).append(' ').append(parameter.getSimpleName());
    }

    private StringBuilder appendEnclosingTypeAndMemberName(Element member, StringBuilder builder) {
        TypeElement type = MoreElements.asType(member.getEnclosingElement());
        return builder.append(type.getQualifiedName()).append('.').append(member.getSimpleName());
    }
}

