/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.ValidationReport;
import dagger.internal.codegen.Validator;
import dagger.shaded.auto.common.MoreElements;
import java.util.Set;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

final class InjectConstructorValidator
implements Validator<ExecutableElement> {
    InjectConstructorValidator() {
    }

    @Override
    public ValidationReport<ExecutableElement> validate(ExecutableElement constructorElement) {
        ImmutableSet<? extends AnnotationMirror> scopes;
        FluentIterable injectConstructors;
        ValidationReport.Builder<ExecutableElement> builder = ValidationReport.Builder.about(constructorElement);
        if (constructorElement.getModifiers().contains((Object)Modifier.PRIVATE)) {
            builder.addItem("Dagger does not support injection into private constructors", constructorElement);
        }
        for (AnnotationMirror qualifier : InjectionAnnotations.getQualifiers(constructorElement)) {
            builder.addItem("@Qualifier annotations are not allowed on @Inject constructors.", constructorElement, qualifier);
        }
        for (VariableElement parameter : constructorElement.getParameters()) {
            ImmutableSet<? extends AnnotationMirror> qualifiers = InjectionAnnotations.getQualifiers(parameter);
            if (qualifiers.size() <= 1) continue;
            for (AnnotationMirror qualifier : qualifiers) {
                builder.addItem("A single injection site may not use more than one @Qualifier.", constructorElement, qualifier);
            }
        }
        TypeElement enclosingElement = MoreElements.asType(constructorElement.getEnclosingElement());
        Set<Modifier> typeModifiers = enclosingElement.getModifiers();
        if (typeModifiers.contains((Object)Modifier.PRIVATE)) {
            builder.addItem("Dagger does not support injection into private classes", constructorElement);
        }
        if (typeModifiers.contains((Object)Modifier.ABSTRACT)) {
            builder.addItem("@Inject is nonsense on the constructor of an abstract class", constructorElement);
        }
        if (enclosingElement.getNestingKind().isNested() && !typeModifiers.contains((Object)Modifier.STATIC)) {
            builder.addItem("@Inject constructors are invalid on inner classes", constructorElement);
        }
        if ((injectConstructors = FluentIterable.from(ElementFilter.constructorsIn(enclosingElement.getEnclosedElements())).filter((Predicate)new Predicate<ExecutableElement>(){

            public boolean apply(ExecutableElement input) {
                return MoreElements.isAnnotationPresent(input, Inject.class);
            }
        })).size() > 1) {
            builder.addItem("Types may only contain one @Inject constructor.", constructorElement);
        }
        if ((scopes = InjectionAnnotations.getScopes(enclosingElement)).size() > 1) {
            for (AnnotationMirror scope : scopes) {
                builder.addItem("A single binding may not declare more than one @Scope.", enclosingElement, scope);
            }
        }
        return builder.build();
    }
}

