/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import dagger.MapKey;
import dagger.internal.codegen.MapKeyGenerator;
import dagger.internal.codegen.MapKeyValidator;
import dagger.internal.codegen.SourceFileGenerationException;
import dagger.internal.codegen.ValidationReport;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;

public class MapKeyProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final MapKeyValidator mapKeyValidator;
    private final MapKeyGenerator mapKeyGenerator;

    MapKeyProcessingStep(Messager messager, MapKeyValidator mapKeyValidator, MapKeyGenerator mapKeyGenerator) {
        this.messager = messager;
        this.mapKeyValidator = mapKeyValidator;
        this.mapKeyGenerator = mapKeyGenerator;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(MapKey.class);
    }

    @Override
    public void process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        for (Element element : elementsByAnnotation.get(MapKey.class)) {
            MapKey mapkey;
            ValidationReport<Element> mapKeyReport = this.mapKeyValidator.validate(element);
            mapKeyReport.printMessagesTo(this.messager);
            if (!mapKeyReport.isClean() || (mapkey = element.getAnnotation(MapKey.class)).unwrapValue()) continue;
            try {
                this.mapKeyGenerator.generate(element);
            }
            catch (SourceFileGenerationException e) {
                e.printMessageTo(this.messager);
            }
        }
    }
}

