/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.internal.codegen.AutoValue_ProductionBinding;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Key;
import dagger.producers.Producer;
import dagger.producers.Produces;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

abstract class ProductionBinding
extends ContributionBinding {
    ProductionBinding() {
    }

    @Override
    ImmutableSet<DependencyRequest> implicitDependencies() {
        return this.dependencies();
    }

    abstract Kind bindingKind();

    abstract Produces.Type productionType();

    abstract ImmutableList<? extends TypeMirror> thrownTypes();

    @Override
    ContributionBinding.BindingType bindingType() {
        switch (this.productionType()) {
            case SET: 
            case SET_VALUES: {
                return ContributionBinding.BindingType.SET;
            }
            case MAP: {
                return ContributionBinding.BindingType.MAP;
            }
            case UNIQUE: {
                return ContributionBinding.BindingType.UNIQUE;
            }
        }
        throw new IllegalStateException("Unknown production type: " + this.productionType());
    }

    @Override
    boolean isSyntheticBinding() {
        return this.bindingKind().equals((Object)Kind.SYNTHETIC_PRODUCTION);
    }

    @Override
    Class<?> frameworkClass() {
        return Producer.class;
    }

    static final class Factory {
        private final Types types;
        private final Key.Factory keyFactory;
        private final DependencyRequest.Factory dependencyRequestFactory;

        Factory(Types types, Key.Factory keyFactory, DependencyRequest.Factory dependencyRequestFactory) {
            this.types = types;
            this.keyFactory = keyFactory;
            this.dependencyRequestFactory = dependencyRequestFactory;
        }

        ProductionBinding forProducesMethod(ExecutableElement producesMethod, TypeMirror contributedBy) {
            Preconditions.checkNotNull((Object)producesMethod);
            Preconditions.checkArgument((boolean)producesMethod.getKind().equals((Object)ElementKind.METHOD));
            Preconditions.checkArgument((boolean)contributedBy.getKind().equals((Object)TypeKind.DECLARED));
            Produces producesAnnotation = producesMethod.getAnnotation(Produces.class);
            Preconditions.checkArgument((producesAnnotation != null ? 1 : 0) != 0);
            DeclaredType declaredContainer = MoreTypes.asDeclared(contributedBy);
            ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(declaredContainer, producesMethod));
            Key key = this.keyFactory.forProducesMethod(resolvedMethod, producesMethod);
            ImmutableSet<DependencyRequest> dependencies = this.dependencyRequestFactory.forRequiredResolvedVariables(declaredContainer, producesMethod.getParameters(), resolvedMethod.getParameterTypes());
            Kind kind = MoreTypes.isTypeOf(ListenableFuture.class, producesMethod.getReturnType()) ? Kind.FUTURE_PRODUCTION : Kind.IMMEDIATE;
            return new AutoValue_ProductionBinding(key, producesMethod, dependencies, Binding.findBindingPackage(key), false, ConfigurationAnnotations.getNullableType(producesMethod), (Optional<TypeElement>)Optional.of((Object)MoreTypes.asTypeElement(declaredContainer)), kind, producesAnnotation.type(), (ImmutableList<? extends TypeMirror>)ImmutableList.copyOf(producesMethod.getThrownTypes()));
        }

        ProductionBinding forImplicitMapBinding(DependencyRequest explicitRequest, DependencyRequest implicitRequest) {
            Preconditions.checkNotNull((Object)explicitRequest);
            Preconditions.checkNotNull((Object)implicitRequest);
            ImmutableSet dependencies = ImmutableSet.of((Object)implicitRequest);
            return new AutoValue_ProductionBinding(explicitRequest.key(), implicitRequest.requestElement(), (ImmutableSet<DependencyRequest>)dependencies, Binding.findBindingPackage(explicitRequest.key()), false, (Optional<DeclaredType>)Optional.absent(), (Optional<TypeElement>)Optional.absent(), Kind.SYNTHETIC_PRODUCTION, Produces.Type.MAP, (ImmutableList<? extends TypeMirror>)ImmutableList.of());
        }

        ProductionBinding forComponentMethod(ExecutableElement componentMethod) {
            Preconditions.checkNotNull((Object)componentMethod);
            Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
            Preconditions.checkArgument((boolean)componentMethod.getParameters().isEmpty());
            Preconditions.checkArgument((boolean)MoreTypes.isTypeOf(ListenableFuture.class, componentMethod.getReturnType()));
            return new AutoValue_ProductionBinding(this.keyFactory.forProductionComponentMethod(componentMethod), componentMethod, (ImmutableSet<DependencyRequest>)ImmutableSet.of(), (Optional<String>)Optional.absent(), false, (Optional<DeclaredType>)Optional.absent(), (Optional<TypeElement>)Optional.absent(), Kind.COMPONENT_PRODUCTION, Produces.Type.UNIQUE, (ImmutableList<? extends TypeMirror>)ImmutableList.copyOf(componentMethod.getThrownTypes()));
        }
    }

    static enum Kind {
        IMMEDIATE,
        FUTURE_PRODUCTION,
        SYNTHETIC_PRODUCTION,
        COMPONENT_PRODUCTION;

    }
}

