/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import dagger.internal.codegen.Formatter;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.ProductionBinding;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

final class ProductionBindingFormatter
extends Formatter<ProductionBinding> {
    private final MethodSignatureFormatter methodSignatureFormatter;

    ProductionBindingFormatter(MethodSignatureFormatter methodSignatureFormatter) {
        this.methodSignatureFormatter = methodSignatureFormatter;
    }

    @Override
    public String format(ProductionBinding binding) {
        switch (binding.bindingKind()) {
            case IMMEDIATE: 
            case FUTURE_PRODUCTION: {
                return this.methodSignatureFormatter.format(MoreElements.asExecutable(binding.bindingElement()), (Optional<DeclaredType>)Optional.of((Object)MoreTypes.asDeclared(((TypeElement)binding.contributedBy().get()).asType())));
            }
            case COMPONENT_PRODUCTION: {
                return this.methodSignatureFormatter.format(MoreElements.asExecutable(binding.bindingElement()));
            }
        }
        throw new UnsupportedOperationException("Not yet supporting " + (Object)((Object)binding.bindingKind()) + " binding types.");
    }
}

