/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingGraphValidator;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentGenerator;
import dagger.internal.codegen.ProductionComponentValidator;
import dagger.internal.codegen.SourceFileGenerationException;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProductionComponent;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

final class ProductionComponentProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final ProductionComponentValidator componentValidator;
    private final BindingGraphValidator bindingGraphValidator;
    private final ComponentDescriptor.Factory componentDescriptorFactory;
    private final BindingGraph.Factory bindingGraphFactory;
    private final ComponentGenerator componentGenerator;

    ProductionComponentProcessingStep(Messager messager, ProductionComponentValidator componentValidator, BindingGraphValidator bindingGraphValidator, ComponentDescriptor.Factory componentDescriptorFactory, BindingGraph.Factory bindingGraphFactory, ComponentGenerator componentGenerator) {
        this.messager = messager;
        this.componentValidator = componentValidator;
        this.bindingGraphValidator = bindingGraphValidator;
        this.componentDescriptorFactory = componentDescriptorFactory;
        this.bindingGraphFactory = bindingGraphFactory;
        this.componentGenerator = componentGenerator;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(ProductionComponent.class);
    }

    @Override
    public void process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        Set componentElements = elementsByAnnotation.get(ProductionComponent.class);
        for (Element element : componentElements) {
            TypeElement componentTypeElement = MoreElements.asType(element);
            ValidationReport<TypeElement> componentReport = this.componentValidator.validate(componentTypeElement);
            componentReport.printMessagesTo(this.messager);
            if (!componentReport.isClean()) continue;
            ComponentDescriptor componentDescriptor = this.componentDescriptorFactory.forProductionComponent(componentTypeElement);
            BindingGraph bindingGraph = this.bindingGraphFactory.create(componentDescriptor);
            ValidationReport<BindingGraph> graphReport = this.bindingGraphValidator.validate(bindingGraph);
            graphReport.printMessagesTo(this.messager);
            if (!graphReport.isClean()) continue;
            try {
                this.componentGenerator.generate(bindingGraph);
            }
            catch (SourceFileGenerationException e) {
                e.printMessageTo(this.messager);
            }
        }
    }
}

