/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.Module;
import dagger.Provides;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.InjectionAnnotations;
import dagger.internal.codegen.ValidationReport;
import dagger.internal.codegen.Validator;
import dagger.shaded.auto.common.MoreElements;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;

final class ProvidesMethodValidator
implements Validator<ExecutableElement> {
    private final Elements elements;

    ProvidesMethodValidator(Elements elements) {
        this.elements = (Elements)Preconditions.checkNotNull((Object)elements);
    }

    private TypeElement getSetElement() {
        return this.elements.getTypeElement(Set.class.getCanonicalName());
    }

    @Override
    public ValidationReport<ExecutableElement> validate(ExecutableElement providesMethodElement) {
        TypeMirror returnType;
        TypeKind returnTypeKind;
        Set<Modifier> modifiers;
        ValidationReport.Builder<ExecutableElement> builder = ValidationReport.Builder.about(providesMethodElement);
        Provides providesAnnotation = providesMethodElement.getAnnotation(Provides.class);
        Preconditions.checkArgument((providesAnnotation != null ? 1 : 0) != 0);
        Element enclosingElement = providesMethodElement.getEnclosingElement();
        if (!MoreElements.isAnnotationPresent(enclosingElement, Module.class)) {
            builder.addItem(this.formatModuleErrorMessage("@%s methods can only be present within a @%s"), providesMethodElement);
        }
        if (!providesMethodElement.getTypeParameters().isEmpty()) {
            builder.addItem(this.formatErrorMessage("@%s methods may not have type parameters."), providesMethodElement);
        }
        if ((modifiers = providesMethodElement.getModifiers()).contains((Object)Modifier.PRIVATE)) {
            builder.addItem(this.formatErrorMessage("@%s methods cannot be private"), providesMethodElement);
        }
        if (modifiers.contains((Object)Modifier.STATIC)) {
            builder.addItem(this.formatErrorMessage("@%s methods cannot be static"), providesMethodElement);
        }
        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
            builder.addItem(this.formatErrorMessage("@%s methods cannot be abstract"), providesMethodElement);
        }
        if ((returnTypeKind = (returnType = providesMethodElement.getReturnType()).getKind()).equals((Object)TypeKind.VOID)) {
            builder.addItem(this.formatErrorMessage("@%s methods must return a value (not void)."), providesMethodElement);
        }
        if (!providesAnnotation.type().equals((Object)Provides.Type.MAP) && ConfigurationAnnotations.getMapKeys(providesMethodElement) != null && ConfigurationAnnotations.getMapKeys(providesMethodElement).size() > 0) {
            builder.addItem(this.formatErrorMessage("@%s methods of non map type cannot declare a map key"), providesMethodElement);
        }
        ProvidesMethodValidator.validateMethodQualifiers(builder, providesMethodElement);
        block0 : switch (providesAnnotation.type()) {
            case UNIQUE: 
            case SET: {
                this.validateKeyType(builder, returnType);
                break;
            }
            case MAP: {
                this.validateKeyType(builder, returnType);
                ImmutableSet<? extends AnnotationMirror> annotationMirrors = ConfigurationAnnotations.getMapKeys(providesMethodElement);
                switch (annotationMirrors.size()) {
                    case 0: {
                        builder.addItem(this.formatErrorMessage("@%s methods of type map must declare a map key"), providesMethodElement);
                        break block0;
                    }
                    case 1: {
                        break block0;
                    }
                }
                builder.addItem(this.formatErrorMessage("@%s methods may not have more than one @MapKey-marked annotation"), providesMethodElement);
                break;
            }
            case SET_VALUES: {
                if (!returnTypeKind.equals((Object)TypeKind.DECLARED)) {
                    builder.addItem("@Provides methods of type set values must return a Set", providesMethodElement);
                    break;
                }
                DeclaredType declaredReturnType = (DeclaredType)returnType;
                if (!declaredReturnType.asElement().equals(this.getSetElement())) {
                    builder.addItem("@Provides methods of type set values must return a Set", providesMethodElement);
                    break;
                }
                if (declaredReturnType.getTypeArguments().isEmpty()) {
                    builder.addItem(this.formatErrorMessage("@%s methods of type set values cannot return a raw Set"), providesMethodElement);
                    break;
                }
                this.validateKeyType(builder, (TypeMirror)Iterables.getOnlyElement(declaredReturnType.getTypeArguments()));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return builder.build();
    }

    static void validateMethodQualifiers(ValidationReport.Builder<ExecutableElement> builder, ExecutableElement methodElement) {
        ImmutableSet<? extends AnnotationMirror> qualifiers = InjectionAnnotations.getQualifiers(methodElement);
        if (qualifiers.size() > 1) {
            for (AnnotationMirror qualifier : qualifiers) {
                builder.addItem("Cannot use more than one @Qualifier on a @Provides or @Produces method", methodElement, qualifier);
            }
        }
    }

    private String formatErrorMessage(String msg) {
        return String.format(msg, Provides.class.getSimpleName());
    }

    private String formatModuleErrorMessage(String msg) {
        return String.format(msg, Provides.class.getSimpleName(), Module.class.getSimpleName());
    }

    private void validateKeyType(ValidationReport.Builder<? extends Element> reportBuilder, TypeMirror type) {
        TypeKind kind = type.getKind();
        if (!(kind.isPrimitive() || kind.equals((Object)TypeKind.DECLARED) || kind.equals((Object)TypeKind.ARRAY))) {
            reportBuilder.addItem("@Provides methods must either return a primitive, an array or a declared type.", reportBuilder.getSubject());
        }
    }
}

