/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import dagger.internal.codegen.Formatter;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.ProvisionBinding;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

final class ProvisionBindingFormatter
extends Formatter<ProvisionBinding> {
    private final MethodSignatureFormatter methodSignatureFormatter;

    ProvisionBindingFormatter(MethodSignatureFormatter methodSignatureFormatter) {
        this.methodSignatureFormatter = methodSignatureFormatter;
    }

    @Override
    public String format(ProvisionBinding binding) {
        switch (binding.bindingKind()) {
            case PROVISION: {
                return this.methodSignatureFormatter.format(MoreElements.asExecutable(binding.bindingElement()), (Optional<DeclaredType>)Optional.of((Object)MoreTypes.asDeclared(((TypeElement)binding.contributedBy().get()).asType())));
            }
            case COMPONENT_PROVISION: {
                return this.methodSignatureFormatter.format(MoreElements.asExecutable(binding.bindingElement()));
            }
        }
        throw new UnsupportedOperationException("Not yet supporting " + (Object)((Object)binding.bindingKind()) + " binding types.");
    }
}

