/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.PrintableErrorMessage;
import dagger.internal.codegen.writer.ClassName;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

final class SourceFileGenerationException
extends Exception
implements PrintableErrorMessage {
    private final ImmutableSet<ClassName> generatedClassNames;
    private final Optional<? extends Element> associatedElement;

    SourceFileGenerationException(Iterable<ClassName> generatedClassNames, Throwable cause, Optional<? extends Element> associatedElement) {
        super(SourceFileGenerationException.createMessage(generatedClassNames, cause.getMessage()), cause);
        this.generatedClassNames = ImmutableSet.copyOf(generatedClassNames);
        this.associatedElement = (Optional)Preconditions.checkNotNull(associatedElement);
    }

    SourceFileGenerationException(Iterable<ClassName> generatedClassNames, Throwable cause) {
        this(generatedClassNames, cause, (Optional<? extends Element>)Optional.absent());
    }

    SourceFileGenerationException(Iterable<ClassName> generatedClassNames, Throwable cause, Element associatedElement) {
        this(generatedClassNames, cause, (Optional<? extends Element>)Optional.of((Object)associatedElement));
    }

    public ImmutableSet<ClassName> generatedClassNames() {
        return this.generatedClassNames;
    }

    public Optional<? extends Element> associatedElement() {
        return this.associatedElement;
    }

    private static String createMessage(Iterable<ClassName> generatedClassNames, String message) {
        return String.format("Could not generate %s: %s.", Iterables.isEmpty(generatedClassNames) ? "unknown files" : Iterables.toString(generatedClassNames), message);
    }

    @Override
    public void printMessageTo(Messager messager) {
        if (this.associatedElement.isPresent()) {
            messager.printMessage(Diagnostic.Kind.ERROR, this.getMessage(), (Element)this.associatedElement.get());
        } else {
            messager.printMessage(Diagnostic.Kind.ERROR, this.getMessage());
        }
    }
}

