/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.UnmodifiableIterator;
import dagger.internal.DoubleCheckLazy;
import dagger.internal.codegen.BindingKey;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.DependencyRequestMapper;
import dagger.internal.codegen.DependencyVariableNamer;
import dagger.internal.codegen.FrameworkField;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.ParameterizedTypeName;
import dagger.internal.codegen.writer.Snippet;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.TypeNames;
import java.util.Collection;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

class SourceFiles {
    static final Ordering<DependencyRequest> DEPENDENCY_ORDERING = new Ordering<DependencyRequest>(){

        public int compare(DependencyRequest left, DependencyRequest right) {
            return ComparisonChain.start().compare((Comparable)((Object)left.requestElement().getKind()), (Comparable)((Object)right.requestElement().getKind())).compare((Comparable)((Object)left.kind()), (Comparable)((Object)right.kind())).compare((Comparable)((Object)left.requestElement().getSimpleName().toString()), (Comparable)((Object)right.requestElement().getSimpleName().toString())).result();
        }
    };

    static ImmutableSetMultimap<BindingKey, DependencyRequest> indexDependenciesByUnresolvedKey(Types types, Iterable<? extends DependencyRequest> dependencies) {
        ImmutableSetMultimap.Builder dependenciesByKeyBuilder = new ImmutableSetMultimap.Builder().orderValuesBy(DEPENDENCY_ORDERING);
        for (DependencyRequest dependencyRequest : dependencies) {
            BindingKey resolved = dependencyRequest.bindingKey();
            TypeMirror unresolvedType = DependencyRequest.Factory.extractKindAndType(dependencyRequest.requestElement().asType()).type();
            BindingKey unresolved = BindingKey.create(resolved.kind(), resolved.key().withType(types, unresolvedType));
            dependenciesByKeyBuilder.put((Object)unresolved, (Object)dependencyRequest);
        }
        return dependenciesByKeyBuilder.build();
    }

    static ImmutableSetMultimap<BindingKey, DependencyRequest> indexDependenciesByKey(Iterable<? extends DependencyRequest> dependencies) {
        ImmutableSetMultimap.Builder dependenciesByKeyBuilder = new ImmutableSetMultimap.Builder().orderValuesBy(DEPENDENCY_ORDERING);
        for (DependencyRequest dependencyRequest : dependencies) {
            dependenciesByKeyBuilder.put((Object)dependencyRequest.bindingKey(), (Object)dependencyRequest);
        }
        return dependenciesByKeyBuilder.build();
    }

    static ImmutableMap<BindingKey, FrameworkField> generateBindingFieldsForDependencies(DependencyRequestMapper dependencyRequestMapper, Iterable<? extends DependencyRequest> dependencies) {
        ImmutableSetMultimap<BindingKey, DependencyRequest> dependenciesByKey = SourceFiles.indexDependenciesByKey(dependencies);
        ImmutableMap dependenciesByKeyMap = dependenciesByKey.asMap();
        ImmutableMap.Builder bindingFields = ImmutableMap.builder();
        for (Map.Entry entry : dependenciesByKeyMap.entrySet()) {
            BindingKey bindingKey = (BindingKey)entry.getKey();
            Collection requests = (Collection)entry.getValue();
            Class<?> frameworkClass = dependencyRequestMapper.getFrameworkClass((DependencyRequest)requests.iterator().next());
            ImmutableSet dependencyNames = FluentIterable.from((Iterable)requests).transform((Function)new DependencyVariableNamer()).toSet();
            if (dependencyNames.size() == 1) {
                String name = (String)Iterables.getOnlyElement((Iterable)dependencyNames);
                bindingFields.put((Object)bindingKey, (Object)FrameworkField.createWithTypeFromKey(frameworkClass, bindingKey, name));
                continue;
            }
            UnmodifiableIterator namesIterator = dependencyNames.iterator();
            String first = (String)namesIterator.next();
            StringBuilder compositeNameBuilder = new StringBuilder(first);
            while (namesIterator.hasNext()) {
                compositeNameBuilder.append("And").append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, (String)namesIterator.next()));
            }
            bindingFields.put((Object)bindingKey, (Object)FrameworkField.createWithTypeFromKey(frameworkClass, bindingKey, compositeNameBuilder.toString()));
        }
        return bindingFields.build();
    }

    static Snippet frameworkTypeUsageStatement(Snippet frameworkTypeMemberSelect, DependencyRequest.Kind dependencyKind) {
        switch (dependencyKind) {
            case LAZY: {
                return Snippet.format("%s.create(%s)", ClassName.fromClass(DoubleCheckLazy.class), frameworkTypeMemberSelect);
            }
            case INSTANCE: 
            case FUTURE: {
                return Snippet.format("%s.get()", frameworkTypeMemberSelect);
            }
            case PROVIDER: 
            case PRODUCER: 
            case MEMBERS_INJECTOR: {
                return Snippet.format("%s", frameworkTypeMemberSelect);
            }
        }
        throw new AssertionError();
    }

    static ClassName factoryNameForProvisionBinding(ProvisionBinding binding) {
        TypeElement enclosingTypeElement = binding.bindingTypeElement();
        ClassName enclosingClassName = ClassName.fromTypeElement(enclosingTypeElement);
        switch (binding.bindingKind()) {
            case INJECTION: 
            case PROVISION: {
                return enclosingClassName.topLevelClassName().peerNamed(enclosingClassName.classFileName() + "_" + SourceFiles.factoryPrefix(binding) + "Factory");
            }
            case SYNTHETIC_PROVISON: {
                throw new IllegalArgumentException();
            }
        }
        throw new AssertionError();
    }

    static TypeName parameterizedFactoryNameForProvisionBinding(ProvisionBinding binding) {
        ClassName factoryName = SourceFiles.factoryNameForProvisionBinding(binding);
        ImmutableList<TypeName> parameters = ImmutableList.of();
        if (binding.bindingType().equals((Object)ContributionBinding.BindingType.UNIQUE)) {
            switch (binding.bindingKind()) {
                case INJECTION: {
                    TypeName bindingName = TypeNames.forTypeMirror(binding.key().type());
                    if (!(bindingName instanceof ParameterizedTypeName)) break;
                    parameters = ((ParameterizedTypeName)bindingName).parameters();
                    break;
                }
                case PROVISION: {
                    if (binding.bindingTypeElement().getTypeParameters().isEmpty()) break;
                    parameters = ((ParameterizedTypeName)TypeNames.forTypeMirror(binding.bindingTypeElement().asType())).parameters();
                    break;
                }
            }
        }
        return parameters.isEmpty() ? factoryName : ParameterizedTypeName.create(factoryName, (Iterable<? extends TypeName>)parameters);
    }

    static ClassName factoryNameForProductionBinding(ProductionBinding binding) {
        TypeElement enclosingTypeElement = binding.bindingTypeElement();
        ClassName enclosingClassName = ClassName.fromTypeElement(enclosingTypeElement);
        switch (binding.bindingKind()) {
            case IMMEDIATE: 
            case FUTURE_PRODUCTION: {
                return enclosingClassName.topLevelClassName().peerNamed(enclosingClassName.classFileName() + "_" + SourceFiles.factoryPrefix(binding) + "Factory");
            }
        }
        throw new AssertionError();
    }

    static TypeName parameterizedMembersInjectorNameForMembersInjectionBinding(MembersInjectionBinding binding) {
        ClassName factoryName = SourceFiles.membersInjectorNameForMembersInjectionBinding(binding);
        TypeName bindingName = TypeNames.forTypeMirror(binding.key().type());
        if (bindingName instanceof ParameterizedTypeName) {
            return ParameterizedTypeName.create(factoryName, ((ParameterizedTypeName)bindingName).parameters());
        }
        return factoryName;
    }

    static ClassName membersInjectorNameForMembersInjectionBinding(MembersInjectionBinding binding) {
        ClassName injectedClassName = ClassName.fromTypeElement(binding.bindingElement());
        return injectedClassName.topLevelClassName().peerNamed(injectedClassName.classFileName() + "_MembersInjector");
    }

    private static String factoryPrefix(ProvisionBinding binding) {
        switch (binding.bindingKind()) {
            case INJECTION: {
                return "";
            }
            case PROVISION: {
                return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, ((ExecutableElement)binding.bindingElement()).getSimpleName().toString());
            }
        }
        throw new IllegalArgumentException();
    }

    private static String factoryPrefix(ProductionBinding binding) {
        switch (binding.bindingKind()) {
            case IMMEDIATE: 
            case FUTURE_PRODUCTION: {
                return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, ((ExecutableElement)binding.bindingElement()).getSimpleName().toString());
            }
        }
        throw new IllegalArgumentException();
    }

    private SourceFiles() {
    }
}

