/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor6;

final class Util {
    public static TypeMirror getProvidedValueTypeOfMap(DeclaredType mapType) {
        Preconditions.checkState((boolean)MoreTypes.isTypeOf(Map.class, mapType), (String)"%s is not a Map.", (Object[])new Object[]{mapType});
        return MoreTypes.asDeclared(mapType.getTypeArguments().get(1)).getTypeArguments().get(0);
    }

    public static TypeMirror getValueTypeOfMap(DeclaredType mapType) {
        Preconditions.checkState((boolean)MoreTypes.isTypeOf(Map.class, mapType), (String)"%s is not a Map.", (Object[])new Object[]{mapType});
        List<? extends TypeMirror> mapArgs = mapType.getTypeArguments();
        return mapArgs.get(1);
    }

    public static DeclaredType getKeyTypeOfMap(DeclaredType mapType) {
        Preconditions.checkState((boolean)MoreTypes.isTypeOf(Map.class, mapType), (String)"%s is not a Map.", (Object[])new Object[]{mapType});
        List<? extends TypeMirror> mapArgs = mapType.getTypeArguments();
        return MoreTypes.asDeclared(mapArgs.get(0));
    }

    public static TypeElement getKeyTypeElement(AnnotationMirror mapKey, final Elements elements) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> map = mapKey.getElementValues();
        SimpleAnnotationValueVisitor6<TypeElement, Void> mapKeyVisitor = new SimpleAnnotationValueVisitor6<TypeElement, Void>(){

            @Override
            public TypeElement visitEnumConstant(VariableElement c, Void p) {
                return MoreElements.asType(c.getEnclosingElement());
            }

            @Override
            public TypeElement visitString(String s, Void p) {
                return elements.getTypeElement(String.class.getCanonicalName());
            }

            @Override
            protected TypeElement defaultAction(Object o, Void v) {
                throw new IllegalStateException("Non-supported key type for map binding " + o.getClass().getCanonicalName());
            }
        };
        TypeElement keyTypeElement = ((AnnotationValue)((Map.Entry)Iterables.getOnlyElement(map.entrySet())).getValue()).accept(mapKeyVisitor, null);
        return keyTypeElement;
    }

    static <T> Optional<Equivalence.Wrapper<T>> wrapOptionalInEquivalence(Equivalence<T> equivalence, Optional<T> optional) {
        return optional.isPresent() ? Optional.of((Object)equivalence.wrap(optional.get())) : Optional.absent();
    }

    static <T> Optional<T> unwrapOptionalEquivalence(Optional<Equivalence.Wrapper<T>> wrappedOptional) {
        return wrappedOptional.isPresent() ? Optional.of((Object)((Equivalence.Wrapper)wrappedOptional.get()).get()) : Optional.absent();
    }

    private static boolean requiresEnclosingInstance(TypeElement typeElement) {
        switch (typeElement.getNestingKind()) {
            case TOP_LEVEL: {
                return false;
            }
            case MEMBER: {
                return !typeElement.getModifiers().contains((Object)Modifier.STATIC);
            }
            case ANONYMOUS: 
            case LOCAL: {
                return true;
            }
        }
        throw new AssertionError((Object)("TypeElement cannot have nesting kind: " + (Object)((Object)typeElement.getNestingKind())));
    }

    static boolean componentCanMakeNewInstances(TypeElement typeElement) {
        switch (typeElement.getKind()) {
            case CLASS: {
                break;
            }
            case ENUM: 
            case ANNOTATION_TYPE: 
            case INTERFACE: {
                return false;
            }
            default: {
                throw new AssertionError((Object)("TypeElement cannot have kind: " + (Object)((Object)typeElement.getKind())));
            }
        }
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return false;
        }
        if (Util.requiresEnclosingInstance(typeElement)) {
            return false;
        }
        for (Element element : typeElement.getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.CONSTRUCTOR) || !((ExecutableElement)element).getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private Util() {
    }
}

