/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.base.Ascii;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.Writable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

public final class ClassName
implements TypeName,
Comparable<ClassName> {
    private String fullyQualifiedName = null;
    private final String packageName;
    private final ImmutableList<String> enclosingSimpleNames;
    private final String simpleName;
    private static final ImmutableSet<NestingKind> ACCEPTABLE_NESTING_KINDS = Sets.immutableEnumSet((Enum)NestingKind.TOP_LEVEL, (Enum[])new NestingKind[]{NestingKind.MEMBER});

    private ClassName(String packageName, ImmutableList<String> enclosingSimpleNames, String simpleName) {
        this.packageName = packageName;
        this.enclosingSimpleNames = enclosingSimpleNames;
        this.simpleName = simpleName;
    }

    public String packageName() {
        return this.packageName;
    }

    public ImmutableList<String> enclosingSimpleNames() {
        return this.enclosingSimpleNames;
    }

    public Optional<ClassName> enclosingClassName() {
        return this.enclosingSimpleNames.isEmpty() ? Optional.absent() : Optional.of((Object)new ClassName(this.packageName, (ImmutableList<String>)this.enclosingSimpleNames.subList(0, this.enclosingSimpleNames.size() - 1), (String)this.enclosingSimpleNames.get(this.enclosingSimpleNames.size() - 1)));
    }

    public String simpleName() {
        return this.simpleName;
    }

    public String canonicalName() {
        if (this.fullyQualifiedName == null) {
            StringBuilder builder = new StringBuilder(this.packageName());
            if (builder.length() > 0) {
                builder.append('.');
            }
            for (String enclosingSimpleName : this.enclosingSimpleNames()) {
                builder.append(enclosingSimpleName).append('.');
            }
            this.fullyQualifiedName = builder.append(this.simpleName()).toString();
        }
        return this.fullyQualifiedName;
    }

    public String classFileName() {
        StringBuilder builder = new StringBuilder();
        Joiner.on((char)'$').appendTo(builder, this.enclosingSimpleNames());
        if (!this.enclosingSimpleNames().isEmpty()) {
            builder.append('$');
        }
        return builder.append(this.simpleName()).toString();
    }

    public ClassName topLevelClassName() {
        UnmodifiableIterator enclosingIterator = this.enclosingSimpleNames().iterator();
        return enclosingIterator.hasNext() ? new ClassName(this.packageName(), (ImmutableList<String>)ImmutableList.of(), (String)enclosingIterator.next()) : this;
    }

    public ClassName nestedClassNamed(String memberClassName) {
        Preconditions.checkNotNull((Object)memberClassName);
        Preconditions.checkArgument((boolean)SourceVersion.isIdentifier(memberClassName));
        Preconditions.checkArgument((boolean)Ascii.isUpperCase((char)memberClassName.charAt(0)));
        return new ClassName(this.packageName(), (ImmutableList<String>)new ImmutableList.Builder().addAll(this.enclosingSimpleNames()).add((Object)this.simpleName()).build(), memberClassName);
    }

    public ClassName peerNamed(String peerClassName) {
        Preconditions.checkNotNull((Object)peerClassName);
        Preconditions.checkArgument((boolean)SourceVersion.isIdentifier(peerClassName));
        Preconditions.checkArgument((boolean)Ascii.isUpperCase((char)peerClassName.charAt(0)));
        return new ClassName(this.packageName(), this.enclosingSimpleNames(), peerClassName);
    }

    public static ClassName fromTypeElement(TypeElement element) {
        Preconditions.checkNotNull((Object)element);
        Preconditions.checkArgument((boolean)ACCEPTABLE_NESTING_KINDS.contains((Object)element.getNestingKind()));
        String simpleName = element.getSimpleName().toString();
        ArrayList<String> enclosingNames = new ArrayList<String>();
        Element current = element.getEnclosingElement();
        while (current.getKind().isClass() || current.getKind().isInterface()) {
            Preconditions.checkArgument((boolean)ACCEPTABLE_NESTING_KINDS.contains((Object)element.getNestingKind()));
            enclosingNames.add(current.getSimpleName().toString());
            current = current.getEnclosingElement();
        }
        PackageElement packageElement = ClassName.getPackage(current);
        Collections.reverse(enclosingNames);
        return new ClassName(packageElement.getQualifiedName().toString(), (ImmutableList<String>)ImmutableList.copyOf(enclosingNames), simpleName);
    }

    public static ClassName fromClass(Class<?> clazz) {
        Preconditions.checkNotNull(clazz);
        ArrayList<String> enclosingNames = new ArrayList<String>();
        for (Class<?> current = clazz.getEnclosingClass(); current != null; current = current.getEnclosingClass()) {
            enclosingNames.add(current.getSimpleName());
        }
        Collections.reverse(enclosingNames);
        return ClassName.create(clazz.getPackage().getName(), enclosingNames, clazz.getSimpleName());
    }

    private static PackageElement getPackage(Element type) {
        while (type.getKind() != ElementKind.PACKAGE) {
            type = type.getEnclosingElement();
        }
        return (PackageElement)type;
    }

    public static ClassName bestGuessFromString(String classNameString) {
        Preconditions.checkNotNull((Object)classNameString);
        List parts = Splitter.on((char)'.').splitToList((CharSequence)classNameString);
        int firstClassPartIndex = -1;
        for (int i = 0; i < parts.size(); ++i) {
            String part = (String)parts.get(i);
            Preconditions.checkArgument((boolean)SourceVersion.isIdentifier(part));
            char firstChar = part.charAt(0);
            if (Ascii.isLowerCase((char)firstChar)) {
                if (firstClassPartIndex < 0) continue;
                throw new IllegalArgumentException("couldn't make a guess for " + classNameString);
            }
            if (Ascii.isUpperCase((char)firstChar)) {
                if (firstClassPartIndex >= 0) continue;
                firstClassPartIndex = i;
                continue;
            }
            throw new IllegalArgumentException("couldn't make a guess for " + classNameString);
        }
        int lastIndex = parts.size() - 1;
        return new ClassName(Joiner.on((char)'.').join(parts.subList(0, firstClassPartIndex)), (ImmutableList<String>)(firstClassPartIndex == lastIndex ? ImmutableList.of() : ImmutableList.copyOf(parts.subList(firstClassPartIndex, lastIndex))), (String)parts.get(lastIndex));
    }

    public static ClassName create(String packageName, List<String> enclosingSimpleNames, String simpleName) {
        return new ClassName(packageName, (ImmutableList<String>)ImmutableList.copyOf(enclosingSimpleNames), simpleName);
    }

    public static ClassName create(String packageName, String simpleName) {
        return new ClassName(packageName, (ImmutableList<String>)ImmutableList.of(), simpleName);
    }

    public String toString() {
        return this.canonicalName();
    }

    @Override
    public Appendable write(Appendable appendable, Writable.Context context) throws IOException {
        appendable.append(context.sourceReferenceForClassName(this));
        return appendable;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ClassName) {
            ClassName that = (ClassName)obj;
            return this.packageName.equals(that.packageName) && this.enclosingSimpleNames.equals(that.enclosingSimpleNames) && this.simpleName.equals(that.simpleName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.packageName, this.enclosingSimpleNames, this.simpleName});
    }

    @Override
    public int compareTo(ClassName o) {
        return this.canonicalName().compareTo(o.canonicalName());
    }

    @Override
    public Set<ClassName> referencedClasses() {
        return ImmutableSet.of((Object)this);
    }
}

