/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import dagger.internal.codegen.writer.BlockWriter;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.HasClassReferences;
import dagger.internal.codegen.writer.IndentingAppendable;
import dagger.internal.codegen.writer.Modifiable;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.TypeWriter;
import dagger.internal.codegen.writer.VariableWriter;
import dagger.internal.codegen.writer.Writable;
import dagger.internal.codegen.writer.Writables;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;

public final class ConstructorWriter
extends Modifiable
implements Writable,
HasClassReferences {
    private final String name;
    private final Map<String, VariableWriter> parameterWriters;
    private final BlockWriter blockWriter;

    ConstructorWriter(String name) {
        this.name = name;
        this.parameterWriters = Maps.newLinkedHashMap();
        this.blockWriter = new BlockWriter();
    }

    public VariableWriter addParameter(Class<?> type, String name) {
        return this.addParameter(ClassName.fromClass(type), name);
    }

    public VariableWriter addParameter(TypeElement type, String name) {
        return this.addParameter(ClassName.fromTypeElement(type), name);
    }

    public VariableWriter addParameter(TypeWriter type, String name) {
        return this.addParameter(type.name, name);
    }

    public VariableWriter addParameter(TypeName type, String name) {
        VariableWriter parameterWriter = new VariableWriter(type, name);
        this.parameterWriters.put(name, parameterWriter);
        return parameterWriter;
    }

    public Map<String, TypeName> parameters() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        for (Map.Entry<String, VariableWriter> entry : this.parameterWriters.entrySet()) {
            params.put((Object)entry.getKey(), (Object)entry.getValue().type());
        }
        return params.build();
    }

    public BlockWriter body() {
        return this.blockWriter;
    }

    private VariableWriter addParameter(ClassName type, String name) {
        Preconditions.checkArgument((!this.parameterWriters.containsKey(name) ? 1 : 0) != 0);
        VariableWriter parameterWriter = new VariableWriter(type, name);
        this.parameterWriters.put(name, parameterWriter);
        return parameterWriter;
    }

    @Override
    public Set<ClassName> referencedClasses() {
        return FluentIterable.from((Iterable)Iterables.concat(this.parameterWriters.values(), (Iterable)ImmutableList.of((Object)this.blockWriter))).transformAndConcat((Function)new Function<HasClassReferences, Set<ClassName>>(){

            public Set<ClassName> apply(HasClassReferences input) {
                return input.referencedClasses();
            }
        }).toSet();
    }

    @Override
    public Appendable write(Appendable appendable, Writable.Context context) throws IOException {
        this.writeModifiers(appendable).append(this.name).append('(');
        Writables.join(", ", this.parameterWriters.values(), appendable, context);
        appendable.append(") {");
        this.blockWriter.write(new IndentingAppendable(appendable), context);
        return appendable.append("}\n");
    }
}

