/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.util.Iterator;

final class IndentingAppendable
implements Appendable {
    private final String indentation;
    private final Appendable delegate;
    private boolean requiresIndent = true;

    IndentingAppendable(Appendable delegate) {
        this("  ", delegate);
    }

    IndentingAppendable(String indentation, Appendable delegate) {
        this.indentation = indentation;
        this.delegate = delegate;
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        Iterator<CharSequence> lines = IndentingAppendable.lines(csq, start, end);
        while (lines.hasNext()) {
            CharSequence line = lines.next();
            this.maybeIndent();
            this.delegate.append(line);
            if (line.charAt(line.length() - 1) != '\n') continue;
            this.requiresIndent = true;
        }
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        this.maybeIndent();
        this.delegate.append(c);
        if (c == '\n') {
            this.requiresIndent = true;
        }
        return this;
    }

    void maybeIndent() throws IOException {
        if (this.requiresIndent) {
            this.delegate.append(this.indentation);
        }
        this.requiresIndent = false;
    }

    private static Iterator<CharSequence> lines(final CharSequence csq, final int start, final int end) {
        return new AbstractIterator<CharSequence>(){
            int index;
            {
                this.index = start;
            }

            protected CharSequence computeNext() {
                int nextStart = this.index;
                while (this.index < end && csq.charAt(this.index) != '\n') {
                    ++this.index;
                }
                if (this.index < end && csq.charAt(this.index) == '\n') {
                    ++this.index;
                }
                int nextEnd = this.index;
                return nextStart >= end ? (CharSequence)this.endOfData() : csq.subSequence(nextStart, nextEnd);
            }
        };
    }
}

