/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.HasClassReferences;
import dagger.internal.codegen.writer.IndentingAppendable;
import dagger.internal.codegen.writer.MethodWriter;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.TypeVariableName;
import dagger.internal.codegen.writer.TypeWriter;
import dagger.internal.codegen.writer.Writable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class InterfaceWriter
extends TypeWriter {
    private final List<TypeVariableName> typeVariables = Lists.newArrayList();

    InterfaceWriter(ClassName name) {
        super(name);
    }

    public void addTypeVariable(TypeVariableName typeVariable) {
        this.typeVariables.add(typeVariable);
    }

    @Override
    public Appendable write(Appendable appendable, Writable.Context context) throws IOException {
        Iterator implementedTypesIterator;
        context = context.createSubcontext((Set<ClassName>)FluentIterable.from((Iterable)this.nestedTypeWriters).transform((Function)new Function<TypeWriter, ClassName>(){

            public ClassName apply(TypeWriter input) {
                return input.name;
            }
        }).toSet());
        this.writeAnnotations(appendable, context);
        this.writeModifiers(appendable).append("interface ").append(this.name.simpleName());
        if (!this.typeVariables.isEmpty()) {
            appendable.append('<');
            Joiner.on((String)", ").appendTo(appendable, this.typeVariables);
            appendable.append('>');
        }
        if (this.supertype.isPresent()) {
            appendable.append(" extends ");
            ((TypeName)this.supertype.get()).write(appendable, context);
        }
        if ((implementedTypesIterator = this.implementedTypes.iterator()).hasNext()) {
            appendable.append(" implements ");
            ((TypeName)implementedTypesIterator.next()).write(appendable, context);
            while (implementedTypesIterator.hasNext()) {
                appendable.append(", ");
                ((TypeName)implementedTypesIterator.next()).write(appendable, context);
            }
        }
        appendable.append(" {");
        for (MethodWriter methodWriter : this.methodWriters) {
            appendable.append('\n');
            methodWriter.write(new IndentingAppendable(appendable), context);
        }
        for (TypeWriter nestedTypeWriter : this.nestedTypeWriters) {
            appendable.append('\n');
            nestedTypeWriter.write(new IndentingAppendable(appendable), context);
        }
        appendable.append("}\n");
        return appendable;
    }

    @Override
    public Set<ClassName> referencedClasses() {
        Iterable concat = Iterables.concat((Iterable[])new Iterable[]{this.nestedTypeWriters, this.methodWriters, this.implementedTypes, this.supertype.asSet(), this.annotations});
        return FluentIterable.from((Iterable)concat).transformAndConcat((Function)new Function<HasClassReferences, Set<ClassName>>(){

            public Set<ClassName> apply(HasClassReferences input) {
                return input.referencedClasses();
            }
        }).toSet();
    }
}

