/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.ClassWriter;
import dagger.internal.codegen.writer.EnumWriter;
import dagger.internal.codegen.writer.HasClassReferences;
import dagger.internal.codegen.writer.InterfaceWriter;
import dagger.internal.codegen.writer.TypeWriter;
import dagger.internal.codegen.writer.Writable;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.tools.JavaFileObject;

public final class JavaWriter {
    private final String packageName;
    private final List<TypeWriter> typeWriters;
    private final List<ClassName> explicitImports;

    public static JavaWriter inPackage(String packageName) {
        return new JavaWriter(packageName);
    }

    public static JavaWriter inPackage(Package enclosingPackage) {
        return new JavaWriter(enclosingPackage.getName());
    }

    public static JavaWriter inPackage(PackageElement packageElement) {
        return new JavaWriter(packageElement.getQualifiedName().toString());
    }

    private JavaWriter(String packageName) {
        this.packageName = packageName;
        this.typeWriters = Lists.newArrayList();
        this.explicitImports = Lists.newArrayList();
    }

    public List<TypeWriter> getTypeWriters() {
        return Collections.unmodifiableList(this.typeWriters);
    }

    public JavaWriter addImport(Class<?> importedClass) {
        this.explicitImports.add(ClassName.fromClass(importedClass));
        return this;
    }

    public ClassWriter addClass(String simpleName) {
        Preconditions.checkNotNull((Object)simpleName);
        ClassWriter classWriter = new ClassWriter(ClassName.create(this.packageName, simpleName));
        this.typeWriters.add(classWriter);
        return classWriter;
    }

    public EnumWriter addEnum(String simpleName) {
        Preconditions.checkNotNull((Object)simpleName);
        EnumWriter writer = new EnumWriter(ClassName.create(this.packageName, simpleName));
        this.typeWriters.add(writer);
        return writer;
    }

    public InterfaceWriter addInterface(String simpleName) {
        InterfaceWriter writer = new InterfaceWriter(ClassName.create(this.packageName, simpleName));
        this.typeWriters.add(writer);
        return writer;
    }

    public Appendable write(Appendable appendable) throws IOException {
        if (!this.packageName.isEmpty()) {
            appendable.append("package ").append(this.packageName).append(";\n\n");
        }
        ImmutableSet classNames = FluentIterable.from(this.typeWriters).transformAndConcat((Function)new Function<HasClassReferences, Set<ClassName>>(){

            public Set<ClassName> apply(HasClassReferences input) {
                return input.referencedClasses();
            }
        }).toSet();
        ImmutableSortedSet importCandidates = ImmutableSortedSet.naturalOrder().addAll(this.explicitImports).addAll((Iterable)classNames).build();
        ImmutableSet typeNames = FluentIterable.from(this.typeWriters).transform((Function)new Function<TypeWriter, ClassName>(){

            public ClassName apply(TypeWriter input) {
                return input.name;
            }
        }).toSet();
        ImmutableSet.Builder declaredSimpleNamesBuilder = ImmutableSet.builder();
        ArrayDeque declaredTypes = Queues.newArrayDeque(this.typeWriters);
        while (!declaredTypes.isEmpty()) {
            TypeWriter currentType = (TypeWriter)declaredTypes.pop();
            declaredSimpleNamesBuilder.add((Object)currentType.name().simpleName());
            declaredTypes.addAll(currentType.nestedTypeWriters);
        }
        ImmutableSet declaredSimpleNames = declaredSimpleNamesBuilder.build();
        HashBiMap importedClassIndex = HashBiMap.create();
        for (ClassName className : importCandidates) {
            if (className.packageName().equals(this.packageName) && !className.enclosingClassName().isPresent() || className.packageName().equals("java.lang") && className.enclosingSimpleNames().isEmpty() || typeNames.contains((Object)className.topLevelClassName())) continue;
            Optional<ClassName> importCandidate = Optional.of((Object)className);
            while (importCandidate.isPresent() && (importedClassIndex.containsKey((Object)((ClassName)importCandidate.get()).simpleName()) || declaredSimpleNames.contains((Object)((ClassName)importCandidate.get()).simpleName()))) {
                importCandidate = ((ClassName)importCandidate.get()).enclosingClassName();
            }
            if (!importCandidate.isPresent()) continue;
            appendable.append("import ").append(((ClassName)importCandidate.get()).canonicalName()).append(";\n");
            importedClassIndex.put((Object)((ClassName)importCandidate.get()).simpleName(), importCandidate.get());
        }
        appendable.append('\n');
        CompilationUnitContext context = new CompilationUnitContext(this.packageName, (Set<ClassName>)ImmutableSet.copyOf((Collection)importedClassIndex.values()));
        for (TypeWriter typeWriter : this.typeWriters) {
            typeWriter.write(appendable, context.createSubcontext((Set<ClassName>)typeNames)).append('\n');
        }
        return appendable;
    }

    public void file(Filer filer, Iterable<? extends Element> originatingElements) throws IOException {
        this.file(filer, ((TypeWriter)Iterables.getOnlyElement(this.typeWriters)).name.canonicalName(), originatingElements);
    }

    public void file(Filer filer, CharSequence name, Iterable<? extends Element> originatingElements) throws IOException {
        JavaFileObject sourceFile = filer.createSourceFile(name, (Element[])Iterables.toArray(originatingElements, Element.class));
        try (Closer closer = Closer.create();){
            this.write((Appendable)((Object)closer.register((Closeable)sourceFile.openWriter())));
        }
    }

    public String toString() {
        try {
            return this.write(new StringBuilder()).toString();
        }
        catch (IOException e) {
            throw new AssertionError();
        }
    }

    static final class CompilationUnitContext
    implements Writable.Context {
        private final String packageName;
        private final ImmutableSortedSet<ClassName> visibleClasses;

        CompilationUnitContext(String packageName, Set<ClassName> visibleClasses) {
            this.packageName = packageName;
            this.visibleClasses = ImmutableSortedSet.copyOf((Comparator)Ordering.natural().reverse(), visibleClasses);
        }

        @Override
        public Writable.Context createSubcontext(Set<ClassName> newTypes) {
            return new CompilationUnitContext(this.packageName, (Set<ClassName>)Sets.union(this.visibleClasses, newTypes));
        }

        @Override
        public String sourceReferenceForClassName(ClassName className) {
            if (this.isImported(className)) {
                return className.simpleName();
            }
            Optional<ClassName> enclosingClassName = className.enclosingClassName();
            while (enclosingClassName.isPresent()) {
                if (this.isImported((ClassName)enclosingClassName.get())) {
                    return ((ClassName)enclosingClassName.get()).simpleName() + className.canonicalName().substring(((ClassName)enclosingClassName.get()).canonicalName().length());
                }
                enclosingClassName = ((ClassName)enclosingClassName.get()).enclosingClassName();
            }
            return className.canonicalName();
        }

        private boolean collidesWithVisibleClass(ClassName className) {
            return this.collidesWithVisibleClass(className.simpleName());
        }

        private boolean collidesWithVisibleClass(String simpleName) {
            return FluentIterable.from(this.visibleClasses).transform((Function)new Function<ClassName, String>(){

                public String apply(ClassName input) {
                    return input.simpleName();
                }
            }).contains((Object)simpleName);
        }

        private boolean isImported(ClassName className) {
            return this.packageName.equals(className.packageName()) && !className.enclosingClassName().isPresent() && !this.collidesWithVisibleClass(className) || this.visibleClasses.contains((Object)className) || className.packageName().equals("java.lang") && className.enclosingSimpleNames().isEmpty();
        }
    }
}

