/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.Writable;
import dagger.internal.codegen.writer.Writables;
import java.io.IOException;
import java.util.Set;

public final class ParameterizedTypeName
implements TypeName {
    private final ClassName type;
    private final ImmutableList<TypeName> parameters;

    ParameterizedTypeName(ClassName type, Iterable<? extends TypeName> parameters) {
        this.type = type;
        this.parameters = ImmutableList.copyOf(parameters);
    }

    public ClassName type() {
        return this.type;
    }

    public ImmutableList<TypeName> parameters() {
        return this.parameters;
    }

    @Override
    public Set<ClassName> referencedClasses() {
        ImmutableSet.Builder builder = new ImmutableSet.Builder().add((Object)this.type);
        for (TypeName parameter : this.parameters) {
            builder.addAll(parameter.referencedClasses());
        }
        return builder.build();
    }

    @Override
    public Appendable write(Appendable appendable, Writable.Context context) throws IOException {
        appendable.append(context.sourceReferenceForClassName(this.type));
        UnmodifiableIterator parameterIterator = this.parameters.iterator();
        Verify.verify((boolean)parameterIterator.hasNext(), (String)this.type.toString(), (Object[])new Object[0]);
        appendable.append('<');
        ((TypeName)parameterIterator.next()).write(appendable, context);
        while (parameterIterator.hasNext()) {
            appendable.append(", ");
            ((TypeName)parameterIterator.next()).write(appendable, context);
        }
        appendable.append('>');
        return appendable;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ParameterizedTypeName) {
            ParameterizedTypeName that = (ParameterizedTypeName)obj;
            return this.type.equals(that.type) && this.parameters.equals(that.parameters);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.parameters});
    }

    public String toString() {
        return Writables.writeToString(this);
    }

    public static ParameterizedTypeName create(ClassName className, TypeName ... parameters) {
        return new ParameterizedTypeName(className, (Iterable<? extends TypeName>)ImmutableList.copyOf((Object[])parameters));
    }

    public static ParameterizedTypeName create(ClassName className, Iterable<? extends TypeName> parameters) {
        return new ParameterizedTypeName(className, (Iterable<? extends TypeName>)ImmutableList.copyOf(parameters));
    }

    public static ParameterizedTypeName create(Class<?> parameterizedClass, TypeName ... parameters) {
        Preconditions.checkArgument((parameterizedClass.getTypeParameters().length == parameters.length ? 1 : 0) != 0);
        return new ParameterizedTypeName(ClassName.fromClass(parameterizedClass), (Iterable<? extends TypeName>)ImmutableList.copyOf((Object[])parameters));
    }
}

