/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.HasClassReferences;
import dagger.internal.codegen.writer.HasTypeName;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.Writable;
import dagger.internal.codegen.writer.Writables;
import java.io.IOException;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Set;

public final class Snippet
implements HasClassReferences,
Writable {
    private final String format;
    private final ImmutableSet<TypeName> types;
    private final ImmutableList<Object> args;

    private Snippet(String format, ImmutableSet<TypeName> types, ImmutableList<Object> args) {
        this.format = format;
        this.types = types;
        this.args = args;
    }

    public String format() {
        return this.format;
    }

    public ImmutableList<Object> args() {
        return this.args;
    }

    public ImmutableSet<TypeName> types() {
        return this.types;
    }

    public String toString() {
        return Writables.writeToString(this);
    }

    @Override
    public Set<ClassName> referencedClasses() {
        return FluentIterable.from(this.types).transformAndConcat((Function)new Function<TypeName, Set<ClassName>>(){

            public Set<ClassName> apply(TypeName input) {
                return input.referencedClasses();
            }
        }).toSet();
    }

    @Override
    public Appendable write(Appendable appendable, Writable.Context context) throws IOException {
        ImmutableList.Builder formattedArgsBuilder = ImmutableList.builder();
        for (Object arg : this.args) {
            if (arg instanceof Writable) {
                formattedArgsBuilder.add((Object)((Writable)arg).write(new StringBuilder(), context).toString());
                continue;
            }
            formattedArgsBuilder.add(arg);
        }
        Formatter formatter = new Formatter(appendable);
        formatter.format(this.format, formattedArgsBuilder.build().toArray(new Object[0]));
        return appendable;
    }

    public static Snippet format(String format, Object ... args) {
        ImmutableSet.Builder types = ImmutableSet.builder();
        for (Object arg : args) {
            if (arg instanceof Snippet) {
                types.addAll(((Snippet)arg).types);
            }
            if (arg instanceof TypeName) {
                types.add((Object)((TypeName)arg));
            }
            if (!(arg instanceof HasTypeName)) continue;
            types.add((Object)((HasTypeName)arg).name());
        }
        return new Snippet(format, (ImmutableSet<TypeName>)types.build(), (ImmutableList<Object>)ImmutableList.copyOf((Object[])args));
    }

    public static Snippet format(String format, Iterable<? extends Object> args) {
        return Snippet.format(format, Iterables.toArray(args, Object.class));
    }

    public static Snippet memberSelectSnippet(Iterable<? extends Object> selectors) {
        return Snippet.format(Joiner.on((char)'.').join(Collections.nCopies(Iterables.size(selectors), "%s")), selectors);
    }

    public static Snippet makeParametersSnippet(Iterable<Snippet> parameterSnippets) {
        Iterator<Snippet> iterator = parameterSnippets.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        ImmutableSet.Builder typesBuilder = ImmutableSet.builder();
        ImmutableList.Builder argsBuilder = ImmutableList.builder();
        if (iterator.hasNext()) {
            Snippet firstSnippet = iterator.next();
            stringBuilder.append(firstSnippet.format());
            typesBuilder.addAll(firstSnippet.types());
            argsBuilder.addAll(firstSnippet.args());
        }
        while (iterator.hasNext()) {
            Snippet nextSnippet = iterator.next();
            stringBuilder.append(", ").append(nextSnippet.format());
            typesBuilder.addAll(nextSnippet.types());
            argsBuilder.addAll(nextSnippet.args());
        }
        return new Snippet(stringBuilder.toString(), (ImmutableSet<TypeName>)typesBuilder.build(), (ImmutableList<Object>)argsBuilder.build());
    }
}

