/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.TypeNames;
import dagger.internal.codegen.writer.Writable;
import dagger.internal.codegen.writer.Writables;
import dagger.shaded.auto.common.MoreTypes;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public final class TypeVariableName
implements TypeName {
    private final CharSequence name;
    private final Iterable<? extends TypeName> extendsBounds;

    TypeVariableName(CharSequence name, Iterable<? extends TypeName> extendsBounds) {
        this.name = name;
        this.extendsBounds = extendsBounds;
    }

    public CharSequence name() {
        return this.name;
    }

    @Override
    public Set<ClassName> referencedClasses() {
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        for (TypeName typeName : this.extendsBounds) {
            builder.addAll(typeName.referencedClasses());
        }
        return builder.build();
    }

    @Override
    public Appendable write(Appendable appendable, Writable.Context context) throws IOException {
        appendable.append(this.name);
        if (!Iterables.isEmpty(this.extendsBounds)) {
            appendable.append(" extends ");
            Iterator<? extends TypeName> iter = this.extendsBounds.iterator();
            iter.next().write(appendable, context);
            while (iter.hasNext()) {
                appendable.append(" & ");
                iter.next().write(appendable, context);
            }
        }
        return appendable;
    }

    public String toString() {
        return Writables.writeToString(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TypeVariableName) {
            TypeVariableName that = (TypeVariableName)obj;
            return this.name.toString().equals(that.name.toString()) && this.extendsBounds.equals(that.extendsBounds);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.extendsBounds});
    }

    static TypeVariableName named(CharSequence name) {
        return new TypeVariableName(name, (Iterable<? extends TypeName>)ImmutableList.of());
    }

    public static TypeVariableName fromTypeVariable(TypeVariable variable) {
        return TypeVariableName.named(variable.asElement().getSimpleName());
    }

    public static TypeVariableName fromTypeParameterElement(TypeParameterElement element) {
        FluentIterable bounds = FluentIterable.from(element.getBounds()).filter((Predicate)new Predicate<TypeMirror>(){

            public boolean apply(TypeMirror input) {
                return !MoreTypes.isType(input) || !MoreTypes.isTypeOf(Object.class, input);
            }
        }).transform(TypeNames.FOR_TYPE_MIRROR);
        return new TypeVariableName(element.getSimpleName(), (Iterable<? extends TypeName>)bounds);
    }
}

