/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writer;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dagger.internal.codegen.writer.ClassName;
import dagger.internal.codegen.writer.ClassWriter;
import dagger.internal.codegen.writer.FieldWriter;
import dagger.internal.codegen.writer.HasClassReferences;
import dagger.internal.codegen.writer.HasTypeName;
import dagger.internal.codegen.writer.MethodWriter;
import dagger.internal.codegen.writer.Modifiable;
import dagger.internal.codegen.writer.TypeName;
import dagger.internal.codegen.writer.TypeNames;
import dagger.internal.codegen.writer.Writable;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public abstract class TypeWriter
extends Modifiable
implements Writable,
HasTypeName,
HasClassReferences {
    final ClassName name;
    Optional<TypeName> supertype;
    final List<TypeName> implementedTypes;
    final List<MethodWriter> methodWriters;
    final List<TypeWriter> nestedTypeWriters;
    final Map<String, FieldWriter> fieldWriters;

    TypeWriter(ClassName name) {
        this.name = name;
        this.supertype = Optional.absent();
        this.implementedTypes = Lists.newArrayList();
        this.methodWriters = Lists.newArrayList();
        this.nestedTypeWriters = Lists.newArrayList();
        this.fieldWriters = Maps.newLinkedHashMap();
    }

    @Override
    public ClassName name() {
        return this.name;
    }

    public MethodWriter addMethod(TypeWriter returnType, String name) {
        MethodWriter methodWriter = new MethodWriter(returnType.name, name);
        this.methodWriters.add(methodWriter);
        return methodWriter;
    }

    public MethodWriter addMethod(TypeMirror returnType, String name) {
        MethodWriter methodWriter = new MethodWriter(TypeNames.forTypeMirror(returnType), name);
        this.methodWriters.add(methodWriter);
        return methodWriter;
    }

    public MethodWriter addMethod(TypeName returnType, String name) {
        MethodWriter methodWriter = new MethodWriter(returnType, name);
        this.methodWriters.add(methodWriter);
        return methodWriter;
    }

    public MethodWriter addMethod(Class<?> returnType, String name) {
        MethodWriter methodWriter = new MethodWriter(ClassName.fromClass(returnType), name);
        this.methodWriters.add(methodWriter);
        return methodWriter;
    }

    public ClassWriter addNestedClass(String name) {
        ClassWriter innerClassWriter = new ClassWriter(this.name.nestedClassNamed(name));
        this.nestedTypeWriters.add(innerClassWriter);
        return innerClassWriter;
    }

    public void addImplementedType(TypeName typeReference) {
        this.implementedTypes.add(typeReference);
    }

    public void addImplementedType(TypeElement typeElement) {
        this.implementedTypes.add(ClassName.fromTypeElement(typeElement));
    }

    public void setSuperType(TypeName typeReference) {
        Preconditions.checkState((!this.supertype.isPresent() ? 1 : 0) != 0);
        this.supertype = Optional.of((Object)typeReference);
    }

    public void setSuperType(TypeElement typeElement) {
        this.setSuperType(ClassName.fromTypeElement(typeElement));
    }

    public FieldWriter addField(Class<?> type, String name) {
        return this.addField(ClassName.fromClass(type), name);
    }

    public FieldWriter addField(TypeElement type, String name) {
        return this.addField(ClassName.fromTypeElement(type), name);
    }

    public FieldWriter addField(TypeName type, String name) {
        String candidateName = name;
        int differentiator = 1;
        while (this.fieldWriters.containsKey(candidateName)) {
            candidateName = name + differentiator;
            ++differentiator;
        }
        FieldWriter fieldWriter = new FieldWriter(type, candidateName);
        this.fieldWriters.put(candidateName, fieldWriter);
        return fieldWriter;
    }
}

