/*
 * Decompiled with CFR 0.152.
 */
package dagger.shaded.auto.common;

import com.google.common.base.Ascii;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.SuperficialValidation;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.tools.Diagnostic;

public abstract class BasicAnnotationProcessor
extends AbstractProcessor {
    private final Set<String> deferredPackageNames = Sets.newLinkedHashSet();
    private final Set<String> deferredTypeNames = Sets.newLinkedHashSet();
    private final String processorName = this.getClass().getCanonicalName();
    private Elements elements;
    private Messager messager;
    private ImmutableList<? extends ProcessingStep> steps;
    private static final String INVALID_ELEMENT_MESSAGE_FORMAT = "%s was unable to process %s because not all of its dependencies could be resolved. Check for compilation errors or a circular dependency with generated code.";

    @Override
    public final synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elements = processingEnv.getElementUtils();
        this.messager = processingEnv.getMessager();
        this.steps = ImmutableList.copyOf(this.initSteps());
    }

    protected abstract Iterable<? extends ProcessingStep> initSteps();

    protected void postProcess() {
    }

    private ImmutableSet<? extends Class<? extends Annotation>> getSupportedAnnotationClasses() {
        Preconditions.checkState((this.steps != null ? 1 : 0) != 0);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ProcessingStep step : this.steps) {
            builder.addAll(step.annotations());
        }
        return builder.build();
    }

    public final ImmutableSet<String> getSupportedAnnotationTypes() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Class annotationClass : this.getSupportedAnnotationClasses()) {
            builder.add((Object)annotationClass.getCanonicalName());
        }
        return builder.build();
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Preconditions.checkState((this.elements != null ? 1 : 0) != 0);
        Preconditions.checkState((this.messager != null ? 1 : 0) != 0);
        Preconditions.checkState((this.steps != null ? 1 : 0) != 0);
        ImmutableMap.Builder deferredElementsBuilder = ImmutableMap.builder();
        for (String deferredTypeName : this.deferredTypeNames) {
            deferredElementsBuilder.put((Object)deferredTypeName, (Object)Optional.fromNullable((Object)this.elements.getTypeElement(deferredTypeName)));
        }
        for (String deferredPackageName : this.deferredPackageNames) {
            deferredElementsBuilder.put((Object)deferredPackageName, (Object)Optional.fromNullable((Object)this.elements.getPackageElement(deferredPackageName)));
        }
        ImmutableMap deferredElements = deferredElementsBuilder.build();
        this.deferredTypeNames.clear();
        this.deferredPackageNames.clear();
        if (roundEnv.processingOver()) {
            this.reportMissingElements((Map<String, ? extends Optional<? extends Element>>)deferredElements);
            return false;
        }
        ImmutableSetMultimap.Builder deferredElementsByAnnotationBuilder = ImmutableSetMultimap.builder();
        for (Map.Entry deferredTypeElementEntry : deferredElements.entrySet()) {
            Optional deferredElement = (Optional)deferredTypeElementEntry.getValue();
            if (deferredElement.isPresent()) {
                BasicAnnotationProcessor.findAnnotatedElements((Element)deferredElement.get(), this.getSupportedAnnotationClasses(), (ImmutableSetMultimap.Builder<Class<? extends Annotation>, Element>)deferredElementsByAnnotationBuilder);
                continue;
            }
            this.deferredTypeNames.add((String)deferredTypeElementEntry.getKey());
        }
        ImmutableSetMultimap deferredElementsByAnnotation = deferredElementsByAnnotationBuilder.build();
        ImmutableSetMultimap.Builder elementsByAnnotationBuilder = ImmutableSetMultimap.builder();
        LinkedHashSet validPackageNames = Sets.newLinkedHashSet();
        LinkedHashSet validTypeNames = Sets.newLinkedHashSet();
        for (Class annotationClass : this.getSupportedAnnotationClasses()) {
            TypeElement annotationType = this.elements.getTypeElement(annotationClass.getCanonicalName());
            ImmutableSet elementsAnnotatedWith = annotationType == null ? ImmutableSet.of() : roundEnv.getElementsAnnotatedWith(annotationType);
            for (Element annotatedElement : Sets.union((Set)elementsAnnotatedWith, (Set)deferredElementsByAnnotation.get((Object)annotationClass))) {
                boolean validEnclosingType;
                if (annotatedElement.getKind().equals((Object)ElementKind.PACKAGE)) {
                    boolean validPackage;
                    PackageElement annotatedPackageElement = (PackageElement)annotatedElement;
                    String annotatedPackageName = annotatedPackageElement.getQualifiedName().toString();
                    boolean bl = validPackage = validPackageNames.contains(annotatedPackageName) || !this.deferredPackageNames.contains(annotatedPackageName) && SuperficialValidation.validateElement(annotatedPackageElement);
                    if (validPackage) {
                        elementsByAnnotationBuilder.put((Object)annotationClass, (Object)annotatedPackageElement);
                        validPackageNames.add(annotatedPackageName);
                        continue;
                    }
                    this.deferredPackageNames.add(annotatedPackageName);
                    continue;
                }
                TypeElement enclosingType = BasicAnnotationProcessor.getEnclosingType(annotatedElement);
                String enclosingTypeName = enclosingType.getQualifiedName().toString();
                boolean bl = validEnclosingType = validTypeNames.contains(enclosingTypeName) || !this.deferredTypeNames.contains(enclosingTypeName) && SuperficialValidation.validateElement(enclosingType);
                if (validEnclosingType) {
                    elementsByAnnotationBuilder.put((Object)annotationClass, (Object)annotatedElement);
                    validTypeNames.add(enclosingTypeName);
                    continue;
                }
                this.deferredTypeNames.add(enclosingTypeName);
            }
        }
        ImmutableSetMultimap elementsByAnnotation = elementsByAnnotationBuilder.build();
        for (ProcessingStep step : this.steps) {
            SetMultimap filteredMap = Multimaps.filterKeys((SetMultimap)elementsByAnnotation, (Predicate)Predicates.in(step.annotations()));
            if (filteredMap.isEmpty()) continue;
            step.process((SetMultimap<Class<? extends Annotation>, Element>)filteredMap);
        }
        this.postProcess();
        return false;
    }

    private void reportMissingElements(Map<String, ? extends Optional<? extends Element>> missingElements) {
        for (Map.Entry<String, ? extends Optional<? extends Element>> missingElementEntry : missingElements.entrySet()) {
            Optional<? extends Element> missingElement = missingElementEntry.getValue();
            if (missingElement.isPresent()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(INVALID_ELEMENT_MESSAGE_FORMAT, this.processorName, "this " + Ascii.toLowerCase((String)((Element)missingElement.get()).getKind().name())), (Element)missingElement.get());
                continue;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format(INVALID_ELEMENT_MESSAGE_FORMAT, this.processorName, missingElementEntry.getKey()));
        }
    }

    private static void findAnnotatedElements(Element element, ImmutableSet<? extends Class<? extends Annotation>> annotationClasses, ImmutableSetMultimap.Builder<Class<? extends Annotation>, Element> builder) {
        for (Element element2 : element.getEnclosedElements()) {
            BasicAnnotationProcessor.findAnnotatedElements(element2, annotationClasses, builder);
        }
        for (Class clazz : annotationClasses) {
            if (!MoreElements.isAnnotationPresent(element, clazz)) continue;
            builder.put((Object)clazz, (Object)element);
        }
    }

    private static TypeElement getEnclosingType(Element element) {
        return element.accept(new SimpleElementVisitor6<TypeElement, Void>(){

            @Override
            protected TypeElement defaultAction(Element e, Void p) {
                return e.getEnclosingElement().accept(this, p);
            }

            @Override
            public TypeElement visitType(TypeElement e, Void p) {
                return e;
            }

            @Override
            public TypeElement visitPackage(PackageElement e, Void p) {
                throw new IllegalArgumentException();
            }
        }, null);
    }

    public static interface ProcessingStep {
        public Set<? extends Class<? extends Annotation>> annotations();

        public void process(SetMultimap<Class<? extends Annotation>, Element> var1);
    }
}

