/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.squareup.javapoet.TypeName;
import dagger.Component;
import dagger.internal.codegen.BindingDeclaration;
import dagger.internal.codegen.BindingDeclarationFormatter;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentTreeTraverser;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.DependencyRequestFormatter;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.InjectBindingRegistry;
import dagger.internal.codegen.InjectValidator;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.KeyFormatter;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MembersInjectionBinding;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.MissingBindingSuggestions;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.OptionalType;
import dagger.internal.codegen.ResolvedBindings;
import dagger.internal.codegen.Scope;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.ValidationReport;
import dagger.internal.codegen.ValidationType;
import dagger.releasablereferences.CanReleaseReferences;
import dagger.releasablereferences.ForReleasableReferences;
import dagger.releasablereferences.ReleasableReferenceManager;
import dagger.releasablereferences.TypedReleasableReferenceManager;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Provider;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;

final class BindingGraphValidator {
    private final Elements elements;
    private final Types types;
    private final CompilerOptions compilerOptions;
    private final InjectValidator injectValidator;
    private final InjectBindingRegistry injectBindingRegistry;
    private final BindingDeclarationFormatter bindingDeclarationFormatter;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final DependencyRequestFormatter dependencyRequestFormatter;
    private final KeyFormatter keyFormatter;
    private final Key.Factory keyFactory;

    BindingGraphValidator(Elements elements, Types types, CompilerOptions compilerOptions, InjectValidator injectValidator, InjectBindingRegistry injectBindingRegistry, BindingDeclarationFormatter bindingDeclarationFormatter, MethodSignatureFormatter methodSignatureFormatter, DependencyRequestFormatter dependencyRequestFormatter, KeyFormatter keyFormatter, Key.Factory keyFactory) {
        this.elements = elements;
        this.types = types;
        this.compilerOptions = compilerOptions;
        this.injectValidator = injectValidator;
        this.injectBindingRegistry = injectBindingRegistry;
        this.bindingDeclarationFormatter = bindingDeclarationFormatter;
        this.methodSignatureFormatter = methodSignatureFormatter;
        this.dependencyRequestFormatter = dependencyRequestFormatter;
        this.keyFormatter = keyFormatter;
        this.keyFactory = keyFactory;
    }

    ValidationReport<TypeElement> validate(BindingGraph graph) {
        ComponentValidation validation = new ComponentValidation(graph);
        validation.traverseComponents();
        return validation.buildReport();
    }

    private void appendIndentedComponentsList(StringBuilder message, Iterable<TypeElement> types) {
        for (TypeElement scopedComponent : types) {
            message.append("    ");
            for (Scope scope : Scope.scopesOf(scopedComponent)) {
                message.append(scope.getReadableSource()).append(' ');
            }
            message.append(ErrorMessages.stripCommonTypePrefixes(scopedComponent.getQualifiedName().toString())).append('\n');
        }
    }

    private ImmutableSet<TypeElement> scopedTypesIn(Set<TypeElement> types) {
        return types.stream().filter(type -> !Scope.scopesOf(type).isEmpty()).collect(Util.toImmutableSet());
    }

    private String formatContributionType(ContributionType type) {
        switch (type) {
            case MAP: {
                return "Map";
            }
            case SET: 
            case SET_VALUES: {
                return "Set";
            }
            case UNIQUE: {
                return "Unique";
            }
        }
        throw new IllegalStateException("Unknown binding type: " + (Object)((Object)type));
    }

    private final class ComponentValidation
    extends ComponentTreeTraverser {
        final BindingGraph rootGraph;
        final Map<ComponentDescriptor, ValidationReport.Builder<TypeElement>> reports;
        private final SetMultimap<ComponentDescriptor, ContributionBinding> incompatiblyScopedBindings;

        ComponentValidation(BindingGraph rootGraph) {
            super(rootGraph);
            this.reports = new LinkedHashMap<ComponentDescriptor, ValidationReport.Builder<TypeElement>>();
            this.incompatiblyScopedBindings = LinkedHashMultimap.create();
            this.rootGraph = rootGraph;
        }

        @Override
        protected ComponentTreeTraverser.BindingGraphTraverser bindingGraphTraverser(ComponentTreeTraverser.ComponentTreePath componentPath, DependencyRequest entryPoint) {
            return new BindingGraphValidation(componentPath, entryPoint);
        }

        ValidationReport<TypeElement> buildReport() {
            ValidationReport.Builder<TypeElement> report = ValidationReport.about(this.rootGraph.componentType());
            this.reports.values().forEach(subreport -> report.addSubreport(subreport.build()));
            return report.build();
        }

        private ValidationReport.Builder<TypeElement> report(BindingGraph graph) {
            return this.reports.computeIfAbsent(graph.componentDescriptor(), descriptor -> ValidationReport.about(descriptor.componentDefinitionType()));
        }

        @Override
        protected void visitComponent(BindingGraph graph) {
            this.validateDependencyScopes(graph);
            this.validateComponentDependencyHierarchy(graph);
            this.validateBuilders(graph);
            super.visitComponent(graph);
            this.checkScopedBindings(graph);
        }

        @Override
        protected void visitSubcomponentFactoryMethod(BindingGraph graph, BindingGraph parent, ExecutableElement factoryMethod) {
            Set missingModules = graph.componentRequirements().stream().filter(componentRequirement -> componentRequirement.kind().equals((Object)ComponentRequirement.Kind.MODULE)).map(ComponentRequirement::typeElement).filter(moduleType -> !this.subgraphFactoryMethodParameters(parent, factoryMethod).contains(moduleType)).filter(moduleType -> !Util.componentCanMakeNewInstances(moduleType)).collect(Collectors.toSet());
            if (!missingModules.isEmpty()) {
                this.report(parent).addError(String.format("%s requires modules which have no visible default constructors. Add the following modules as parameters to this method: %s", graph.componentType().getQualifiedName(), missingModules.stream().map(Object::toString).collect(Collectors.joining(", "))), factoryMethod);
            }
        }

        private ImmutableSet<TypeElement> subgraphFactoryMethodParameters(BindingGraph parent, ExecutableElement childFactoryMethod) {
            DeclaredType componentType = MoreTypes.asDeclared(parent.componentType().asType());
            ExecutableType factoryMethodType = MoreTypes.asExecutable(BindingGraphValidator.this.types.asMemberOf(componentType, childFactoryMethod));
            return MoreTypes.asTypeElements(factoryMethodType.getParameterTypes());
        }

        private void validateComponentDependencyHierarchy(BindingGraph graph) {
            this.validateComponentDependencyHierarchy(graph, graph.componentType(), new ArrayDeque<TypeElement>());
        }

        private void validateComponentDependencyHierarchy(BindingGraph graph, TypeElement dependency, Deque<TypeElement> dependencyStack) {
            if (dependencyStack.contains(dependency)) {
                StringBuilder message = new StringBuilder();
                message.append(graph.componentType().getQualifiedName());
                message.append(" contains a cycle in its component dependencies:\n");
                dependencyStack.push(dependency);
                BindingGraphValidator.this.appendIndentedComponentsList(message, dependencyStack);
                dependencyStack.pop();
                this.report(graph).addItem(message.toString(), BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), graph.componentType(), ConfigurationAnnotations.getComponentAnnotation(graph.componentType()).get());
            } else {
                Optional<AnnotationMirror> componentAnnotation = ConfigurationAnnotations.getComponentAnnotation(dependency);
                if (componentAnnotation.isPresent()) {
                    dependencyStack.push(dependency);
                    ImmutableSet<TypeElement> dependencies = MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentDependencies(componentAnnotation.get()));
                    for (TypeElement nextDependency : dependencies) {
                        this.validateComponentDependencyHierarchy(graph, nextDependency, dependencyStack);
                    }
                    dependencyStack.pop();
                }
            }
        }

        private void validateDependencyScopes(BindingGraph graph) {
            ComponentDescriptor descriptor = graph.componentDescriptor();
            ImmutableSet<Scope> scopes = descriptor.scopes();
            ImmutableSet scopedDependencies = BindingGraphValidator.this.scopedTypesIn(descriptor.dependencies());
            if (!scopes.isEmpty()) {
                Scope singletonScope = Scope.singletonScope(BindingGraphValidator.this.elements);
                if (BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().isPresent() && scopes.contains((Object)singletonScope)) {
                    if (!scopedDependencies.isEmpty()) {
                        StringBuilder message = new StringBuilder("This @Singleton component cannot depend on scoped components:\n");
                        BindingGraphValidator.this.appendIndentedComponentsList(message, (Iterable)scopedDependencies);
                        this.report(graph).addItem(message.toString(), BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), descriptor.componentDefinitionType(), descriptor.componentAnnotation());
                    }
                } else if (scopedDependencies.size() > 1) {
                    StringBuilder message = new StringBuilder();
                    for (Scope scope : scopes) {
                        message.append(scope.getReadableSource()).append(' ');
                    }
                    message.append(descriptor.componentDefinitionType().getQualifiedName()).append(" depends on more than one scoped component:\n");
                    BindingGraphValidator.this.appendIndentedComponentsList(message, (Iterable)scopedDependencies);
                    this.report(graph).addError(message.toString(), descriptor.componentDefinitionType(), descriptor.componentAnnotation());
                } else if (!BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().equals((Object)ValidationType.NONE)) {
                    this.validateDependencyScopeHierarchy(graph, descriptor.componentDefinitionType(), new ArrayDeque<ImmutableSet<Scope>>(), new ArrayDeque<TypeElement>());
                }
            } else if (!scopedDependencies.isEmpty()) {
                StringBuilder message = new StringBuilder(descriptor.componentDefinitionType().getQualifiedName()).append(" (unscoped) cannot depend on scoped components:\n");
                BindingGraphValidator.this.appendIndentedComponentsList(message, (Iterable)scopedDependencies);
                this.report(graph).addError(message.toString(), descriptor.componentDefinitionType(), descriptor.componentAnnotation());
            }
        }

        private void validateBuilders(BindingGraph graph) {
            Sets.SetView missingSetters;
            ComponentDescriptor componentDesc = graph.componentDescriptor();
            if (!componentDesc.builderSpec().isPresent()) {
                return;
            }
            ImmutableSet<ComponentRequirement> availableDependencies = graph.availableDependencies();
            Set requiredDependencies = Sets.filter(availableDependencies, input -> input.nullPolicy(BindingGraphValidator.this.elements, BindingGraphValidator.this.types).equals((Object)ComponentRequirement.NullPolicy.THROW));
            ComponentDescriptor.BuilderSpec spec = componentDesc.builderSpec().get();
            ImmutableSet declaredSetters = spec.requirementMethods().stream().filter(method -> !method.requirement().kind().equals((Object)ComponentRequirement.Kind.BINDING)).collect(Util.toImmutableSet());
            ImmutableSet declaredRequirements = declaredSetters.stream().map(ComponentDescriptor.BuilderRequirementMethod::requirement).collect(Util.toImmutableSet());
            ErrorMessages.ComponentBuilderMessages msgs = ErrorMessages.builderMsgsFor(graph.componentDescriptor().kind());
            Sets.SetView extraSetters = Sets.difference(declaredRequirements, availableDependencies);
            if (!extraSetters.isEmpty()) {
                List excessMethods = declaredSetters.stream().filter(arg_0 -> ComponentValidation.lambda$validateBuilders$7((Set)extraSetters, arg_0)).map(ComponentDescriptor.BuilderRequirementMethod::method).collect(Collectors.toList());
                Optional<DeclaredType> container = Optional.of(MoreTypes.asDeclared(spec.builderDefinitionType().asType()));
                String formatted = excessMethods.stream().map(method -> BindingGraphValidator.this.methodSignatureFormatter.format((ExecutableElement)method, container)).collect(Collectors.joining(", ", "[", "]"));
                this.report(graph).addError(String.format(msgs.extraSetters(), formatted), spec.builderDefinitionType());
            }
            if (!(missingSetters = Sets.difference((Set)requiredDependencies, declaredRequirements)).isEmpty()) {
                this.report(graph).addError(String.format(msgs.missingSetters(), missingSetters.stream().map(ComponentRequirement::type).collect(Collectors.toList())), spec.builderDefinitionType());
            }
            Map declaredRequirementsByType = spec.requirementMethods().stream().filter(method -> !method.requirement().kind().equals((Object)ComponentRequirement.Kind.BINDING)).collect(Collectors.groupingBy(method -> method.requirement().wrappedType(), Collectors.mapping(method -> method.method(), Collectors.toList())));
            for (Map.Entry entry : declaredRequirementsByType.entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                TypeMirror type = (TypeMirror)entry.getKey().get();
                this.report(graph).addError(String.format(msgs.manyMethodsForType(), type, entry.getValue()), spec.builderDefinitionType());
            }
        }

        private void validateDependencyScopeHierarchy(BindingGraph graph, TypeElement dependency, Deque<ImmutableSet<Scope>> scopeStack, Deque<TypeElement> scopedDependencyStack) {
            ImmutableSet<Scope> scopes = Scope.scopesOf(dependency);
            if (this.stackOverlaps(scopeStack, scopes)) {
                scopedDependencyStack.push(dependency);
                StringBuilder message = new StringBuilder();
                message.append(graph.componentType().getQualifiedName());
                message.append(" depends on scoped components in a non-hierarchical scope ordering:\n");
                BindingGraphValidator.this.appendIndentedComponentsList(message, scopedDependencyStack);
                if (BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().isPresent()) {
                    this.report(graph).addItem(message.toString(), BindingGraphValidator.this.compilerOptions.scopeCycleValidationType().diagnosticKind().get(), graph.componentType(), ConfigurationAnnotations.getComponentAnnotation(graph.componentType()).get());
                }
                scopedDependencyStack.pop();
            } else {
                DaggerElements.getAnnotationMirror(dependency, Component.class).ifPresent(componentAnnotation -> {
                    ImmutableSet scopedDependencies = BindingGraphValidator.this.scopedTypesIn(MoreTypes.asTypeElements(ConfigurationAnnotations.getComponentDependencies(componentAnnotation)));
                    if (scopedDependencies.size() == 1) {
                        scopeStack.push(scopes);
                        scopedDependencyStack.push(dependency);
                        this.validateDependencyScopeHierarchy(graph, (TypeElement)Iterables.getOnlyElement((Iterable)scopedDependencies), scopeStack, scopedDependencyStack);
                        scopedDependencyStack.pop();
                        scopeStack.pop();
                    }
                });
            }
        }

        private <T> boolean stackOverlaps(Deque<ImmutableSet<T>> stack, ImmutableSet<T> set) {
            for (ImmutableSet<T> entry : stack) {
                if (Sets.intersection(entry, set).isEmpty()) continue;
                return true;
            }
            return false;
        }

        private void checkBindingScope(ContributionBinding binding, ComponentDescriptor owningComponent) {
            if (binding.scope().isPresent() && !binding.scope().get().equals(Scope.reusableScope(BindingGraphValidator.this.elements)) && !owningComponent.scopes().contains((Object)binding.scope().get())) {
                this.incompatiblyScopedBindings.put((Object)owningComponent, (Object)binding);
            }
        }

        private void checkScopedBindings(BindingGraph graph) {
            if (!this.incompatiblyScopedBindings.containsKey((Object)graph.componentDescriptor())) {
                return;
            }
            StringBuilder message = new StringBuilder(graph.componentType().getQualifiedName());
            if (!graph.componentDescriptor().scopes().isEmpty()) {
                message.append(" scoped with ");
                for (Scope scope : graph.componentDescriptor().scopes()) {
                    message.append(scope.getReadableSource()).append(' ');
                }
                message.append("may not reference bindings with different scopes:\n");
            } else {
                message.append(" (unscoped) may not reference scoped bindings:\n");
            }
            for (ContributionBinding binding : this.incompatiblyScopedBindings.get((Object)graph.componentDescriptor())) {
                message.append("    ");
                switch (binding.bindingKind()) {
                    case SYNTHETIC_DELEGATE_BINDING: 
                    case PROVISION: {
                        message.append(BindingGraphValidator.this.methodSignatureFormatter.format(MoreElements.asExecutable(binding.bindingElement().get())));
                        break;
                    }
                    case INJECTION: {
                        message.append(binding.scope().get().getReadableSource()).append(" class ").append(binding.bindingTypeElement().get().getQualifiedName());
                        break;
                    }
                    default: {
                        throw new AssertionError(binding);
                    }
                }
                message.append("\n");
            }
            this.report(graph).addError(message.toString(), graph.componentType(), graph.componentDescriptor().componentAnnotation());
        }

        private static /* synthetic */ boolean lambda$validateBuilders$7(Set extraSetters, ComponentDescriptor.BuilderRequirementMethod method) {
            return extraSetters.contains(method.requirement());
        }

        final class BindingGraphValidation
        extends ComponentTreeTraverser.BindingGraphTraverser {
            private final TypeVisitor<Void, MembersInjectionBinding> membersInjectionBindingValidator;

            BindingGraphValidation(ComponentTreeTraverser.ComponentTreePath componentPath, DependencyRequest entryPoint) {
                super(componentPath, entryPoint);
                this.membersInjectionBindingValidator = new SimpleTypeVisitor8<Void, MembersInjectionBinding>(){

                    @Override
                    protected Void defaultAction(TypeMirror e, MembersInjectionBinding p) {
                        ComponentValidation.this.report(BindingGraphValidation.this.currentGraph()).addError("Invalid members injection request.", p.membersInjectedType());
                        return null;
                    }

                    @Override
                    public Void visitDeclared(DeclaredType type, MembersInjectionBinding binding) {
                        for (TypeMirror typeMirror : type.getTypeArguments()) {
                            boolean declared = typeMirror.accept(new SimpleTypeVisitor8<Boolean, Void>(Boolean.valueOf(false)){

                                @Override
                                public Boolean visitArray(ArrayType t, Void p) {
                                    return t.getComponentType().accept(new SimpleTypeVisitor8<Boolean, Void>(Boolean.valueOf(false)){

                                        @Override
                                        public Boolean visitDeclared(DeclaredType t, Void p) {
                                            for (TypeMirror typeMirror : t.getTypeArguments()) {
                                                if (typeMirror.accept(this, null).booleanValue()) continue;
                                                return false;
                                            }
                                            return true;
                                        }

                                        @Override
                                        public Boolean visitArray(ArrayType t, Void p) {
                                            return t.getComponentType().accept(this, null);
                                        }

                                        @Override
                                        public Boolean visitPrimitive(PrimitiveType t, Void p) {
                                            return true;
                                        }
                                    }, null);
                                }

                                @Override
                                public Boolean visitDeclared(DeclaredType t, Void p) {
                                    return true;
                                }
                            }, null);
                            if (declared) continue;
                            BindingGraphValidation.this.reportErrorAtEntryPoint("Type parameters must be bounded for members injection. %s required by %s, via:\n%s", new Object[]{typeMirror.toString(), type.toString(), BindingGraphValidation.this.formatDependencyTrace()});
                            return null;
                        }
                        TypeElement element = MoreElements.asType(type.asElement());
                        if (!MoreTypes.asDeclared(element.asType()).getTypeArguments().isEmpty() && BindingGraphValidator.this.types.isSameType(BindingGraphValidator.this.types.erasure(element.asType()), type)) {
                            BindingGraphValidation.this.reportErrorAtEntryPoint("%s has type parameters, cannot members inject the raw type. via:\n%s", new Object[]{type.toString(), BindingGraphValidation.this.formatDependencyTrace()});
                        }
                        return null;
                    }
                };
            }

            private void reportErrorAtEntryPoint(String format, Object ... args) {
                this.reportErrorAtEntryPoint(this.currentGraph(), format, args);
            }

            private void reportErrorAtEntryPoint(BindingGraph graph, String format, Object ... args) {
                String message = args.length == 0 ? format : String.format(format, args);
                ComponentValidation.this.report(graph).addError(message, this.entryPointElement());
            }

            private String formatDependencyTrace() {
                return BindingGraphValidator.this.dependencyRequestFormatter.format(this.dependencyTrace());
            }

            @Override
            protected void visitDependencyRequest(DependencyRequest dependencyRequest) {
                if (this.atDependencyCycle()) {
                    this.reportDependencyCycle();
                }
                super.visitDependencyRequest(dependencyRequest);
            }

            @Override
            protected void visitResolvedBindings(ResolvedBindings resolvedBindings) {
                if (resolvedBindings.isEmpty()) {
                    this.reportMissingBinding();
                } else if (resolvedBindings.bindings().size() > 1) {
                    this.reportDuplicateBindings();
                }
                super.visitResolvedBindings(resolvedBindings);
            }

            @Override
            protected void visitContributionBinding(ContributionBinding binding, ComponentDescriptor owningComponent) {
                ComponentValidation.this.checkBindingScope(binding, owningComponent);
                if (!this.dependencyRequest().isNullable() && binding.nullableType().isPresent()) {
                    this.reportNullableBindingForNonNullableRequest(binding);
                }
                if (binding.bindingKind().equals((Object)ContributionBinding.Kind.INJECTION)) {
                    TypeMirror type = binding.key().type();
                    ValidationReport<TypeElement> report = BindingGraphValidator.this.injectValidator.validateType(MoreTypes.asTypeElement(type));
                    if (!report.isClean()) {
                        ComponentValidation.this.report(this.currentGraph()).addSubreport(report);
                    }
                }
                if (binding.bindingType().equals((Object)BindingType.PRODUCTION) && this.doesPathRequireProvisionOnly()) {
                    this.reportProviderMayNotDependOnProducer(binding);
                }
                if (BindingGraphValidator.this.compilerOptions.usesProducers()) {
                    Key productionImplementationExecutorKey = BindingGraphValidator.this.keyFactory.forProductionImplementationExecutor();
                    if (!binding.key().equals(productionImplementationExecutorKey)) {
                        Key productionExecutorKey = BindingGraphValidator.this.keyFactory.forProductionExecutor();
                        for (DependencyRequest request : binding.explicitDependencies()) {
                            if (!request.key().equals(productionExecutorKey) && !request.key().equals(productionImplementationExecutorKey)) continue;
                            this.reportDependsOnProductionExecutor();
                        }
                    }
                }
                if (binding.bindingKind().equals((Object)ContributionBinding.Kind.SYNTHETIC_MULTIBOUND_MAP)) {
                    this.validateMapKeys(binding, owningComponent);
                }
                super.visitContributionBinding(binding, owningComponent);
            }

            @Override
            protected void visitMembersInjectionBinding(MembersInjectionBinding binding, ComponentDescriptor owningComponent) {
                this.validateMembersInjectionBinding(binding);
                super.visitMembersInjectionBinding(binding, owningComponent);
            }

            private ImmutableSetMultimap<ComponentDescriptor, BindingDeclaration> reportableDeclarations() {
                ImmutableSetMultimap.Builder declarations = ImmutableSetMultimap.builder();
                ArrayDeque<ResolvedBindings> queue = new ArrayDeque<ResolvedBindings>();
                queue.add(this.resolvedBindings());
                while (!queue.isEmpty()) {
                    ResolvedBindings queued = (ResolvedBindings)queue.remove();
                    declarations.putAll((Object)queued.owningComponent(), queued.multibindingDeclarations()).putAll((Object)queued.owningComponent(), queued.subcomponentDeclarations()).putAll((Object)queued.owningComponent(), queued.optionalBindingDeclarations());
                    queued.allContributionBindings().asMap().forEach((owningComponent, bindings) -> {
                        BindingGraph owningGraph = this.componentTreePath().graphForComponent((ComponentDescriptor)owningComponent);
                        for (ContributionBinding binding : bindings) {
                            if (BindingGraphValidator.this.bindingDeclarationFormatter.canFormat(binding)) {
                                declarations.put(owningComponent, (Object)binding);
                                continue;
                            }
                            queue.addAll((Collection<ResolvedBindings>)owningGraph.resolvedDependencies(binding));
                        }
                    });
                }
                return declarations.build();
            }

            private void reportNullableBindingForNonNullableRequest(ContributionBinding binding) {
                FluentIterable dependentContributions = FluentIterable.from(this.dependentBindings()).filter(ContributionBinding.class);
                ComponentValidation.this.report(this.owningGraph((Iterable<ContributionBinding>)dependentContributions.append((Object[])new ContributionBinding[]{binding}))).addItem(ErrorMessages.nullableToNonNullable(TypeName.get((TypeMirror)this.dependencyRequest().key().type()).toString(), BindingGraphValidator.this.bindingDeclarationFormatter.format(binding)) + "\n at: " + this.formatDependencyTrace(), BindingGraphValidator.this.compilerOptions.nullableValidationKind(), this.entryPointElement());
            }

            private void validateMapKeys(ContributionBinding binding, ComponentDescriptor owningComponent) {
                Preconditions.checkArgument((boolean)binding.bindingKind().equals((Object)ContributionBinding.Kind.SYNTHETIC_MULTIBOUND_MAP), (String)"binding must be a synthetic multibound map: %s", (Object)binding);
                ImmutableSet multibindingContributions = this.componentTreePath().graphForComponent(owningComponent).resolvedDependencies(binding).stream().map(ResolvedBindings::contributionBinding).collect(Util.toImmutableSet());
                this.validateMapKeySet((Set<ContributionBinding>)multibindingContributions);
                this.validateMapKeyAnnotationTypes((Set<ContributionBinding>)multibindingContributions);
            }

            private void validateMapKeySet(Set<ContributionBinding> mapBindingContributions) {
                for (Collection mapBindingsForMapKey : ContributionBinding.indexMapBindingsByMapKey(mapBindingContributions).asMap().values()) {
                    if (mapBindingsForMapKey.size() <= 1) continue;
                    this.reportDuplicateMapKeys(mapBindingsForMapKey);
                }
            }

            private void validateMapKeyAnnotationTypes(Set<ContributionBinding> mapBindingContributions) {
                ImmutableSetMultimap<Equivalence.Wrapper<DeclaredType>, ContributionBinding> mapBindingsByAnnotationType = ContributionBinding.indexMapBindingsByAnnotationType(mapBindingContributions);
                if (mapBindingsByAnnotationType.keySet().size() > 1) {
                    this.reportInconsistentMapKeyAnnotations((Multimap<Equivalence.Wrapper<DeclaredType>, ContributionBinding>)mapBindingsByAnnotationType);
                }
            }

            private void validateMembersInjectionBinding(MembersInjectionBinding binding) {
                binding.key().type().accept(this.membersInjectionBindingValidator, binding);
            }

            private void reportProviderMayNotDependOnProducer(ContributionBinding productionBinding) {
                if (this.atEntryPoint()) {
                    this.reportErrorAtEntryPoint("%s is a provision entry-point, which cannot depend on a production.", this.formatCurrentDependencyRequestKey());
                } else {
                    this.reportErrorAtEntryPoint(this.owningGraph((Iterable<ContributionBinding>)this.provisionsDependingOnLatestRequest().append((Object[])new ContributionBinding[]{productionBinding})), "%s is a provision, which cannot depend on a production.", ((ContributionBinding)this.provisionsDependingOnLatestRequest().iterator().next()).key());
                }
            }

            private StringBuilder requiresErrorMessageBase() {
                Optional<MembersInjectionBinding> membersInjectionBinding;
                String requiresErrorMessageFormat;
                Key key = this.dependencyRequest().key();
                if (key.type().getKind().equals((Object)TypeKind.WILDCARD)) {
                    requiresErrorMessageFormat = "Dagger does not support injecting Provider<T>, Lazy<T> or Produced<T> when T is a wildcard type such as <%s>.";
                } else {
                    boolean requiresProvision = this.doesPathRequireProvisionOnly();
                    requiresErrorMessageFormat = !key.isValidImplicitProvisionKey(BindingGraphValidator.this.types) ? (requiresProvision ? "%s cannot be provided without an @Provides-annotated method." : "%s cannot be provided without an @Provides- or @Produces-annotated method.") : (requiresProvision ? "%s cannot be provided without an @Inject constructor or from an @Provides-annotated method." : "%s cannot be provided without an @Inject constructor or from an @Provides- or @Produces-annotated method.");
                }
                StringBuilder errorMessage = new StringBuilder(String.format(requiresErrorMessageFormat, this.formatCurrentDependencyRequestKey()));
                if (key.isValidMembersInjectionKey() && (membersInjectionBinding = BindingGraphValidator.this.injectBindingRegistry.getOrFindMembersInjectionBinding(key)).isPresent() && !membersInjectionBinding.get().injectionSites().isEmpty()) {
                    errorMessage.append(" ");
                    errorMessage.append("This type supports members injection but cannot be implicitly provided.");
                }
                return errorMessage.append('\n');
            }

            private void reportMissingBinding() {
                if (this.reportMissingReleasableReferenceManager()) {
                    return;
                }
                StringBuilder errorMessage = this.requiresErrorMessageBase().append(this.formatDependencyTrace());
                for (String suggestion : MissingBindingSuggestions.forKey(ComponentValidation.this.rootGraph, this.dependencyRequest().bindingKey())) {
                    errorMessage.append('\n').append(suggestion);
                }
                this.reportErrorAtEntryPoint(ComponentValidation.this.rootGraph, errorMessage.toString(), new Object[0]);
            }

            private boolean reportMissingReleasableReferenceManager() {
                Optional<Object> metadataType;
                Key key = this.dependencyRequest().key();
                if (!(key.qualifier().isPresent() && MoreTypes.isTypeOf(ForReleasableReferences.class, key.qualifier().get().getAnnotationType()) && MoreTypes.isType(key.type()))) {
                    return false;
                }
                if (MoreTypes.isTypeOf(ReleasableReferenceManager.class, key.type())) {
                    metadataType = Optional.empty();
                } else if (MoreTypes.isTypeOf(TypedReleasableReferenceManager.class, key.type())) {
                    List<? extends TypeMirror> typeArguments = MoreTypes.asDeclared(key.type()).getTypeArguments();
                    if (typeArguments.size() != 1 || !typeArguments.get(0).getKind().equals((Object)TypeKind.DECLARED)) {
                        return false;
                    }
                    metadataType = Optional.of(MoreTypes.asDeclared(typeArguments.get(0)));
                } else {
                    return false;
                }
                Scope scope = Scope.scope(MoreTypes.asTypeElement(MoreAnnotationMirrors.getTypeValue(key.qualifier().get(), "value")));
                String missingRequestKey = this.formatCurrentDependencyRequestKey();
                if (!ComponentValidation.this.rootGraph.componentDescriptor().releasableReferencesScopes().contains((Object)scope)) {
                    this.reportErrorAtEntryPoint(ComponentValidation.this.rootGraph, ErrorMessages.referenceReleasingScopeNotInComponentHierarchy(missingRequestKey, scope, ComponentValidation.this.rootGraph), new Object[0]);
                    return true;
                }
                if (metadataType.isPresent()) {
                    if (!DaggerElements.isAnnotationPresent(scope.scopeAnnotationElement(), (TypeMirror)metadataType.get())) {
                        this.reportErrorAtEntryPoint(ComponentValidation.this.rootGraph, ErrorMessages.referenceReleasingScopeNotAnnotatedWithMetadata(missingRequestKey, scope, (TypeMirror)metadataType.get()), new Object[0]);
                    }
                    if (!MoreElements.isAnnotationPresent(((DeclaredType)metadataType.get()).asElement(), CanReleaseReferences.class)) {
                        this.reportErrorAtEntryPoint(ComponentValidation.this.rootGraph, ErrorMessages.referenceReleasingScopeMetadataMissingCanReleaseReferences(missingRequestKey, (DeclaredType)metadataType.get()), new Object[0]);
                    }
                }
                return false;
            }

            private void reportDependsOnProductionExecutor() {
                this.reportErrorAtEntryPoint("%s may not depend on the production executor.", this.formatCurrentDependencyRequestKey());
            }

            private void reportDuplicateBindings() {
                if (this.resolvedBindings().contributionBindings().stream().map(ContributionBinding::bindingKind).anyMatch(kind -> ContributionBinding.Kind.SYNTHETIC_MULTIBOUND_KINDS.contains((Object)kind) || ContributionBinding.Kind.SYNTHETIC_MAP.equals(kind))) {
                    this.reportMultipleContributionTypes();
                    return;
                }
                StringBuilder builder = new StringBuilder();
                new Formatter(builder).format("%s is bound multiple times:", this.formatCurrentDependencyRequestKey());
                ImmutableSetMultimap<ComponentDescriptor, BindingDeclaration> duplicateDeclarations = this.reportableDeclarations();
                BindingGraphValidator.this.bindingDeclarationFormatter.formatIndentedList(builder, duplicateDeclarations.values(), 1, 10);
                this.reportErrorAtEntryPoint(this.componentTreePath().rootmostGraph((Iterable<ComponentDescriptor>)duplicateDeclarations.keySet()), builder.toString(), new Object[0]);
            }

            private void reportMultipleContributionTypes() {
                StringBuilder builder = new StringBuilder();
                new Formatter(builder).format("%s has incompatible bindings or declarations:\n", this.formatCurrentDependencyRequestKey());
                ImmutableSetMultimap<ComponentDescriptor, BindingDeclaration> duplicateDeclarations = this.reportableDeclarations();
                ImmutableListMultimap duplicateDeclarationsByType = Multimaps.index((Iterable)duplicateDeclarations.values(), declaration -> declaration instanceof ContributionType.HasContributionType ? ((ContributionType.HasContributionType)((Object)declaration)).contributionType() : ContributionType.UNIQUE);
                Verify.verify((duplicateDeclarationsByType.keySet().size() > 1 ? 1 : 0) != 0, (String)"expected multiple contribution types for %s: %s", (Object[])new Object[]{this.dependencyRequest().bindingKey(), duplicateDeclarationsByType});
                ImmutableSortedMap.copyOf((Map)Multimaps.asMap((ListMultimap)duplicateDeclarationsByType)).forEach((contributionType, declarations) -> {
                    builder.append("    ");
                    builder.append(BindingGraphValidator.this.formatContributionType(contributionType));
                    builder.append(" bindings and declarations:");
                    BindingGraphValidator.this.bindingDeclarationFormatter.formatIndentedList(builder, declarations, 2, 10);
                    builder.append('\n');
                });
                this.reportErrorAtEntryPoint(this.componentTreePath().rootmostGraph((Iterable<ComponentDescriptor>)duplicateDeclarations.keySet()), builder.toString(), new Object[0]);
            }

            private void reportDuplicateMapKeys(Collection<ContributionBinding> mapBindings) {
                StringBuilder builder = new StringBuilder();
                builder.append(ErrorMessages.duplicateMapKeysError(this.formatCurrentDependencyRequestKey()));
                BindingGraphValidator.this.bindingDeclarationFormatter.formatIndentedList(builder, mapBindings, 1, 10);
                this.reportErrorAtEntryPoint(this.owningGraph(mapBindings), builder.toString(), new Object[0]);
            }

            private void reportInconsistentMapKeyAnnotations(Multimap<Equivalence.Wrapper<DeclaredType>, ContributionBinding> mapBindingsByAnnotationType) {
                StringBuilder builder = new StringBuilder(ErrorMessages.inconsistentMapKeyAnnotationsError(this.formatCurrentDependencyRequestKey()));
                for (Map.Entry entry : mapBindingsByAnnotationType.asMap().entrySet()) {
                    DeclaredType annotationType = (DeclaredType)((Equivalence.Wrapper)entry.getKey()).get();
                    Collection bindings = (Collection)entry.getValue();
                    builder.append('\n').append("    ").append(annotationType).append(':');
                    BindingGraphValidator.this.bindingDeclarationFormatter.formatIndentedList(builder, bindings, 2, 10);
                }
                this.reportErrorAtEntryPoint(this.owningGraph(mapBindingsByAnnotationType.values()), builder.toString(), new Object[0]);
            }

            private void reportDependencyCycle() {
                if (!this.providersBreakingCycle().isEmpty()) {
                    return;
                }
                ImmutableList.Builder cycleBindings = ImmutableList.builder();
                this.cycleDependencyTrace().forEach((dependencyRequest, resolvedBindings) -> cycleBindings.addAll(resolvedBindings.contributionBindings()));
                this.reportErrorAtEntryPoint(this.owningGraph((Iterable<ContributionBinding>)cycleBindings.build()), "Found a dependency cycle:\n%s", this.formatDependencyTrace());
            }

            private ImmutableSet<DependencyRequest> providersBreakingCycle() {
                ImmutableSet.Builder providers = ImmutableSet.builder();
                AtomicBoolean first = new AtomicBoolean(true);
                this.cycleDependencyTrace().forEach((dependencyRequest, resolvedBindings) -> {
                    DependencyRequest.KindAndType kindAndType;
                    if (first.getAndSet(false) || !dependencyRequest.requestElement().isPresent()) {
                        return;
                    }
                    if (this.breaksCycle(dependencyRequest.key().type(), dependencyRequest.kind())) {
                        providers.add(dependencyRequest);
                    } else if (!resolvedBindings.optionalBindingDeclarations().isEmpty() && this.breaksCycle((kindAndType = DependencyRequest.extractKindAndType(OptionalType.from(dependencyRequest.key()).valueType())).type(), kindAndType.kind())) {
                        providers.add(dependencyRequest);
                    }
                });
                return providers.build();
            }

            private boolean breaksCycle(TypeMirror requestedType, DependencyRequest.Kind requestKind) {
                switch (requestKind) {
                    case PROVIDER: 
                    case LAZY: 
                    case PROVIDER_OF_LAZY: {
                        return true;
                    }
                    case INSTANCE: {
                        return MapType.isMap(requestedType) && MapType.from(requestedType).valuesAreTypeOf(Provider.class);
                    }
                }
                return false;
            }

            private boolean doesPathRequireProvisionOnly() {
                if (!this.atEntryPoint()) {
                    return !this.provisionsDependingOnLatestRequest().isEmpty();
                }
                switch (this.dependencyRequest().kind()) {
                    case PROVIDER: 
                    case LAZY: 
                    case INSTANCE: 
                    case MEMBERS_INJECTOR: {
                        return true;
                    }
                    case PRODUCER: 
                    case PRODUCED: 
                    case FUTURE: {
                        return false;
                    }
                }
                throw new AssertionError();
            }

            private FluentIterable<ContributionBinding> provisionsDependingOnLatestRequest() {
                return FluentIterable.from(this.dependentBindings()).filter(ContributionBinding.class).filter(BindingType.PROVISION::isOfType);
            }

            private String formatCurrentDependencyRequestKey() {
                return BindingGraphValidator.this.keyFormatter.format(this.dependencyRequest().key());
            }
        }
    }
}

