/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.AbstractComponentWriter;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.OptionalFactories;
import dagger.internal.codegen.TypeSpecs;
import dagger.internal.codegen.UniqueNameSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class ComponentWriter
extends AbstractComponentWriter {
    ComponentWriter(Types types, Elements elements, Key.Factory keyFactory, CompilerOptions compilerOptions, ClassName name, BindingGraph graph) {
        super(types, elements, keyFactory, compilerOptions, name, graph, (ImmutableMap<ComponentDescriptor, String>)new UniqueSubcomponentNamesGenerator(graph).generate(), new OptionalFactories());
    }

    @Override
    protected void decorateComponent() {
        this.component.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        TypeSpecs.addSupertype(this.component, this.graph.componentType());
    }

    @Override
    protected ClassName builderName() {
        return this.name.nestedClass("Builder");
    }

    @Override
    protected TypeSpec.Builder createBuilder(String builderSimpleName) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)builderSimpleName).addModifiers(new Modifier[]{Modifier.STATIC});
        MethodSpec builderFactoryMethod = MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)(this.graph.componentDescriptor().builderSpec().isPresent() ? ClassName.get((TypeElement)this.graph.componentDescriptor().builderSpec().get().builderDefinitionType()) : (TypeName)this.builderName.get())).addStatement("return new $T()", new Object[]{this.builderName.get()}).build();
        this.component.addMethod(builderFactoryMethod);
        return builder;
    }

    @Override
    protected void addBuilderClass(TypeSpec builder) {
        this.component.addType(builder);
    }

    @Override
    protected void addFactoryMethods() {
        if (this.canInstantiateAllRequirements()) {
            String buildMethodName = this.graph.componentDescriptor().builderSpec().isPresent() ? this.graph.componentDescriptor().builderSpec().get().buildMethod().getSimpleName() : "build";
            this.component.addMethod(MethodSpec.methodBuilder((String)"create").returns((TypeName)this.componentDefinitionTypeName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addStatement("return new Builder().$L()", new Object[]{buildMethodName}).build());
        }
    }

    private boolean canInstantiateAllRequirements() {
        return !Iterables.any(this.graph.componentRequirements(), dependency -> dependency.requiresAPassedInstance(this.elements, this.types));
    }

    private static class UniqueSubcomponentNamesGenerator {
        private static final Splitter QUALIFIED_NAME_SPLITTER = Splitter.on((char)'.');
        private static final Joiner QUALIFIED_NAME_JOINER = Joiner.on((char)'_');
        private final BindingGraph graph;
        private final ImmutableListMultimap<String, ComponentDescriptor> componentDescriptorsBySimpleName;
        private final ImmutableMap<ComponentDescriptor, Namer> componentNamers;

        private UniqueSubcomponentNamesGenerator(BindingGraph graph) {
            this.graph = graph;
            this.componentDescriptorsBySimpleName = Multimaps.index(graph.componentDescriptors(), componentDescriptor -> componentDescriptor.componentDefinitionType().getSimpleName().toString());
            this.componentNamers = UniqueSubcomponentNamesGenerator.qualifiedNames(graph.componentDescriptors());
        }

        private ImmutableBiMap<ComponentDescriptor, String> generate() {
            LinkedHashMap<ComponentDescriptor, String> subcomponentImplSimpleNames = new LinkedHashMap<ComponentDescriptor, String>();
            for (Map.Entry componentEntry : this.componentDescriptorsBySimpleName.asMap().entrySet()) {
                Collection components = (Collection)componentEntry.getValue();
                subcomponentImplSimpleNames.putAll((Map<ComponentDescriptor, String>)this.disambiguateConflictingSimpleNames(components));
            }
            subcomponentImplSimpleNames.remove(this.graph.componentDescriptor());
            return ImmutableBiMap.copyOf(subcomponentImplSimpleNames);
        }

        private ImmutableBiMap<ComponentDescriptor, String> disambiguateConflictingSimpleNames(Collection<ComponentDescriptor> components) {
            ComponentDescriptor component;
            Namer namer;
            LinkedHashMap<String, ComponentDescriptor> generatedSimpleNames = new LinkedHashMap<String, ComponentDescriptor>();
            Iterator<ComponentDescriptor> iterator = components.iterator();
            while (iterator.hasNext() && !generatedSimpleNames.containsKey((namer = (Namer)this.componentNamers.get((Object)(component = iterator.next()))).simpleName())) {
                generatedSimpleNames.put(namer.simpleName(), component);
            }
            if (generatedSimpleNames.size() != components.size()) {
                generatedSimpleNames.clear();
                UniqueNameSet nameSet = new UniqueNameSet();
                for (ComponentDescriptor component2 : components) {
                    Namer namer2 = (Namer)this.componentNamers.get((Object)component2);
                    String simpleName = namer2.simpleName();
                    String basePrefix = namer2.uniquingPrefix();
                    generatedSimpleNames.put(String.format("%s_%s", nameSet.getUniqueName(basePrefix), simpleName), component2);
                }
            }
            return ImmutableBiMap.copyOf(generatedSimpleNames).inverse();
        }

        private static ImmutableMap<ComponentDescriptor, Namer> qualifiedNames(Iterable<ComponentDescriptor> componentDescriptors) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (ComponentDescriptor component : componentDescriptors) {
                builder.put((Object)component, (Object)new Namer(component.componentDefinitionType()));
            }
            return builder.build();
        }

        private static final class Namer {
            final TypeElement typeElement;

            Namer(TypeElement typeElement) {
                this.typeElement = typeElement;
            }

            String simpleName() {
                return this.typeElement.getSimpleName().toString();
            }

            String uniquingPrefix() {
                String containerName = this.typeElement.getEnclosingElement().getSimpleName().toString();
                if (!containerName.isEmpty() && Character.isUpperCase(containerName.charAt(0))) {
                    return CharMatcher.javaLowerCase().removeFrom((CharSequence)containerName);
                }
                Name qualifiedName = this.typeElement.getQualifiedName();
                Iterator pieces = QUALIFIED_NAME_SPLITTER.split((CharSequence)qualifiedName).iterator();
                StringBuilder b = new StringBuilder();
                while (pieces.hasNext()) {
                    String next = (String)pieces.next();
                    if (!pieces.hasNext()) continue;
                    b.append(next.charAt(0));
                }
                return b.length() > 0 ? b.toString() : "$";
            }
        }
    }
}

