/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import dagger.internal.codegen.Util;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.Types;

final class DaggerElements {
    static final ElementVisitor<TypeElement, Void> ENCLOSING_TYPE_ELEMENT = new SimpleElementVisitor6<TypeElement, Void>(){

        @Override
        protected TypeElement defaultAction(Element e, Void p) {
            return (TypeElement)this.visit(e.getEnclosingElement());
        }

        @Override
        public TypeElement visitType(TypeElement e, Void p) {
            return e;
        }
    };

    DaggerElements() {
    }

    static ImmutableSet<ExecutableElement> getUnimplementedMethods(TypeElement type, Types types, Elements elements) {
        return FluentIterable.from(MoreElements.getLocalAndInheritedMethods(type, types, elements)).filter(MoreElements.hasModifiers(Modifier.ABSTRACT)).toSet();
    }

    static boolean isAnyAnnotationPresent(Element element, Iterable<? extends Class<? extends Annotation>> annotationClasses) {
        for (Class<? extends Annotation> clazz : annotationClasses) {
            if (!MoreElements.isAnnotationPresent(element, clazz)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    static boolean isAnyAnnotationPresent(Element element, Class<? extends Annotation> first, Class<? extends Annotation> ... otherAnnotations) {
        return DaggerElements.isAnyAnnotationPresent(element, Lists.asList(first, (Object[])otherAnnotations));
    }

    static boolean isAnnotationPresent(Element element, TypeMirror annotationType) {
        return element.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).anyMatch(candidate -> MoreTypes.equivalence().equivalent(candidate, (Object)annotationType));
    }

    @SafeVarargs
    static Optional<AnnotationMirror> getAnyAnnotation(Element element, Class<? extends Annotation> first, Class<? extends Annotation> ... rest) {
        return DaggerElements.getAnyAnnotation(element, Lists.asList(first, (Object[])rest));
    }

    static Optional<AnnotationMirror> getAnyAnnotation(Element element, Collection<? extends Class<? extends Annotation>> annotations) {
        return element.getAnnotationMirrors().stream().filter(DaggerElements.hasAnnotationTypeIn(annotations)).map(a -> a).findFirst();
    }

    @SafeVarargs
    static ImmutableSet<AnnotationMirror> getAllAnnotations(Element element, Class<? extends Annotation> first, Class<? extends Annotation> ... rest) {
        return element.getAnnotationMirrors().stream().filter(DaggerElements.hasAnnotationTypeIn(Lists.asList(first, (Object[])rest))).collect(Util.toImmutableSet());
    }

    static Optional<AnnotationMirror> getAnnotationMirror(Element element, Class<? extends Annotation> annotationClass) {
        return Optional.ofNullable((AnnotationMirror)MoreElements.getAnnotationMirror(element, annotationClass).orNull());
    }

    private static Predicate<AnnotationMirror> hasAnnotationTypeIn(Collection<? extends Class<? extends Annotation>> annotations) {
        Set annotationClassNames = annotations.stream().map(Class::getCanonicalName).collect(Collectors.toSet());
        return annotation -> annotationClassNames.contains(MoreTypes.asTypeElement(annotation.getAnnotationType()).getQualifiedName().toString());
    }

    static ImmutableSet<String> suppressedWarnings(Element element) {
        SuppressWarnings suppressedWarnings = element.getAnnotation(SuppressWarnings.class);
        if (suppressedWarnings == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf((Object[])suppressedWarnings.value());
    }

    static TypeElement checkTypePresent(String typeName, Elements elements) {
        TypeElement type = elements.getTypeElement(typeName);
        if (type == null) {
            throw new TypeNotPresentException(typeName, null);
        }
        return type;
    }
}

