/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.util.concurrent.Futures;
import com.squareup.javapoet.CodeBlock;
import dagger.internal.DoubleCheck;
import dagger.internal.ProviderOfLazy;
import dagger.internal.codegen.DependencyRequest;
import dagger.producers.Produced;
import dagger.producers.internal.Producers;

enum FrameworkType {
    PROVIDER{

        @Override
        CodeBlock to(DependencyRequest.Kind requestKind, CodeBlock from) {
            switch (requestKind) {
                case INSTANCE: {
                    return CodeBlock.of((String)"$L.get()", (Object[])new Object[]{from});
                }
                case LAZY: {
                    return CodeBlock.of((String)"$T.lazy($L)", (Object[])new Object[]{DoubleCheck.class, from});
                }
                case PROVIDER: {
                    return from;
                }
                case PROVIDER_OF_LAZY: {
                    return CodeBlock.of((String)"$T.create($L)", (Object[])new Object[]{ProviderOfLazy.class, from});
                }
                case PRODUCER: {
                    return CodeBlock.of((String)"$T.producerFromProvider($L)", (Object[])new Object[]{Producers.class, from});
                }
                case FUTURE: {
                    return CodeBlock.of((String)"$T.immediateFuture($L)", (Object[])new Object[]{Futures.class, this.to(DependencyRequest.Kind.INSTANCE, from)});
                }
                case PRODUCED: {
                    return CodeBlock.of((String)"$T.successful($L)", (Object[])new Object[]{Produced.class, this.to(DependencyRequest.Kind.INSTANCE, from)});
                }
            }
            throw new IllegalArgumentException(String.format("Cannot request a %s from a %s", new Object[]{requestKind, this}));
        }
    }
    ,
    PRODUCER{

        @Override
        CodeBlock to(DependencyRequest.Kind requestKind, CodeBlock from) {
            switch (requestKind) {
                case FUTURE: {
                    return CodeBlock.of((String)"$L.get()", (Object[])new Object[]{from});
                }
                case PRODUCER: {
                    return from;
                }
            }
            throw new IllegalArgumentException(String.format("Cannot request a %s from a %s", new Object[]{requestKind, this}));
        }
    }
    ,
    MEMBERS_INJECTOR{

        @Override
        CodeBlock to(DependencyRequest.Kind requestKind, CodeBlock from) {
            switch (requestKind) {
                case MEMBERS_INJECTOR: {
                    return from;
                }
            }
            throw new IllegalArgumentException(String.format("Cannot request a %s from a %s", new Object[]{requestKind, this}));
        }
    };


    abstract CodeBlock to(DependencyRequest.Kind var1, CodeBlock var2);

    public String toString() {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, super.toString());
    }
}

