/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.internal.codegen.BindingMethodValidator;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.Scope;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProducerModule;
import dagger.producers.Produces;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class ProducesMethodValidator
extends BindingMethodValidator {
    ProducesMethodValidator(Elements elements, Types types) {
        super(elements, types, Produces.class, ProducerModule.class, BindingMethodValidator.Abstractness.MUST_BE_CONCRETE, BindingMethodValidator.ExceptionSuperclass.EXCEPTION, BindingMethodValidator.AllowsMultibindings.ALLOWS_MULTIBINDINGS);
    }

    @Override
    protected void checkMethod(ValidationReport.Builder<ExecutableElement> builder) {
        super.checkMethod(builder);
        this.checkNullable(builder);
        this.checkScope(builder);
    }

    private void checkNullable(ValidationReport.Builder<ExecutableElement> builder) {
        if (ConfigurationAnnotations.getNullableType(builder.getSubject()).isPresent()) {
            builder.addWarning("@Nullable on @Produces methods does not do anything.");
        }
    }

    private void checkScope(ValidationReport.Builder<ExecutableElement> builder) {
        if (!Scope.scopesOf(builder.getSubject()).isEmpty()) {
            builder.addError("@Produces methods may not have scope annotations.");
        }
    }

    @Override
    protected String badReturnTypeMessage() {
        return this.formatErrorMessage("@Produces methods must return a primitive, an array, a type variable, or a declared type, or a ListenableFuture of one of those types.", new Object[0]);
    }

    @Override
    protected void checkKeyType(ValidationReport.Builder<ExecutableElement> reportBuilder, TypeMirror keyType) {
        Optional<TypeMirror> typeToCheck = ProducesMethodValidator.unwrapListenableFuture(reportBuilder, keyType);
        if (typeToCheck.isPresent()) {
            super.checkKeyType(reportBuilder, typeToCheck.get());
        }
    }

    @Override
    protected void checkSetValuesType(ValidationReport.Builder<ExecutableElement> builder) {
        Optional<TypeMirror> typeToCheck = ProducesMethodValidator.unwrapListenableFuture(builder, builder.getSubject().getReturnType());
        if (typeToCheck.isPresent()) {
            this.checkSetValuesType(builder, typeToCheck.get());
        }
    }

    @Override
    protected String badSetValuesTypeMessage() {
        return "@Produces methods of type set values must return a Set or ListenableFuture of Set";
    }

    private static Optional<TypeMirror> unwrapListenableFuture(ValidationReport.Builder<ExecutableElement> reportBuilder, TypeMirror type) {
        if (MoreTypes.isType(type) && MoreTypes.isTypeOf(ListenableFuture.class, type)) {
            DeclaredType declaredType = MoreTypes.asDeclared(type);
            if (declaredType.getTypeArguments().isEmpty()) {
                reportBuilder.addError("@Produces methods cannot return a raw ListenableFuture.");
                return Optional.empty();
            }
            return Optional.of((TypeMirror)Iterables.getOnlyElement(declaredType.getTypeArguments()));
        }
        return Optional.of(type);
    }
}

