/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import dagger.Component;
import dagger.Subcomponent;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.BindingGraphConverter;
import dagger.internal.codegen.BindingGraphFactory;
import dagger.internal.codegen.BindingGraphValidator;
import dagger.internal.codegen.BuilderValidator;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentGenerator;
import dagger.internal.codegen.ComponentHierarchyValidator;
import dagger.internal.codegen.ComponentValidator;
import dagger.internal.codegen.SpiDiagnosticReporter;
import dagger.internal.codegen.ValidationReport;
import dagger.producers.ProductionComponent;
import dagger.producers.ProductionSubcomponent;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.ValidationItem;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

final class ComponentProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Messager messager;
    private final ComponentValidator componentValidator;
    private final BuilderValidator builderValidator;
    private final ComponentHierarchyValidator componentHierarchyValidator;
    private final BindingGraphValidator bindingGraphValidator;
    private final ComponentDescriptor.Factory componentDescriptorFactory;
    private final BindingGraphFactory bindingGraphFactory;
    private final ComponentGenerator componentGenerator;
    private final ImmutableList<BindingGraphPlugin> bindingGraphPlugins;
    private final SpiDiagnosticReporter spiDiagnosticReporter;

    @Inject
    ComponentProcessingStep(Messager messager, ComponentValidator componentValidator, BuilderValidator builderValidator, ComponentHierarchyValidator componentHierarchyValidator, BindingGraphValidator bindingGraphValidator, ComponentDescriptor.Factory componentDescriptorFactory, BindingGraphFactory bindingGraphFactory, ComponentGenerator componentGenerator, ImmutableList<BindingGraphPlugin> bindingGraphPlugins, SpiDiagnosticReporter spiDiagnosticReporter) {
        this.messager = messager;
        this.componentValidator = componentValidator;
        this.builderValidator = builderValidator;
        this.componentHierarchyValidator = componentHierarchyValidator;
        this.bindingGraphValidator = bindingGraphValidator;
        this.componentDescriptorFactory = componentDescriptorFactory;
        this.bindingGraphFactory = bindingGraphFactory;
        this.componentGenerator = componentGenerator;
        this.bindingGraphPlugins = bindingGraphPlugins;
        this.spiDiagnosticReporter = spiDiagnosticReporter;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(Component.class, Component.Builder.class, ProductionComponent.class, ProductionComponent.Builder.class, Subcomponent.class, Subcomponent.Builder.class, (Object[])new Class[]{ProductionSubcomponent.class, ProductionSubcomponent.Builder.class});
    }

    public ImmutableSet<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        ImmutableSet.Builder rejectedElements = ImmutableSet.builder();
        ImmutableSet<Element> componentElements = ComponentProcessingStep.getElementsFromAnnotations(elementsByAnnotation, Component.class, ProductionComponent.class);
        ImmutableSet<Element> componentBuilderElements = ComponentProcessingStep.getElementsFromAnnotations(elementsByAnnotation, Component.Builder.class, ProductionComponent.Builder.class);
        ImmutableSet<Element> subcomponentElements = ComponentProcessingStep.getElementsFromAnnotations(elementsByAnnotation, Subcomponent.class, ProductionSubcomponent.class);
        ImmutableSet<Element> subcomponentBuilderElements = ComponentProcessingStep.getElementsFromAnnotations(elementsByAnnotation, Subcomponent.Builder.class, ProductionSubcomponent.Builder.class);
        Map<Element, ValidationReport<TypeElement>> builderReportsByComponent = this.processBuilders((Set<? extends Element>)componentBuilderElements);
        Map<Element, ValidationReport<TypeElement>> builderReportsBySubcomponent = this.processBuilders((Set<? extends Element>)subcomponentBuilderElements);
        Map<Element, ValidationReport<TypeElement>> reportsBySubcomponent = this.processSubcomponents((Set<? extends Element>)subcomponentElements, (Set<? extends Element>)subcomponentBuilderElements);
        for (TypeElement componentTypeElement : ElementFilter.typesIn(componentElements)) {
            try {
                Collection<ValidationItem> items;
                ComponentValidator.ComponentValidationReport validationReport = this.componentValidator.validate(componentTypeElement, (Set<? extends Element>)subcomponentElements, (Set<? extends Element>)subcomponentBuilderElements);
                validationReport.report().printMessagesTo(this.messager);
                if (!this.isClean(validationReport, builderReportsByComponent, reportsBySubcomponent, builderReportsBySubcomponent)) continue;
                ComponentDescriptor componentDescriptor = this.componentDescriptorFactory.forComponent(componentTypeElement);
                ValidationReport<TypeElement> hierarchyReport = this.componentHierarchyValidator.validate(componentDescriptor);
                hierarchyReport.printMessagesTo(this.messager);
                if (!hierarchyReport.isClean()) continue;
                BindingGraph bindingGraph = this.bindingGraphFactory.create(componentDescriptor);
                ValidationReport<TypeElement> graphReport = this.bindingGraphValidator.validate(bindingGraph);
                graphReport.printMessagesTo(this.messager);
                if (!graphReport.isClean() || !this.bindingGraphPlugins.isEmpty() && (items = this.executePlugins(BindingGraphConverter.convert(bindingGraph))).stream().anyMatch(item -> item.diagnosticKind().equals((Object)Diagnostic.Kind.ERROR))) continue;
                this.generateComponent(bindingGraph);
            }
            catch (TypeNotPresentException e) {
                rejectedElements.add((Object)componentTypeElement);
            }
        }
        return rejectedElements.build();
    }

    private Collection<ValidationItem> executePlugins(dagger.model.BindingGraph graph) {
        ListMultimap items = MultimapBuilder.linkedHashKeys().arrayListValues().build();
        for (BindingGraphPlugin plugin : this.bindingGraphPlugins) {
            items.putAll((Object)plugin.pluginName(), (Iterable)plugin.visitGraph(graph));
        }
        if (!items.isEmpty()) {
            this.spiDiagnosticReporter.report(graph, (ImmutableListMultimap<String, ValidationItem>)ImmutableListMultimap.copyOf((Multimap)items));
        }
        return items.values();
    }

    private void generateComponent(BindingGraph bindingGraph) {
        this.componentGenerator.generate(bindingGraph, this.messager);
    }

    static ImmutableSet<Element> getElementsFromAnnotations(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation, Class<? extends Annotation> ... annotations) {
        return ImmutableSet.copyOf((Collection)Multimaps.filterKeys(elementsByAnnotation, (Predicate)Predicates.in((Collection)ImmutableSet.copyOf((Object[])annotations))).values());
    }

    private Map<Element, ValidationReport<TypeElement>> processBuilders(Set<? extends Element> builderElements) {
        HashMap builderReportsByComponent = Maps.newHashMap();
        for (Element element : builderElements) {
            ValidationReport<TypeElement> report = this.builderValidator.validate(MoreElements.asType(element));
            report.printMessagesTo(this.messager);
            builderReportsByComponent.put(element.getEnclosingElement(), report);
        }
        return builderReportsByComponent;
    }

    private Map<Element, ValidationReport<TypeElement>> processSubcomponents(Set<? extends Element> subcomponentElements, Set<? extends Element> subcomponentBuilderElements) {
        HashMap reportsBySubcomponent = Maps.newHashMap();
        for (Element element : subcomponentElements) {
            ComponentValidator.ComponentValidationReport report = this.componentValidator.validate(MoreElements.asType(element), subcomponentElements, subcomponentBuilderElements);
            report.report().printMessagesTo(this.messager);
            reportsBySubcomponent.put(element, report.report());
        }
        return reportsBySubcomponent;
    }

    private boolean isClean(ComponentValidator.ComponentValidationReport report, Map<Element, ValidationReport<TypeElement>> builderReportsByComponent, Map<Element, ValidationReport<TypeElement>> reportsBySubcomponent, Map<Element, ValidationReport<TypeElement>> builderReportsBySubcomponent) {
        TypeElement component = report.report().subject();
        ValidationReport<TypeElement> componentReport = report.report();
        if (!componentReport.isClean()) {
            return false;
        }
        ValidationReport<TypeElement> builderReport = builderReportsByComponent.get(component);
        if (builderReport != null && !builderReport.isClean()) {
            return false;
        }
        for (Element element : report.referencedSubcomponents()) {
            ValidationReport<TypeElement> subcomponentBuilderReport = builderReportsBySubcomponent.get(element);
            if (subcomponentBuilderReport != null && !subcomponentBuilderReport.isClean()) {
                return false;
            }
            ValidationReport<TypeElement> subcomponentReport = reportsBySubcomponent.get(element);
            if (subcomponentReport == null || subcomponentReport.isClean()) continue;
            return false;
        }
        return true;
    }
}

