/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.AnnotationSpecs;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentBindingExpressions;
import dagger.internal.codegen.ComponentBuilder;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentRequirementFields;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.DaggerTypes;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.MethodSignature;
import dagger.internal.codegen.OptionalFactories;
import dagger.internal.codegen.SubcomponentNames;
import dagger.internal.codegen.UniqueNameSet;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

abstract class ComponentWriter {
    private final Elements elements;
    private final DaggerTypes types;
    private final BindingGraph graph;
    private final SubcomponentNames subcomponentNames;
    private final ComponentBindingExpressions bindingExpressions;
    private final ComponentRequirementFields componentRequirementFields;
    private final GeneratedComponentModel generatedComponentModel;
    private final OptionalFactories optionalFactories;
    private final Optional<ComponentBuilder> builder;
    private boolean done;
    private static final int INITIALIZATIONS_PER_INITIALIZE_METHOD = 100;

    static TypeSpec.Builder writeComponent(DaggerTypes types, DaggerElements elements, KeyFactory keyFactory, CompilerOptions compilerOptions, ClassName name, BindingGraph graph) {
        GeneratedComponentModel generatedComponentModel = GeneratedComponentModel.forComponent(name);
        SubcomponentNames subcomponentNames = new SubcomponentNames(graph, keyFactory);
        OptionalFactories optionalFactories = new OptionalFactories();
        Optional<ComponentBuilder> builder = ComponentBuilder.create(name, graph, subcomponentNames, elements, types);
        ComponentRequirementFields componentRequirementFields = new ComponentRequirementFields(graph, generatedComponentModel, builder);
        ComponentBindingExpressions bindingExpressions = new ComponentBindingExpressions(graph, generatedComponentModel, subcomponentNames, componentRequirementFields, optionalFactories, types, elements, compilerOptions);
        return new RootComponentWriter(types, elements, graph, generatedComponentModel, subcomponentNames, optionalFactories, bindingExpressions, componentRequirementFields, builder).write();
    }

    private static TypeSpec writeSubcomponent(ComponentWriter parent, BindingGraph childGraph) {
        ClassName parentName = parent.generatedComponentModel.name();
        ClassName childName = parentName.nestedClass(parent.subcomponentNames.get(childGraph.componentDescriptor()) + "Impl");
        GeneratedComponentModel childGeneratedComponentModel = GeneratedComponentModel.forSubcomponent(childName);
        Optional<ComponentBuilder> childBuilder = ComponentBuilder.create(childName, childGraph, parent.subcomponentNames, parent.elements, parent.types);
        ComponentRequirementFields childComponentRequirementFields = parent.componentRequirementFields.forChildComponent(childGraph, childGeneratedComponentModel, childBuilder);
        ComponentBindingExpressions childBindingExpressions = parent.bindingExpressions.forChildComponent(childGraph, childGeneratedComponentModel, childComponentRequirementFields);
        return new SubcomponentWriter(parent, childGraph, childGeneratedComponentModel, childBindingExpressions, childComponentRequirementFields, childBuilder).write().build();
    }

    private ComponentWriter(DaggerTypes types, Elements elements, BindingGraph graph, GeneratedComponentModel generatedComponentModel, SubcomponentNames subcomponentNames, OptionalFactories optionalFactories, ComponentBindingExpressions bindingExpressions, ComponentRequirementFields componentRequirementFields, Optional<ComponentBuilder> builder) {
        this.types = types;
        this.elements = elements;
        this.graph = graph;
        this.subcomponentNames = subcomponentNames;
        this.generatedComponentModel = generatedComponentModel;
        this.optionalFactories = optionalFactories;
        this.bindingExpressions = bindingExpressions;
        this.componentRequirementFields = componentRequirementFields;
        this.builder = builder;
    }

    protected final TypeSpec.Builder write() {
        Preconditions.checkState((!this.done ? 1 : 0) != 0, (Object)"ComponentWriter has already been generated.");
        this.generatedComponentModel.addSupertype(this.graph.componentType());
        this.builder.map(ComponentBuilder::typeSpec).ifPresent(this::addBuilderClass);
        MoreElements.getLocalAndInheritedMethods(this.graph.componentDescriptor().componentDefinitionType(), this.types, this.elements).forEach(method -> this.generatedComponentModel.claimMethodName(method.getSimpleName()));
        this.addFactoryMethods();
        this.addInterfaceMethods();
        this.addSubcomponents();
        this.addConstructor();
        if (this.graph.componentDescriptor().kind().isTopLevel()) {
            this.optionalFactories.addMembers(this.generatedComponentModel);
        }
        this.done = true;
        return this.generatedComponentModel.generate();
    }

    protected abstract void addBuilderClass(TypeSpec var1);

    protected abstract void addFactoryMethods();

    private void addInterfaceMethods() {
        ImmutableListMultimap componentMethodsBySignature = Multimaps.index(this.graph.componentDescriptor().entryPointMethods(), this::getMethodSignature);
        for (List methodsWithSameSignature : Multimaps.asMap((ListMultimap)componentMethodsBySignature).values()) {
            ComponentDescriptor.ComponentMethodDescriptor anyOneMethod = (ComponentDescriptor.ComponentMethodDescriptor)methodsWithSameSignature.stream().findAny().get();
            this.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.COMPONENT_METHOD, this.bindingExpressions.getComponentMethod(anyOneMethod));
        }
    }

    private MethodSignature getMethodSignature(ComponentDescriptor.ComponentMethodDescriptor method) {
        return MethodSignature.forComponentMethod(method, MoreTypes.asDeclared(this.graph.componentType().asType()), this.types);
    }

    private void addSubcomponents() {
        for (BindingGraph subgraph : this.graph.subgraphs()) {
            this.generatedComponentModel.addType(GeneratedComponentModel.TypeSpecKind.SUBCOMPONENT, ComponentWriter.writeSubcomponent(this, subgraph));
        }
    }

    private void addConstructor() {
        List partitions = Lists.partition(this.generatedComponentModel.getInitializations(), (int)100);
        ImmutableList<ParameterSpec> constructorParameters = this.constructorParameters();
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameters(constructorParameters);
        ImmutableList<ParameterSpec> initializeParameters = this.initializeParameters();
        CodeBlock initializeParametersCodeBlock = constructorParameters.stream().map(param -> CodeBlock.of((String)"$N", (Object[])new Object[]{param})).collect(CodeBlocks.toParametersCodeBlock());
        UniqueNameSet methodNames = new UniqueNameSet();
        for (List partition : partitions) {
            String methodName = methodNames.getUniqueName("initialize");
            MethodSpec.Builder initializeMethod = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE}).addAnnotation(AnnotationSpecs.suppressWarnings(AnnotationSpecs.Suppression.UNCHECKED, new AnnotationSpecs.Suppression[0])).addCode(CodeBlocks.concat(partition));
            initializeMethod.addParameters(initializeParameters);
            constructor.addStatement("$L($L)", new Object[]{methodName, initializeParametersCodeBlock});
            this.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.INITIALIZE_METHOD, initializeMethod.build());
        }
        this.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.CONSTRUCTOR, constructor.build());
    }

    private ImmutableList<ParameterSpec> initializeParameters() {
        return this.constructorParameters().stream().map(param -> param.toBuilder().addModifiers(new Modifier[]{Modifier.FINAL}).build()).collect(DaggerStreams.toImmutableList());
    }

    private ImmutableList<ParameterSpec> constructorParameters() {
        if (this.builder.isPresent()) {
            return ImmutableList.of((Object)ParameterSpec.builder((TypeName)this.builder.get().name(), (String)"builder", (Modifier[])new Modifier[0]).build());
        }
        if (this.graph.factoryMethod().isPresent()) {
            return ComponentWriter.getFactoryMethodParameterSpecs(this.graph);
        }
        throw new AssertionError((Object)"Expected either a component builder or factory method but found neither.");
    }

    private static ImmutableList<ParameterSpec> getFactoryMethodParameterSpecs(BindingGraph graph) {
        return graph.factoryMethodParameters().values().stream().map(ParameterSpec::get).collect(DaggerStreams.toImmutableList());
    }

    private static final class SubcomponentWriter
    extends ComponentWriter {
        private final ComponentWriter parent;

        SubcomponentWriter(ComponentWriter parent, BindingGraph graph, GeneratedComponentModel generatedComponentModel, ComponentBindingExpressions bindingExpressions, ComponentRequirementFields componentRequirementFields, Optional<ComponentBuilder> builder) {
            super(parent.types, parent.elements, graph, generatedComponentModel, parent.subcomponentNames, parent.optionalFactories, bindingExpressions, componentRequirementFields, builder);
            this.parent = parent;
        }

        @Override
        protected void addBuilderClass(TypeSpec builder) {
            this.parent.generatedComponentModel.addType(GeneratedComponentModel.TypeSpecKind.SUBCOMPONENT, builder);
        }

        @Override
        protected void addFactoryMethods() {
            ((ComponentWriter)this).graph.factoryMethod().ifPresent(this::createSubcomponentFactoryMethod);
        }

        private void createSubcomponentFactoryMethod(ExecutableElement factoryMethod) {
            this.parent.generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.COMPONENT_METHOD, MethodSpec.overriding((ExecutableElement)factoryMethod, (DeclaredType)this.parentType(), (Types)((ComponentWriter)this).types).addStatement("return new $T($L)", new Object[]{((ComponentWriter)this).generatedComponentModel.name(), ComponentWriter.getFactoryMethodParameterSpecs(((ComponentWriter)this).graph).stream().map(param -> CodeBlock.of((String)"$N", (Object[])new Object[]{param})).collect(CodeBlocks.toParametersCodeBlock())}).build());
        }

        private DeclaredType parentType() {
            return MoreTypes.asDeclared(this.parent.graph.componentType().asType());
        }
    }

    private static final class RootComponentWriter
    extends ComponentWriter {
        RootComponentWriter(DaggerTypes types, Elements elements, BindingGraph graph, GeneratedComponentModel generatedComponentModel, SubcomponentNames subcomponentNames, OptionalFactories optionalFactories, ComponentBindingExpressions bindingExpressions, ComponentRequirementFields componentRequirementFields, Optional<ComponentBuilder> builder) {
            super(types, elements, graph, generatedComponentModel, subcomponentNames, optionalFactories, bindingExpressions, componentRequirementFields, builder);
        }

        @Override
        protected void addBuilderClass(TypeSpec builder) {
            ((ComponentWriter)this).generatedComponentModel.addType(GeneratedComponentModel.TypeSpecKind.COMPONENT_BUILDER, builder);
        }

        @Override
        protected void addFactoryMethods() {
            MethodSpec builderFactoryMethod = MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)(this.builderSpec().isPresent() ? ClassName.get((TypeElement)this.builderSpec().get().builderDefinitionType()) : ((ComponentBuilder)((ComponentWriter)this).builder.get()).name())).addStatement("return new $T()", new Object[]{((ComponentBuilder)((ComponentWriter)this).builder.get()).name()}).build();
            ((ComponentWriter)this).generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.BUILDER_METHOD, builderFactoryMethod);
            if (this.canInstantiateAllRequirements()) {
                String buildMethodName = this.builderSpec().isPresent() ? this.builderSpec().get().buildMethod().getSimpleName() : "build";
                ((ComponentWriter)this).generatedComponentModel.addMethod(GeneratedComponentModel.MethodSpecKind.BUILDER_METHOD, MethodSpec.methodBuilder((String)"create").returns((TypeName)ClassName.get((TypeElement)((ComponentWriter)this).graph.componentType())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addStatement("return new Builder().$L()", new Object[]{buildMethodName}).build());
            }
        }

        private Optional<ComponentDescriptor.BuilderSpec> builderSpec() {
            return ((ComponentWriter)this).graph.componentDescriptor().builderSpec();
        }

        private boolean canInstantiateAllRequirements() {
            return !Iterables.any(((ComponentWriter)this).graph.componentRequirements(), dependency -> dependency.requiresAPassedInstance(((ComponentWriter)this).elements, ((ComponentWriter)this).types));
        }
    }
}

