/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import dagger.internal.codegen.Binding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MapType;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.SetType;
import dagger.model.BindingKind;
import dagger.model.DependencyRequest;
import dagger.model.Key;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

abstract class ContributionBinding
extends Binding
implements ContributionType.HasContributionType {
    ContributionBinding() {
    }

    abstract Optional<DeclaredType> nullableType();

    abstract Optional<Equivalence.Wrapper<AnnotationMirror>> wrappedMapKey();

    final Optional<AnnotationMirror> mapKey() {
        return MoreAnnotationMirrors.unwrapOptionalEquivalence(this.wrappedMapKey());
    }

    boolean requiresModuleInstance() {
        if (!this.bindingElement().isPresent() || !this.contributingModule().isPresent()) {
            return false;
        }
        Set<Modifier> modifiers = this.bindingElement().get().getModifiers();
        return !modifiers.contains((Object)Modifier.ABSTRACT) && !modifiers.contains((Object)Modifier.STATIC);
    }

    Optional<TypeMirror> contributedPrimitiveType() {
        return this.bindingElement().filter(bindingElement -> bindingElement instanceof ExecutableElement).map(bindingElement -> MoreElements.asExecutable(bindingElement).getReturnType()).filter(type -> type.getKind().isPrimitive());
    }

    public final boolean isNullable() {
        return this.nullableType().isPresent();
    }

    FactoryCreationStrategy factoryCreationStrategy() {
        switch (this.kind()) {
            case DELEGATE: {
                return FactoryCreationStrategy.DELEGATE;
            }
            case PROVISION: {
                return this.dependencies().isEmpty() && !this.requiresModuleInstance() ? FactoryCreationStrategy.SINGLETON_INSTANCE : FactoryCreationStrategy.CLASS_CONSTRUCTOR;
            }
            case INJECTION: 
            case MULTIBOUND_SET: 
            case MULTIBOUND_MAP: {
                return this.dependencies().isEmpty() ? FactoryCreationStrategy.SINGLETON_INSTANCE : FactoryCreationStrategy.CLASS_CONSTRUCTOR;
            }
        }
        return FactoryCreationStrategy.CLASS_CONSTRUCTOR;
    }

    final TypeMirror contributedType() {
        switch (this.contributionType()) {
            case MAP: {
                return MapType.from(this.key()).unwrappedValueType(this.bindingType().frameworkClass());
            }
            case SET: {
                return SetType.from(this.key()).elementType();
            }
            case SET_VALUES: 
            case UNIQUE: {
                return this.key().type();
            }
        }
        throw new AssertionError();
    }

    final boolean isSyntheticMultibinding() {
        switch (this.kind()) {
            case MULTIBOUND_SET: 
            case MULTIBOUND_MAP: {
                return true;
            }
        }
        return false;
    }

    static BindingKind bindingKindForMultibindingKey(Key key) {
        if (SetType.isSet(key)) {
            return BindingKind.MULTIBOUND_SET;
        }
        if (MapType.isMap(key)) {
            return BindingKind.MULTIBOUND_MAP;
        }
        throw new IllegalArgumentException(String.format("key is not for a set or map: %s", key));
    }

    static ImmutableSetMultimap<Object, ContributionBinding> indexMapBindingsByMapKey(Set<ContributionBinding> mapBindings) {
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(mapBindings, mapBinding -> {
            AnnotationMirror mapKey = mapBinding.mapKey().get();
            return MapKeys.unwrapValue(mapKey).map(AnnotationValue::getValue).orElse(mapKey);
        }));
    }

    static ImmutableSetMultimap<Equivalence.Wrapper<DeclaredType>, ContributionBinding> indexMapBindingsByAnnotationType(Set<ContributionBinding> mapBindings) {
        return ImmutableSetMultimap.copyOf((Multimap)Multimaps.index(mapBindings, mapBinding -> MoreTypes.equivalence().wrap((Object)mapBinding.mapKey().get().getAnnotationType())));
    }

    @CanIgnoreReturnValue
    static abstract class Builder<C extends ContributionBinding, B extends Builder<C, B>> {
        Builder() {
        }

        abstract B dependencies(Iterable<DependencyRequest> var1);

        B dependencies(DependencyRequest ... dependencies) {
            return this.dependencies(Arrays.asList(dependencies));
        }

        abstract B unresolved(C var1);

        abstract B contributionType(ContributionType var1);

        abstract B bindingElement(Element var1);

        abstract B contributingModule(TypeElement var1);

        abstract B key(Key var1);

        abstract B nullableType(Optional<DeclaredType> var1);

        abstract B wrappedMapKey(Optional<Equivalence.Wrapper<AnnotationMirror>> var1);

        abstract B kind(BindingKind var1);

        @CheckReturnValue
        abstract C build();
    }

    static enum FactoryCreationStrategy {
        SINGLETON_INSTANCE,
        CLASS_CONSTRUCTOR,
        DELEGATE;

    }
}

