/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentProvisionBindingExpression;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentRequirementFields;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.FrameworkFieldInitializer;
import dagger.internal.codegen.GeneratedComponentModel;
import dagger.internal.codegen.ProvisionBinding;
import dagger.internal.codegen.TypeNames;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class DependencyMethodProviderCreationExpression
implements FrameworkFieldInitializer.FrameworkInstanceCreationExpression {
    private final GeneratedComponentModel generatedComponentModel;
    private final ComponentRequirementFields componentRequirementFields;
    private final CompilerOptions compilerOptions;
    private final BindingGraph graph;
    private final ContributionBinding binding;

    DependencyMethodProviderCreationExpression(ContributionBinding binding, GeneratedComponentModel generatedComponentModel, ComponentRequirementFields componentRequirementFields, CompilerOptions compilerOptions, BindingGraph graph) {
        this.binding = (ContributionBinding)Preconditions.checkNotNull((Object)binding);
        this.generatedComponentModel = (GeneratedComponentModel)Preconditions.checkNotNull((Object)generatedComponentModel);
        this.componentRequirementFields = (ComponentRequirementFields)Preconditions.checkNotNull((Object)componentRequirementFields);
        this.compilerOptions = (CompilerOptions)Preconditions.checkNotNull((Object)compilerOptions);
        this.graph = (BindingGraph)Preconditions.checkNotNull((Object)graph);
    }

    @Override
    public CodeBlock creationExpression() {
        CodeBlock invocation = ComponentProvisionBindingExpression.maybeCheckForNull((ProvisionBinding)this.binding, this.compilerOptions, CodeBlock.of((String)"$N.$N()", (Object[])new Object[]{this.dependency().variableName(), this.provisionMethod().getSimpleName()}));
        ClassName dependencyClassName = ClassName.get((TypeElement)this.dependency().typeElement());
        TypeName keyType = TypeName.get((TypeMirror)this.binding.key().type());
        MethodSpec.Builder getMethod = MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(keyType).addStatement("return $L", new Object[]{invocation});
        if (this.binding.nullableType().isPresent()) {
            getMethod.addAnnotation(ClassName.get((TypeElement)MoreTypes.asTypeElement(this.binding.nullableType().get())));
        }
        this.generatedComponentModel.addType(GeneratedComponentModel.TypeSpecKind.COMPONENT_PROVISION_FACTORY, TypeSpec.classBuilder((ClassName)this.factoryClassName()).addSuperinterface((TypeName)TypeNames.providerOf(keyType)).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addField((TypeName)dependencyClassName, this.dependency().variableName(), new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addParameter((TypeName)dependencyClassName, this.dependency().variableName(), new Modifier[0]).addStatement("this.$1L = $1L", new Object[]{this.dependency().variableName()}).build()).addMethod(getMethod.build()).build());
        return CodeBlock.of((String)"new $T($L)", (Object[])new Object[]{this.factoryClassName(), this.componentRequirementFields.getExpressionDuringInitialization(this.dependency(), this.generatedComponentModel.name())});
    }

    @Override
    public boolean isSimpleFactory() {
        return true;
    }

    private ClassName factoryClassName() {
        String factoryName = ClassName.get((TypeElement)this.dependency().typeElement()).toString().replace('.', '_') + "_" + this.binding.bindingElement().get().getSimpleName();
        return this.generatedComponentModel.name().nestedClass(factoryName);
    }

    private ComponentRequirement dependency() {
        return (ComponentRequirement)this.graph.componentDescriptor().dependenciesByDependencyMethod().get((Object)this.provisionMethod());
    }

    private Element provisionMethod() {
        return this.binding.bindingElement().get();
    }

    @Override
    public Optional<TypeName> specificType() {
        return Optional.of(this.factoryClassName());
    }
}

