/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Joiner;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.DiagnosticFormatting;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.internal.codegen.Scopes;
import dagger.releasablereferences.CanReleaseReferences;
import dagger.releasablereferences.ForReleasableReferences;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Scope;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

final class ErrorMessages {
    static final String INDENT = "    ";
    static final String DOUBLE_INDENT = "        ";
    static final int DUPLICATE_SIZE_LIMIT = 10;
    static final String MULTIPLE_INJECT_CONSTRUCTORS = "Types may only contain one @Inject constructor.";
    static final String FINAL_INJECT_FIELD = "@Inject fields may not be final";
    static final String ABSTRACT_INJECT_METHOD = "Methods with @Inject may not be abstract.";
    static final String GENERIC_INJECT_METHOD = "Methods with @Inject may not declare type parameters.";
    static final String MULTIPLE_QUALIFIERS = "A single injection site may not use more than one @Qualifier.";
    static final String MULTIPLE_SCOPES = "A single binding may not declare more than one @Scope.";
    static final String INJECT_ON_PRIVATE_CONSTRUCTOR = "Dagger does not support injection into private constructors";
    static final String INJECT_CONSTRUCTOR_ON_INNER_CLASS = "@Inject constructors are invalid on inner classes";
    static final String INJECT_CONSTRUCTOR_ON_ABSTRACT_CLASS = "@Inject is nonsense on the constructor of an abstract class";
    static final String QUALIFIER_ON_INJECT_CONSTRUCTOR = "@Qualifier annotations are not allowed on @Inject constructors.";
    static final String SCOPE_ON_INJECT_CONSTRUCTOR = "@Scope annotations are not allowed on @Inject constructors. Annotate the class instead.";
    static final String CHECKED_EXCEPTIONS_ON_CONSTRUCTORS = "Dagger does not support checked exceptions on @Inject constructors.";
    static final String PRIVATE_INJECT_FIELD = "Dagger does not support injection into private fields";
    static final String STATIC_INJECT_FIELD = "Dagger does not support injection into static fields";
    static final String PRIVATE_INJECT_METHOD = "Dagger does not support injection into private methods";
    static final String STATIC_INJECT_METHOD = "Dagger does not support injection into static methods";
    static final String INJECT_INTO_PRIVATE_CLASS = "Dagger does not support injection into private classes";
    static final String CANNOT_INJECT_WILDCARD_TYPE = "Dagger does not support injecting Provider<T>, Lazy<T> or Produced<T> when T is a wildcard type such as <%s>.";
    static final String DUPLICATE_BINDINGS_FOR_KEY_FORMAT = "%s is bound multiple times:";
    static final String COMPONENT_ANNOTATED_REUSABLE = "@Reusable cannot be applied to components or subcomponents.";
    static final String BINDING_METHOD_RETURN_TYPE = "@%s methods must return a primitive, an array, a type variable, or a declared type.";
    static final String BINDING_METHOD_THROWS_CHECKED = "@%s methods may only throw unchecked exceptions";
    static final String PRODUCES_METHOD_NULLABLE = "@Nullable on @Produces methods does not do anything.";
    static final String PRODUCES_METHOD_RETURN_TYPE = "@Produces methods must return a primitive, an array, a type variable, or a declared type, or a ListenableFuture of one of those types.";
    static final String PRODUCES_METHOD_RAW_FUTURE = "@Produces methods cannot return a raw ListenableFuture.";
    static final String BINDING_METHOD_SET_VALUES_RAW_SET = "@%s methods of type set values cannot return a raw Set";
    static final String BINDS_ELEMENTS_INTO_SET_METHOD_RAW_SET_PARAMETER = "@Binds @ElementsIntoSet methods cannot take a raw Set parameter";
    static final String BINDING_METHOD_SET_VALUES_RETURN_SET = "@%s methods of type set values must return a Set";
    static final String PRODUCES_METHOD_SET_VALUES_RETURN_SET = "@Produces methods of type set values must return a Set or ListenableFuture of Set";
    static final String PRODUCES_METHOD_SCOPE = "@Produces methods may not have scope annotations.";
    static final String BINDING_METHOD_THROWS = "@%s methods may only throw unchecked exceptions or exceptions subclassing Exception";
    static final String BINDING_METHOD_THROWS_ANY = "@%s methods may not throw";
    static final String BINDING_METHOD_MUST_RETURN_A_VALUE = "@%s methods must return a value (not void).";
    static final String BINDING_METHOD_MUST_NOT_BIND_FRAMEWORK_TYPES = "@%s methods must not return framework types.";
    static final String BINDING_METHOD_ABSTRACT = "@%s methods cannot be abstract";
    static final String BINDING_METHOD_NOT_ABSTRACT = "@%s methods must be abstract";
    static final String BINDING_METHOD_PRIVATE = "@%s methods cannot be private";
    static final String BINDING_METHOD_TYPE_PARAMETER = "@%s methods may not have type parameters.";
    static final String BINDS_METHOD_ONE_ASSIGNABLE_PARAMETER = "@Binds methods must have only one parameter whose type is assignable to the return type";
    static final String BINDS_OPTIONAL_OF_METHOD_HAS_PARAMETER = "@BindsOptionalOf methods must not have parameters";
    static final String BINDS_OPTIONAL_OF_METHOD_RETURNS_IMPLICITLY_PROVIDED_TYPE = "@BindsOptionalOf methods cannot return unqualified types that have an @Inject-annotated constructor because those are always present";
    static final String BINDING_METHOD_NOT_IN_MODULE = "@%s methods can only be present within a @%s";
    static final String BINDS_ELEMENTS_INTO_SET_METHOD_RETURN_SET = "@Binds @ElementsIntoSet methods must return a Set and take a Set parameter";
    static final String BINDING_METHOD_NOT_MAP_HAS_MAP_KEY = "@%s methods of non map type cannot declare a map key";
    static final String BINDING_METHOD_WITH_NO_MAP_KEY = "@%s methods of type map must declare a map key";
    static final String BINDING_METHOD_WITH_MULTIPLE_MAP_KEYS = "@%s methods may not have more than one @MapKey-marked annotation";
    static final String BINDING_METHOD_WITH_SAME_NAME = "Cannot have more than one @%s method with the same name in a single module";
    static final String INCOMPATIBLE_MODULE_METHODS = "A @%1$s may not contain both non-static @%2$s methods and abstract @Binds or @Multibinds declarations";
    static final String MODULES_WITH_TYPE_PARAMS_MUST_BE_ABSTRACT = "Modules with type parameters must be abstract";
    static final String REFERENCED_MODULE_NOT_ANNOTATED = "%s is listed as a module, but is not annotated with %s";
    static final String REFERENCED_MODULE_MUST_NOT_HAVE_TYPE_PARAMS = "%s is listed as a module, but has type parameters";
    static final String PROVIDES_METHOD_OVERRIDES_ANOTHER = "@%s methods may not override another method. Overrides: %s";
    static final String METHOD_OVERRIDES_PROVIDES_METHOD = "@%s methods may not be overridden in modules. Overrides: %s";
    static final String BINDING_METHOD_MULTIPLE_QUALIFIERS = "Cannot use more than one @Qualifier";
    static final String MAPKEY_WITHOUT_MEMBERS = "Map key annotations must have members";
    static final String UNWRAPPED_MAP_KEY_WITH_TOO_MANY_MEMBERS = "Map key annotations with unwrapped values must have exactly one member";
    static final String UNWRAPPED_MAP_KEY_WITH_ARRAY_MEMBER = "Map key annotations with unwrapped values cannot use arrays";
    static final String MULTIPLE_CONTRIBUTION_TYPES_FOR_KEY_FORMAT = "%s has incompatible bindings or declarations:\n";
    static final String PROVIDER_ENTRY_POINT_MAY_NOT_DEPEND_ON_PRODUCER_FORMAT = "%s is a provision entry-point, which cannot depend on a production.";
    static final String PROVIDER_MAY_NOT_DEPEND_ON_PRODUCER_FORMAT = "%s is a provision, which cannot depend on a production.";
    static final String DEPENDS_ON_PRODUCTION_EXECUTOR_FORMAT = "%s may not depend on the production executor.";
    static final String REQUIRES_AT_INJECT_CONSTRUCTOR_OR_PROVIDER_FORMAT = "%s cannot be provided without an @Inject constructor or from an @Provides-annotated method.";
    static final String REQUIRES_PROVIDER_FORMAT = "%s cannot be provided without an @Provides-annotated method.";
    static final String REQUIRES_AT_INJECT_CONSTRUCTOR_OR_PROVIDER_OR_PRODUCER_FORMAT = "%s cannot be provided without an @Inject constructor or from an @Provides- or @Produces-annotated method.";
    static final String REQUIRES_PROVIDER_OR_PRODUCER_FORMAT = "%s cannot be provided without an @Provides- or @Produces-annotated method.";
    private static final String PROVISION_MAY_NOT_DEPEND_ON_PRODUCER_TYPE_FORMAT = "%s may only be injected in @Produces methods.";
    static final String MEMBERS_INJECTION_DOES_NOT_IMPLY_PROVISION = "This type supports members injection but cannot be implicitly provided.";
    static final String MEMBERS_INJECTION_WITH_RAW_TYPE = "%s has type parameters, cannot members inject the raw type. via:\n%s";
    static final String MEMBERS_INJECTION_WITH_UNBOUNDED_TYPE = "Type parameters must be bounded for members injection. %s required by %s, via:\n%s";
    static final String CONTAINS_DEPENDENCY_CYCLE_FORMAT = "Found a dependency cycle:\n%s";
    static final String CANNOT_RETURN_NULL_FROM_NON_NULLABLE_COMPONENT_METHOD = "Cannot return null from a non-@Nullable component method";
    static final String CANNOT_RETURN_NULL_FROM_NON_NULLABLE_PROVIDES_METHOD = "Cannot return null from a non-@Nullable @Provides method";
    static final String MULTIBINDING_ANNOTATION_NOT_ON_BINDING_METHOD = "Multibinding annotations may only be on @Provides, @Produces, or @Binds methods";
    static final String MULTIPLE_MULTIBINDING_ANNOTATIONS_ON_METHOD = "Multiple multibinding annotations cannot be placed on the same %s method";
    static final String MULTIBINDING_ANNOTATION_CONFLICTS_WITH_BINDING_ANNOTATION_ENUM = "@%s.type cannot be used with multibinding annotations";
    static final String BINDS_INSTANCE_IN_MODULE = "@BindsInstance methods should not be included in @%ss. Did you mean @Binds?";
    static final String BINDS_INSTANCE_IN_INVALID_COMPONENT = "@BindsInstance methods should not be included in @%1$ss. Did you mean to put it in a @%1$s.Builder?";
    static final String BINDS_INSTANCE_ONE_PARAMETER = "@BindsInstance methods should have exactly one parameter for the bound type";
    static final String CAN_RELEASE_REFERENCES_ANNOTATIONS_MUST_NOT_HAVE_SOURCE_RETENTION = "@CanReleaseReferences annotations must not have SOURCE retention";

    static String duplicateMapKeysError(String key) {
        return "The same map key is bound more than once for " + key;
    }

    static String inconsistentMapKeyAnnotationsError(String key) {
        return key + " uses more than one @MapKey annotation type";
    }

    static String provisionMayNotDependOnProducerType(TypeMirror type) {
        return String.format(PROVISION_MAY_NOT_DEPEND_ON_PRODUCER_TYPE_FORMAT, MoreTypes.asTypeElement(type).getSimpleName());
    }

    static String nullableToNonNullable(String typeName, String bindingString) {
        return String.format("%s is not nullable, but is being provided by %s", typeName, bindingString);
    }

    static ComponentBuilderMessages builderMsgsFor(ComponentDescriptor.Kind kind) {
        switch (kind) {
            case COMPONENT: {
                return ComponentBuilderMessages.INSTANCE;
            }
            case SUBCOMPONENT: {
                return SubcomponentBuilderMessages.INSTANCE;
            }
            case PRODUCTION_COMPONENT: {
                return ProductionComponentBuilderMessages.INSTANCE;
            }
            case PRODUCTION_SUBCOMPONENT: {
                return ProductionSubcomponentBuilderMessages.INSTANCE;
            }
        }
        throw new IllegalStateException(kind.toString());
    }

    static String forReleasableReferencesValueNotAScope(TypeElement scopeType) {
        return ErrorMessages.forReleasableReferencesValueNeedsAnnotation(scopeType, String.format("@%s and @%s", Scope.class.getCanonicalName(), CanReleaseReferences.class.getCanonicalName()));
    }

    static String forReleasableReferencesValueCannotReleaseReferences(TypeElement scopeType) {
        return ErrorMessages.forReleasableReferencesValueNeedsAnnotation(scopeType, "@" + CanReleaseReferences.class.getCanonicalName());
    }

    private static String forReleasableReferencesValueNeedsAnnotation(TypeElement scopeType, String annotations) {
        return String.format("The value of @%s must be a reference-releasing scope. Did you mean to annotate %s with %s? Or did you mean to use a different class here?", ForReleasableReferences.class.getSimpleName(), scopeType.getQualifiedName(), annotations);
    }

    static String referenceReleasingScopeNotInComponentHierarchy(String formattedKey, dagger.model.Scope scope, BindingGraph topLevelGraph) {
        return String.format("There is no binding for %s because no component in %s's component hierarchy is annotated with %s. The available reference-releasing scopes are %s.", formattedKey, topLevelGraph.componentType().getQualifiedName(), Scopes.getReadableSource(scope), topLevelGraph.componentDescriptor().releasableReferencesScopes().stream().map(Scopes::getReadableSource).collect(Collectors.toList()));
    }

    static String referenceReleasingScopeMetadataMissingCanReleaseReferences(String formattedKey, DeclaredType metadataType) {
        return String.format("There is no binding for %s because %s is not annotated with @%s.", formattedKey, metadataType, CanReleaseReferences.class.getCanonicalName());
    }

    static String referenceReleasingScopeNotAnnotatedWithMetadata(String formattedKey, dagger.model.Scope scope, TypeMirror metadataType) {
        return String.format("There is no binding for %s because %s is not annotated with @%s.", formattedKey, scope.scopeAnnotationElement().getQualifiedName(), metadataType);
    }

    static String tooManyBindingMethodAnnotations(ExecutableElement method, Collection<Class<? extends Annotation>> methodAnnotations) {
        return String.format("%s is annotated with more than one of (%s)", method.getSimpleName(), methodAnnotations.stream().map(Class::getCanonicalName).collect(Collectors.joining(", ")));
    }

    static String abstractModuleHasInstanceBindingMethods(ModuleDescriptor module) {
        String methodAnnotations;
        switch (module.kind()) {
            case MODULE: {
                methodAnnotations = "@Provides";
                break;
            }
            case PRODUCER_MODULE: {
                methodAnnotations = "@Provides or @Produces";
                break;
            }
            default: {
                throw new AssertionError((Object)module.kind());
            }
        }
        return String.format("%s is abstract and has instance %s methods. Consider making the methods static or including a non-abstract subclass of the module instead.", module.moduleElement(), methodAnnotations);
    }

    static String format(AnnotationMirror annotation) {
        return DiagnosticFormatting.stripCommonTypePrefixes(annotation.toString());
    }

    private ErrorMessages() {
    }

    static class ModuleMessages {
        ModuleMessages() {
        }

        static String moduleSubcomponentsIncludesBuilder(TypeElement moduleSubcomponentsAttribute) {
            TypeElement subcomponentType = MoreElements.asType(moduleSubcomponentsAttribute.getEnclosingElement());
            return String.format("%s is a @%s.Builder. Did you mean to use %s?", moduleSubcomponentsAttribute.getQualifiedName(), MoreAnnotationMirrors.simpleName(ConfigurationAnnotations.getSubcomponentAnnotation(subcomponentType).get()), subcomponentType.getQualifiedName());
        }

        static String moduleSubcomponentsIncludesNonSubcomponent(TypeElement moduleSubcomponentsAttribute) {
            return moduleSubcomponentsAttribute.getQualifiedName() + " is not a @Subcomponent or @ProductionSubcomponent";
        }

        static String moduleSubcomponentsDoesntHaveBuilder(TypeElement subcomponent, AnnotationMirror moduleAnnotation) {
            return String.format("%s doesn't have a @%s.Builder, which is required when used with @%s.subcomponents", subcomponent.getQualifiedName(), MoreAnnotationMirrors.simpleName(ConfigurationAnnotations.getSubcomponentAnnotation(subcomponent).get()), MoreAnnotationMirrors.simpleName(moduleAnnotation));
        }
    }

    static final class MultibindsMessages {
        static final String METHOD_MUST_RETURN_MAP_OR_SET = "@%s methods must return Map<K, V> or Set<T>";
        static final String PARAMETERS = "@%s methods cannot have parameters";

        private MultibindsMessages() {
        }
    }

    private static final class ProductionSubcomponentBuilderMessages
    extends ComponentBuilderMessages {
        static final ProductionSubcomponentBuilderMessages INSTANCE = new ProductionSubcomponentBuilderMessages();

        private ProductionSubcomponentBuilderMessages() {
        }

        @Override
        protected String process(String s) {
            return s.replaceAll("component", "production subcomponent").replaceAll("Component", "ProductionSubcomponent");
        }
    }

    private static final class ProductionComponentBuilderMessages
    extends ComponentBuilderMessages {
        static final ProductionComponentBuilderMessages INSTANCE = new ProductionComponentBuilderMessages();

        private ProductionComponentBuilderMessages() {
        }

        @Override
        protected String process(String s) {
            return s.replaceAll("component", "production component").replaceAll("Component", "ProductionComponent");
        }
    }

    static final class SubcomponentBuilderMessages
    extends ComponentBuilderMessages {
        static final SubcomponentBuilderMessages INSTANCE = new SubcomponentBuilderMessages();

        SubcomponentBuilderMessages() {
        }

        @Override
        protected String process(String s) {
            return s.replaceAll("component", "subcomponent").replaceAll("Component", "Subcomponent");
        }

        String builderMethodRequiresNoArgs() {
            return "Methods returning a @Subcomponent.Builder must have no arguments";
        }

        String moreThanOneRefToSubcomponent() {
            return "Only one method can create a given subcomponent. %s is created by: %s";
        }
    }

    static class ComponentBuilderMessages {
        static final ComponentBuilderMessages INSTANCE = new ComponentBuilderMessages();

        ComponentBuilderMessages() {
        }

        protected String process(String s) {
            return s;
        }

        final String moreThanOne() {
            return this.process("@Component has more than one @Component.Builder: %s");
        }

        final String cxtorOnlyOneAndNoArgs() {
            return this.process("@Component.Builder classes must have exactly one constructor, and it must not have any parameters");
        }

        final String generics() {
            return this.process("@Component.Builder types must not have any generic types");
        }

        final String mustBeInComponent() {
            return this.process("@Component.Builder types must be nested within a @Component");
        }

        final String mustBeClassOrInterface() {
            return this.process("@Component.Builder types must be abstract classes or interfaces");
        }

        final String isPrivate() {
            return this.process("@Component.Builder types must not be private");
        }

        final String mustBeStatic() {
            return this.process("@Component.Builder types must be static");
        }

        final String mustBeAbstract() {
            return this.process("@Component.Builder types must be abstract");
        }

        final String missingBuildMethod() {
            return this.process("@Component.Builder types must have exactly one no-args method that  returns the @Component type");
        }

        final String manyMethodsForType() {
            return this.process("@Component.Builder types must not have more than one setter method per type, but %s is set by %s");
        }

        final String extraSetters() {
            return this.process("@Component.Builder has setters for modules or components that aren't required: %s");
        }

        final String missingSetters() {
            return this.process("@Component.Builder is missing setters for required modules or components: %s");
        }

        final String twoBuildMethods() {
            return this.process("@Component.Builder types must have exactly one zero-arg method, and that method must return the @Component type. Already found: %s");
        }

        final String inheritedTwoBuildMethods() {
            return this.process("@Component.Builder types must have exactly one zero-arg method, and that method must return the @Component type. Found %s and %s");
        }

        final String buildMustReturnComponentType() {
            return this.process("@Component.Builder methods that have no arguments must return the @Component type or a supertype of the @Component");
        }

        final String inheritedBuildMustReturnComponentType() {
            return this.process(this.buildMustReturnComponentType() + ". Inherited method: %s");
        }

        final String methodsMustTakeOneArg() {
            return this.process("@Component.Builder methods must not have more than one argument");
        }

        final String inheritedMethodsMustTakeOneArg() {
            return this.process("@Component.Builder methods must not have more than one argument. Inherited method: %s");
        }

        final String methodsMustReturnVoidOrBuilder() {
            return this.process("@Component.Builder setter methods must return void, the builder, or a supertype of the builder");
        }

        final String inheritedMethodsMustReturnVoidOrBuilder() {
            return this.process("@Component.Builder setter methods must return void, the builder,or a supertype of the builder. Inherited method: %s");
        }

        final String methodsMayNotHaveTypeParameters() {
            return this.process("@Component.Builder methods must not have type parameters");
        }

        final String inheritedMethodsMayNotHaveTypeParameters() {
            return this.process("@Component.Builder methods must not have type parameters. Inherited method: %s");
        }

        final String buildMethodReturnsSupertypeWithMissingMethods(TypeElement component, TypeElement componentBuilder, TypeMirror returnType, ExecutableElement buildMethod, Set<ExecutableElement> additionalMethods) {
            return String.format("%1$s.%2$s() returns %3$s, but %4$s declares additional component method(s): %5$s. In order to provide type-safe access to these methods, override %2$s() to return %4$s", componentBuilder.getQualifiedName(), buildMethod.getSimpleName(), returnType, component.getQualifiedName(), Joiner.on((String)", ").join(additionalMethods));
        }
    }
}

