/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import dagger.Binds;
import dagger.Subcomponent;
import dagger.internal.codegen.AnyBindingMethodValidator;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerStreams;
import dagger.internal.codegen.ErrorMessages;
import dagger.internal.codegen.MethodSignatureFormatter;
import dagger.internal.codegen.ModuleDescriptor;
import dagger.internal.codegen.MoreAnnotationValues;
import dagger.internal.codegen.Util;
import dagger.internal.codegen.ValidationReport;
import dagger.multibindings.Multibinds;
import dagger.producers.ProductionSubcomponent;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import dagger.shaded.auto.common.Visibility;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Scope;
import javax.inject.Singleton;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;

@Singleton
final class ModuleValidator {
    private static final ImmutableSet<Class<? extends Annotation>> SUBCOMPONENT_TYPES;
    private static final ImmutableSet<Class<? extends Annotation>> SUBCOMPONENT_BUILDER_TYPES;
    private static final Optional<Class<?>> ANDROID_PROCESSOR;
    private static final String CONTRIBUTES_ANDROID_INJECTOR_NAME = "dagger.android.ContributesAndroidInjector";
    private static final String ANDROID_PROCESSOR_NAME = "dagger.android.processor.AndroidProcessor";
    private final Types types;
    private final DaggerElements elements;
    private final AnyBindingMethodValidator anyBindingMethodValidator;
    private final MethodSignatureFormatter methodSignatureFormatter;
    private final Map<TypeElement, ValidationReport<TypeElement>> cache = new HashMap<TypeElement, ValidationReport<TypeElement>>();
    private final Set<TypeElement> knownModules = new HashSet<TypeElement>();

    @Inject
    ModuleValidator(Types types, DaggerElements elements, AnyBindingMethodValidator anyBindingMethodValidator, MethodSignatureFormatter methodSignatureFormatter) {
        this.types = types;
        this.elements = elements;
        this.anyBindingMethodValidator = anyBindingMethodValidator;
        this.methodSignatureFormatter = methodSignatureFormatter;
    }

    void addKnownModules(Collection<TypeElement> modules) {
        this.knownModules.addAll(modules);
    }

    ValidationReport<TypeElement> validate(TypeElement module) {
        return Util.reentrantComputeIfAbsent(this.cache, module, this::validateUncached);
    }

    private ValidationReport<TypeElement> validateUncached(TypeElement module) {
        ValidationReport.Builder<TypeElement> builder = ValidationReport.about(module);
        ModuleDescriptor.Kind moduleKind = ModuleDescriptor.Kind.forAnnotatedElement(module).get();
        ArrayListMultimap allMethodsByName = ArrayListMultimap.create();
        ArrayListMultimap bindingMethodsByName = ArrayListMultimap.create();
        EnumSet<ModuleMethodKind> methodKinds = EnumSet.noneOf(ModuleMethodKind.class);
        TypeElement contributesAndroidInjectorElement = this.elements.getTypeElement(CONTRIBUTES_ANDROID_INJECTOR_NAME);
        TypeMirror contributesAndroidInjector = contributesAndroidInjectorElement != null ? contributesAndroidInjectorElement.asType() : null;
        block0: for (ExecutableElement moduleMethod : ElementFilter.methodsIn(module.getEnclosedElements())) {
            if (this.anyBindingMethodValidator.isBindingMethod(moduleMethod)) {
                builder.addSubreport(this.anyBindingMethodValidator.validate(moduleMethod));
            }
            if (DaggerElements.isAnyAnnotationPresent(moduleMethod, (Iterable<? extends Class<? extends Annotation>>)ImmutableSet.of(moduleKind.methodAnnotation(), Binds.class, Multibinds.class))) {
                bindingMethodsByName.put((Object)moduleMethod.getSimpleName().toString(), (Object)moduleMethod);
                methodKinds.add(ModuleMethodKind.ofMethod(moduleMethod));
            }
            allMethodsByName.put((Object)moduleMethod.getSimpleName().toString(), (Object)moduleMethod);
            for (AnnotationMirror annotationMirror : moduleMethod.getAnnotationMirrors()) {
                if (ANDROID_PROCESSOR.isPresent() || !MoreTypes.equivalence().equivalent((Object)contributesAndroidInjector, (Object)annotationMirror.getAnnotationType())) continue;
                builder.addSubreport(ValidationReport.about(moduleMethod).addError(String.format("@%s was used, but %s was not found on the processor path", CONTRIBUTES_ANDROID_INJECTOR_NAME, ANDROID_PROCESSOR_NAME)).build());
                continue block0;
            }
        }
        if (methodKinds.containsAll(EnumSet.of(ModuleMethodKind.ABSTRACT_DECLARATION, ModuleMethodKind.INSTANCE_BINDING))) {
            builder.addError(String.format("A @%1$s may not contain both non-static @%2$s methods and abstract @Binds or @Multibinds declarations", moduleKind.moduleAnnotation().getSimpleName(), moduleKind.methodAnnotation().getSimpleName()));
        }
        this.validateModuleVisibility(module, moduleKind, builder);
        this.validateMethodsWithSameName(moduleKind, builder, (ListMultimap<String, ExecutableElement>)bindingMethodsByName);
        if (module.getKind() != ElementKind.INTERFACE) {
            this.validateProvidesOverrides(module, moduleKind, builder, (ListMultimap<String, ExecutableElement>)allMethodsByName, (ListMultimap<String, ExecutableElement>)bindingMethodsByName);
        }
        this.validateModifiers(module, builder);
        this.validateReferencedModules(module, moduleKind, builder);
        this.validateReferencedSubcomponents(module, moduleKind, builder);
        this.validateNoScopeAnnotationsOnModuleElement(module, moduleKind, builder);
        return builder.build();
    }

    private void validateReferencedSubcomponents(final TypeElement subject, ModuleDescriptor.Kind moduleKind, final ValidationReport.Builder<TypeElement> builder) {
        final AnnotationMirror moduleAnnotation = moduleKind.getModuleAnnotationMirror(subject).get();
        for (TypeMirror subcomponentAttribute : ConfigurationAnnotations.getModuleSubcomponents(moduleAnnotation)) {
            subcomponentAttribute.accept(new SimpleTypeVisitor6<Void, Void>(){

                @Override
                protected Void defaultAction(TypeMirror e, Void aVoid) {
                    builder.addError(e + " is not a valid subcomponent type", subject, moduleAnnotation);
                    return null;
                }

                @Override
                public Void visitDeclared(DeclaredType declaredType, Void aVoid) {
                    TypeElement attributeType = MoreTypes.asTypeElement(declaredType);
                    if (DaggerElements.isAnyAnnotationPresent(attributeType, (Iterable<? extends Class<? extends Annotation>>)SUBCOMPONENT_TYPES)) {
                        ModuleValidator.validateSubcomponentHasBuilder(attributeType, moduleAnnotation, builder);
                    } else {
                        builder.addError(DaggerElements.isAnyAnnotationPresent(attributeType, (Iterable<? extends Class<? extends Annotation>>)SUBCOMPONENT_BUILDER_TYPES) ? ErrorMessages.ModuleMessages.moduleSubcomponentsIncludesBuilder(attributeType) : ErrorMessages.ModuleMessages.moduleSubcomponentsIncludesNonSubcomponent(attributeType), subject, moduleAnnotation);
                    }
                    return null;
                }
            }, null);
        }
    }

    private static void validateSubcomponentHasBuilder(TypeElement subcomponentAttribute, AnnotationMirror moduleAnnotation, ValidationReport.Builder<TypeElement> builder) {
        if (ConfigurationAnnotations.getSubcomponentBuilder(subcomponentAttribute).isPresent()) {
            return;
        }
        builder.addError(ErrorMessages.ModuleMessages.moduleSubcomponentsDoesntHaveBuilder(subcomponentAttribute, moduleAnnotation), builder.getSubject(), moduleAnnotation);
    }

    private void validateModifiers(TypeElement subject, ValidationReport.Builder<TypeElement> builder) {
        if (!subject.getTypeParameters().isEmpty() && !subject.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            builder.addError("Modules with type parameters must be abstract", subject);
        }
    }

    private void validateMethodsWithSameName(ModuleDescriptor.Kind moduleKind, ValidationReport.Builder<TypeElement> builder, ListMultimap<String, ExecutableElement> bindingMethodsByName) {
        for (Map.Entry entry : bindingMethodsByName.asMap().entrySet()) {
            if (((Collection)entry.getValue()).size() <= 1) continue;
            for (ExecutableElement offendingMethod : (Collection)entry.getValue()) {
                builder.addError(String.format("Cannot have more than one @%s method with the same name in a single module", moduleKind.methodAnnotation().getSimpleName()), offendingMethod);
            }
        }
    }

    private void validateReferencedModules(TypeElement subject, ModuleDescriptor.Kind moduleKind, ValidationReport.Builder<TypeElement> builder) {
        AnnotationMirror mirror = moduleKind.getModuleAnnotationMirror(subject).get();
        builder.addSubreport(this.validateReferencedModules(subject, mirror, moduleKind.includesKinds()));
    }

    ValidationReport<TypeElement> validateReferencedModules(final TypeElement annotatedType, final AnnotationMirror annotation, ImmutableSet<ModuleDescriptor.Kind> validModuleKinds) {
        final ValidationReport.Builder<TypeElement> subreport = ValidationReport.about(annotatedType);
        final ImmutableSet validModuleAnnotations = validModuleKinds.stream().map(ModuleDescriptor.Kind::moduleAnnotation).collect(DaggerStreams.toImmutableSet());
        for (final AnnotationValue includedModule : ConfigurationAnnotations.getModules(annotatedType, annotation)) {
            MoreAnnotationValues.asType(includedModule).accept(new SimpleTypeVisitor8<Void, Void>(){

                @Override
                protected Void defaultAction(TypeMirror mirror, Void p) {
                    this.reportError("%s is not a valid module type.", mirror);
                    return null;
                }

                @Override
                public Void visitDeclared(DeclaredType t, Void p) {
                    TypeElement module = MoreElements.asType(t.asElement());
                    if (!t.getTypeArguments().isEmpty()) {
                        this.reportError("%s is listed as a module, but has type parameters", module.getQualifiedName());
                    }
                    if (!DaggerElements.isAnyAnnotationPresent(module, (Iterable<? extends Class<? extends Annotation>>)validModuleAnnotations)) {
                        this.reportError("%s is listed as a module, but is not annotated with %s", module.getQualifiedName(), (validModuleAnnotations.size() > 1 ? "one of " : "") + validModuleAnnotations.stream().map(otherClass -> "@" + otherClass.getSimpleName()).collect(Collectors.joining(", ")));
                    } else if (ModuleValidator.this.knownModules.contains(module) && !ModuleValidator.this.validate(module).isClean()) {
                        this.reportError("%s has errors", module.getQualifiedName());
                    }
                    return null;
                }

                private void reportError(String format, Object ... args) {
                    subreport.addError(String.format(format, args), annotatedType, annotation, includedModule);
                }
            }, null);
        }
        return subreport.build();
    }

    private void validateProvidesOverrides(TypeElement subject, ModuleDescriptor.Kind moduleKind, ValidationReport.Builder<TypeElement> builder, ListMultimap<String, ExecutableElement> allMethodsByName, ListMultimap<String, ExecutableElement> bindingMethodsByName) {
        TypeElement currentClass = subject;
        TypeMirror objectType = this.elements.getTypeElement(Object.class).asType();
        HashSet failedMethods = Sets.newHashSet();
        while (!this.types.isSameType(currentClass.getSuperclass(), objectType)) {
            currentClass = MoreElements.asType(this.types.asElement(currentClass.getSuperclass()));
            List<ExecutableElement> superclassMethods = ElementFilter.methodsIn(currentClass.getEnclosedElements());
            for (ExecutableElement superclassMethod : superclassMethods) {
                String name = superclassMethod.getSimpleName().toString();
                for (ExecutableElement providesMethod : bindingMethodsByName.get((Object)name)) {
                    if (failedMethods.contains(providesMethod) || !this.elements.overrides(providesMethod, superclassMethod, subject)) continue;
                    failedMethods.add(providesMethod);
                    builder.addError(String.format("@%s methods may not override another method. Overrides: %s", moduleKind.methodAnnotation().getSimpleName(), this.methodSignatureFormatter.format(superclassMethod)), providesMethod);
                }
                if (MoreElements.isAnnotationPresent(superclassMethod, moduleKind.methodAnnotation())) {
                    for (ExecutableElement method : allMethodsByName.get((Object)name)) {
                        if (failedMethods.contains(method) || !this.elements.overrides(method, superclassMethod, subject)) continue;
                        failedMethods.add(method);
                        builder.addError(String.format("@%s methods may not be overridden in modules. Overrides: %s", moduleKind.methodAnnotation().getSimpleName(), this.methodSignatureFormatter.format(superclassMethod)), method);
                    }
                }
                allMethodsByName.put((Object)superclassMethod.getSimpleName().toString(), (Object)superclassMethod);
            }
        }
    }

    private void validateModuleVisibility(TypeElement moduleElement, ModuleDescriptor.Kind moduleKind, ValidationReport.Builder<?> reportBuilder) {
        Visibility moduleVisibility = Visibility.ofElement(moduleElement);
        if (moduleVisibility.equals((Object)Visibility.PRIVATE)) {
            reportBuilder.addError("Modules cannot be private.", moduleElement);
        } else if (Visibility.effectiveVisibilityOfElement(moduleElement).equals((Object)Visibility.PRIVATE)) {
            reportBuilder.addError("Modules cannot be enclosed in private types.", moduleElement);
        }
        switch (moduleElement.getNestingKind()) {
            case ANONYMOUS: {
                throw new IllegalStateException("Can't apply @Module to an anonymous class");
            }
            case LOCAL: {
                throw new IllegalStateException("Local classes shouldn't show up in the processor");
            }
            case MEMBER: 
            case TOP_LEVEL: {
                if (!moduleVisibility.equals((Object)Visibility.PUBLIC)) break;
                ImmutableSet nonPublicModules = FluentIterable.from(ConfigurationAnnotations.getModuleIncludes(DaggerElements.getAnnotationMirror(moduleElement, moduleKind.moduleAnnotation()).get())).transform(this.types::asElement).filter(element -> Visibility.effectiveVisibilityOfElement(element).compareTo(Visibility.PUBLIC) < 0).toSet();
                if (nonPublicModules.isEmpty()) break;
                reportBuilder.addError(String.format("This module is public, but it includes non-public (or effectively non-public) modules. Either reduce the visibility of this module or make %s public.", ModuleValidator.formatListForErrorMessage(nonPublicModules.asList())), moduleElement);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void validateNoScopeAnnotationsOnModuleElement(TypeElement module, ModuleDescriptor.Kind moduleKind, ValidationReport.Builder<TypeElement> report) {
        for (AnnotationMirror scope : AnnotationMirrors.getAnnotatedAnnotations(module, Scope.class)) {
            report.addError(String.format("@%ss cannot be scoped. Did you mean to scope a method instead?", moduleKind.moduleAnnotation().getSimpleName()), module, scope);
        }
    }

    private static String formatListForErrorMessage(List<?> things) {
        switch (things.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return things.get(0).toString();
            }
        }
        StringBuilder output = new StringBuilder();
        Joiner.on((String)", ").appendTo(output, things.subList(0, things.size() - 1));
        output.append(" and ").append(things.get(things.size() - 1));
        return output.toString();
    }

    static {
        Class<?> clazz;
        SUBCOMPONENT_TYPES = ImmutableSet.of(Subcomponent.class, ProductionSubcomponent.class);
        SUBCOMPONENT_BUILDER_TYPES = ImmutableSet.of(Subcomponent.Builder.class, ProductionSubcomponent.Builder.class);
        try {
            clazz = Class.forName(ANDROID_PROCESSOR_NAME, false, ModuleValidator.class.getClassLoader());
        }
        catch (ClassNotFoundException ignored) {
            clazz = null;
        }
        ANDROID_PROCESSOR = Optional.ofNullable(clazz);
    }

    static enum ModuleMethodKind {
        ABSTRACT_DECLARATION,
        INSTANCE_BINDING,
        STATIC_BINDING;


        static ModuleMethodKind ofMethod(ExecutableElement moduleMethod) {
            if (moduleMethod.getModifiers().contains((Object)Modifier.STATIC)) {
                return STATIC_BINDING;
            }
            if (moduleMethod.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return ABSTRACT_DECLARATION;
            }
            return INSTANCE_BINDING;
        }
    }
}

