/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimaps;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.KeyFactory;
import dagger.internal.codegen.UniqueNameSet;
import dagger.model.Key;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

final class SubcomponentNames {
    private static final Splitter QUALIFIED_NAME_SPLITTER = Splitter.on((char)'.');
    private final ImmutableMap<ComponentDescriptor, String> namesByDescriptor;
    private final ImmutableMap<Key, String> namesByKey;

    SubcomponentNames(BindingGraph graph, KeyFactory keyFactory) {
        this.namesByDescriptor = SubcomponentNames.namesByDescriptor(graph);
        this.namesByKey = SubcomponentNames.namesByKey(keyFactory, this.namesByDescriptor);
    }

    String get(ComponentDescriptor componentDescriptor) {
        return (String)this.namesByDescriptor.get((Object)componentDescriptor);
    }

    String get(Key key) {
        return (String)this.namesByKey.get((Object)key);
    }

    private static ImmutableMap<ComponentDescriptor, String> namesByDescriptor(BindingGraph graph) {
        ImmutableListMultimap componentDescriptorsBySimpleName = Multimaps.index(graph.componentDescriptors(), componentDescriptor -> componentDescriptor.componentDefinitionType().getSimpleName().toString());
        ImmutableMap<ComponentDescriptor, Namer> componentNamers = SubcomponentNames.qualifiedNames(graph.componentDescriptors());
        LinkedHashMap subcomponentImplSimpleNames = new LinkedHashMap();
        componentDescriptorsBySimpleName.asMap().values().forEach(components -> subcomponentImplSimpleNames.putAll(SubcomponentNames.disambiguateConflictingSimpleNames(components, componentNamers)));
        subcomponentImplSimpleNames.remove(graph.componentDescriptor());
        return ImmutableMap.copyOf(subcomponentImplSimpleNames);
    }

    private static ImmutableMap<Key, String> namesByKey(KeyFactory keyFactory, ImmutableMap<ComponentDescriptor, String> subcomponentNames) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        subcomponentNames.forEach((component, name) -> {
            if (component.builderSpec().isPresent()) {
                TypeMirror builderType = component.builderSpec().get().builderDefinitionType().asType();
                builder.put((Object)keyFactory.forSubcomponentBuilder(builderType), name);
            }
        });
        return builder.build();
    }

    private static ImmutableBiMap<ComponentDescriptor, String> disambiguateConflictingSimpleNames(Collection<ComponentDescriptor> components, ImmutableMap<ComponentDescriptor, Namer> componentNamers) {
        ComponentDescriptor component;
        Namer namer;
        LinkedHashMap<String, ComponentDescriptor> generatedSimpleNames = new LinkedHashMap<String, ComponentDescriptor>();
        Iterator<ComponentDescriptor> iterator = components.iterator();
        while (iterator.hasNext() && !generatedSimpleNames.containsKey((namer = (Namer)componentNamers.get((Object)(component = iterator.next()))).simpleName())) {
            generatedSimpleNames.put(namer.simpleName(), component);
        }
        if (generatedSimpleNames.size() != components.size()) {
            generatedSimpleNames.clear();
            UniqueNameSet nameSet = new UniqueNameSet();
            for (ComponentDescriptor component2 : components) {
                Namer namer2 = (Namer)componentNamers.get((Object)component2);
                String simpleName = namer2.simpleName();
                String basePrefix = namer2.uniquingPrefix();
                generatedSimpleNames.put(String.format("%s_%s", nameSet.getUniqueName(basePrefix), simpleName), component2);
            }
        }
        return ImmutableBiMap.copyOf(generatedSimpleNames).inverse();
    }

    private static ImmutableMap<ComponentDescriptor, Namer> qualifiedNames(Iterable<ComponentDescriptor> componentDescriptors) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ComponentDescriptor component : componentDescriptors) {
            builder.put((Object)component, (Object)new Namer(component.componentDefinitionType()));
        }
        return builder.build();
    }

    private static final class Namer {
        final TypeElement typeElement;

        Namer(TypeElement typeElement) {
            this.typeElement = typeElement;
        }

        String simpleName() {
            return this.typeElement.getSimpleName().toString();
        }

        String uniquingPrefix() {
            String containerName = this.typeElement.getEnclosingElement().getSimpleName().toString();
            if (!containerName.isEmpty() && Character.isUpperCase(containerName.charAt(0))) {
                return CharMatcher.javaLowerCase().removeFrom((CharSequence)containerName);
            }
            Name qualifiedName = this.typeElement.getQualifiedName();
            Iterator pieces = QUALIFIED_NAME_SPLITTER.split((CharSequence)qualifiedName).iterator();
            StringBuilder b = new StringBuilder();
            while (pieces.hasNext()) {
                String next = (String)pieces.next();
                if (!pieces.hasNext()) continue;
                b.append(next.charAt(0));
            }
            return b.length() > 0 ? b.toString() : "$";
        }
    }
}

