/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.BindsInstance;
import dagger.Component;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.ComponentGenerator;
import dagger.internal.codegen.ComponentProcessingStep;
import dagger.internal.codegen.ComponentRequirement;
import dagger.internal.codegen.ComponentValidator;
import dagger.internal.codegen.MethodSignature;
import dagger.internal.codegen.SourceFileGenerator;
import dagger.internal.codegen.TypeSpecs;
import dagger.producers.ProductionComponent;
import dagger.shaded.auto.common.BasicAnnotationProcessor;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class ComponentHjarProcessingStep
implements BasicAnnotationProcessor.ProcessingStep {
    private final Elements elements;
    private final SourceVersion sourceVersion;
    private final Types types;
    private final Filer filer;
    private final Messager messager;
    private final ComponentValidator componentValidator;
    private final ComponentDescriptor.Factory componentDescriptorFactory;

    @Inject
    ComponentHjarProcessingStep(Elements elements, SourceVersion sourceVersion, Types types, Filer filer, Messager messager, ComponentValidator componentValidator, ComponentDescriptor.Factory componentDescriptorFactory) {
        this.elements = elements;
        this.sourceVersion = sourceVersion;
        this.types = types;
        this.filer = filer;
        this.messager = messager;
        this.componentValidator = componentValidator;
        this.componentDescriptorFactory = componentDescriptorFactory;
    }

    public Set<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(Component.class, ProductionComponent.class);
    }

    public ImmutableSet<Element> process(SetMultimap<Class<? extends Annotation>, Element> elementsByAnnotation) {
        ImmutableSet.Builder rejectedElements = ImmutableSet.builder();
        ImmutableSet<Element> componentElements = ComponentProcessingStep.getElementsFromAnnotations(elementsByAnnotation, Component.class, ProductionComponent.class);
        for (Element element : componentElements) {
            TypeElement componentTypeElement = MoreElements.asType(element);
            try {
                ComponentValidator.ComponentValidationReport validationReport = this.componentValidator.validate(componentTypeElement, (Set<? extends Element>)ImmutableSet.of(), (Set<? extends Element>)ImmutableSet.of());
                validationReport.report().printMessagesTo(this.messager);
                if (!validationReport.report().isClean()) continue;
                new EmptyComponentGenerator(this.filer, this.elements, this.sourceVersion).generate(this.componentDescriptorFactory.forComponent(componentTypeElement), this.messager);
            }
            catch (TypeNotPresentException e) {
                rejectedElements.add((Object)componentTypeElement);
            }
        }
        return rejectedElements.build();
    }

    private MethodSpec emptyComponentMethod(TypeElement typeElement, ExecutableElement baseMethod) {
        return MethodSpec.overriding((ExecutableElement)baseMethod, (DeclaredType)MoreTypes.asDeclared(typeElement.asType()), (Types)this.types).build();
    }

    private MethodSpec privateConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    private Stream<ComponentRequirement> componentRequirements(ComponentDescriptor component) {
        Preconditions.checkArgument((boolean)component.kind().isTopLevel());
        return Stream.concat(component.dependencies().stream(), component.transitiveModules().stream().filter(module -> !module.moduleElement().getModifiers().contains((Object)Modifier.ABSTRACT)).map(module -> ComponentRequirement.forModule(module.moduleElement().asType())));
    }

    private boolean hasBindsInstanceMethods(ComponentDescriptor componentDescriptor) {
        return componentDescriptor.builderSpec().isPresent() && ElementFilter.methodsIn(this.elements.getAllMembers(componentDescriptor.builderSpec().get().builderDefinitionType())).stream().anyMatch(method -> MoreElements.isAnnotationPresent(method, BindsInstance.class));
    }

    private MethodSpec builderInstanceMethod(TypeElement componentRequirement, ClassName builderClass) {
        String simpleName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, componentRequirement.getSimpleName().toString());
        return MethodSpec.methodBuilder((String)simpleName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((TypeElement)componentRequirement), simpleName, new Modifier[0]).returns((TypeName)builderClass).build();
    }

    private MethodSpec builderBuildMethod(ComponentDescriptor component) {
        return MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((TypeElement)component.componentDefinitionType())).build();
    }

    private MethodSpec staticBuilderMethod(TypeName builderMethodReturnType) {
        return MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(builderMethodReturnType).build();
    }

    private MethodSpec createMethod(ComponentDescriptor componentDescriptor) {
        return MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassName.get((TypeElement)componentDescriptor.componentDefinitionType())).build();
    }

    private final class EmptyComponentGenerator
    extends SourceFileGenerator<ComponentDescriptor> {
        EmptyComponentGenerator(Filer filer, Elements elements, SourceVersion sourceVersion) {
            super(filer, elements, sourceVersion);
        }

        @Override
        ClassName nameGeneratedType(ComponentDescriptor input) {
            return ComponentGenerator.componentName(input.componentDefinitionType());
        }

        @Override
        Optional<? extends Element> getElementForErrorReporting(ComponentDescriptor input) {
            return Optional.of(input.componentDefinitionType());
        }

        @Override
        Optional<TypeSpec.Builder> write(ClassName generatedTypeName, ComponentDescriptor componentDescriptor) {
            ClassName builderMethodReturnType;
            TypeSpec.Builder generatedComponent = TypeSpec.classBuilder((ClassName)generatedTypeName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(ComponentHjarProcessingStep.this.privateConstructor());
            TypeElement componentElement = componentDescriptor.componentDefinitionType();
            TypeSpecs.addSupertype(generatedComponent, componentElement);
            if (componentDescriptor.builderSpec().isPresent()) {
                builderMethodReturnType = ClassName.get((TypeElement)componentDescriptor.builderSpec().get().builderDefinitionType());
            } else {
                ClassName builderClassName;
                TypeSpec.Builder builder = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addMethod(ComponentHjarProcessingStep.this.privateConstructor());
                builderMethodReturnType = builderClassName = generatedTypeName.nestedClass("Builder");
                ComponentHjarProcessingStep.this.componentRequirements(componentDescriptor).map(requirement -> ComponentHjarProcessingStep.this.builderInstanceMethod(requirement.typeElement(), builderClassName)).forEach(arg_0 -> ((TypeSpec.Builder)builder).addMethod(arg_0));
                builder.addMethod(ComponentHjarProcessingStep.this.builderBuildMethod(componentDescriptor));
                generatedComponent.addType(builder.build());
            }
            generatedComponent.addMethod(ComponentHjarProcessingStep.this.staticBuilderMethod((TypeName)builderMethodReturnType));
            if (ComponentHjarProcessingStep.this.componentRequirements(componentDescriptor).noneMatch(requirement -> requirement.requiresAPassedInstance(ComponentHjarProcessingStep.this.elements, ComponentHjarProcessingStep.this.types)) && !ComponentHjarProcessingStep.this.hasBindsInstanceMethods(componentDescriptor)) {
                generatedComponent.addMethod(ComponentHjarProcessingStep.this.createMethod(componentDescriptor));
            }
            DeclaredType componentType = MoreTypes.asDeclared(componentElement.asType());
            HashSet methodSignatures = Sets.newHashSetWithExpectedSize((int)componentDescriptor.componentMethods().size());
            componentDescriptor.componentMethods().stream().filter(method -> methodSignatures.add(MethodSignature.forComponentMethod(method, componentType, ComponentHjarProcessingStep.this.types))).forEach(method -> generatedComponent.addMethod(ComponentHjarProcessingStep.this.emptyComponentMethod(componentElement, method.methodElement())));
            return Optional.of(generatedComponent);
        }
    }
}

