/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.FormatMethod;
import dagger.internal.codegen.DaggerElements;
import dagger.internal.codegen.DaggerGraphs;
import dagger.internal.codegen.DependencyRequestFormatter;
import dagger.model.BindingGraph;
import dagger.model.DependencyRequest;
import dagger.spi.BindingGraphPlugin;
import dagger.spi.DiagnosticReporter;
import java.util.Set;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

final class DiagnosticReporterFactory {
    private final Messager messager;
    private final DependencyRequestFormatter dependencyRequestFormatter;

    @Inject
    DiagnosticReporterFactory(Messager messager, DependencyRequestFormatter dependencyRequestFormatter) {
        this.messager = messager;
        this.dependencyRequestFormatter = dependencyRequestFormatter;
    }

    DiagnosticReporterImpl reporter(BindingGraph graph, BindingGraphPlugin plugin) {
        return new DiagnosticReporterImpl(graph, plugin.pluginName());
    }

    final class DiagnosticReporterImpl
    implements DiagnosticReporter {
        private final BindingGraph graph;
        private final String plugin;
        private final TypeElement rootComponent;
        private final ImmutableSet.Builder<Diagnostic.Kind> reportedDiagnosticKinds = ImmutableSet.builder();

        DiagnosticReporterImpl(BindingGraph graph, String plugin) {
            this.graph = graph;
            this.plugin = plugin;
            this.rootComponent = graph.rootComponentNode().componentPath().currentComponent();
        }

        ImmutableSet<Diagnostic.Kind> reportedDiagnosticKinds() {
            return this.reportedDiagnosticKinds.build();
        }

        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String messageFormat) {
            StringBuilder messageBuilder = new StringBuilder(messageFormat);
            if (!componentNode.componentPath().currentComponent().equals(this.rootComponent)) {
                this.appendComponentPath(messageBuilder, (BindingGraph.Node)componentNode);
            }
            this.printMessage(diagnosticKind, messageBuilder, this.rootComponent);
        }

        @FormatMethod
        public void reportComponent(Diagnostic.Kind diagnosticKind, BindingGraph.ComponentNode componentNode, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportComponent(diagnosticKind, componentNode, this.formatMessage(messageFormat, firstArg, moreArgs));
        }

        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.BindingNode bindingNode, String message) {
            this.reportAtEntryPointsWithDependencyTrace(diagnosticKind, new StringBuilder(message), bindingNode);
        }

        public void reportBinding(Diagnostic.Kind diagnosticKind, BindingGraph.BindingNode bindingNode, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportBinding(diagnosticKind, bindingNode, this.formatMessage(messageFormat, firstArg, moreArgs));
        }

        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String message) {
            StringBuilder messageBuilder = new StringBuilder(message).append('\n').append(DiagnosticReporterFactory.this.dependencyRequestFormatter.format(dependencyEdge.dependencyRequest()));
            if (dependencyEdge.isEntryPoint()) {
                this.printAtEntryPoint(diagnosticKind, messageBuilder, dependencyEdge);
            } else {
                BindingGraph.BindingNode sourceNode = (BindingGraph.BindingNode)this.graph.incidentNodes((Object)dependencyEdge).source();
                this.reportAtEntryPointsWithDependencyTrace(diagnosticKind, messageBuilder, sourceNode);
            }
        }

        public void reportDependency(Diagnostic.Kind diagnosticKind, BindingGraph.DependencyEdge dependencyEdge, String messageFormat, Object firstArg, Object ... moreArgs) {
            this.reportDependency(diagnosticKind, dependencyEdge, this.formatMessage(messageFormat, firstArg, moreArgs));
        }

        private String formatMessage(String messageFormat, Object firstArg, Object[] moreArgs) {
            return String.format(messageFormat, Lists.asList((Object)firstArg, (Object[])moreArgs).toArray());
        }

        private void reportAtEntryPointsWithDependencyTrace(Diagnostic.Kind diagnosticKind, CharSequence message, BindingGraph.BindingNode bindingNode) {
            for (BindingGraph.DependencyEdge entryPoint : this.graph.entryPointEdgesDependingOnBindingNode(bindingNode)) {
                this.printAtEntryPoint(diagnosticKind, new StringBuilder(message).append(this.dependencyTrace(entryPoint, bindingNode)), entryPoint);
            }
        }

        private CharSequence dependencyTrace(BindingGraph.DependencyEdge entryPoint, BindingGraph.BindingNode bindingNode) {
            Preconditions.checkArgument((boolean)entryPoint.isEntryPoint());
            BindingGraph.Node entryPointBinding = (BindingGraph.Node)this.graph.incidentNodes((Object)entryPoint).target();
            ImmutableList<BindingGraph.BindingNode> shortestPath = DaggerGraphs.shortestPath(node -> Sets.filter((Set)this.graph.successors(node), BindingGraph.BindingNode.class::isInstance), entryPointBinding, bindingNode);
            StringBuilder trace = new StringBuilder(shortestPath.size() * 100);
            for (int i = shortestPath.size() - 1; i > 0; --i) {
                Set dependenciesBetween = this.graph.edgesConnecting((Object)((BindingGraph.Node)shortestPath.get(i - 1)), (Object)((BindingGraph.Node)shortestPath.get(i)));
                DependencyRequest dependencyRequest = ((BindingGraph.DependencyEdge)Iterables.get((Iterable)dependenciesBetween, (int)0)).dependencyRequest();
                trace.append('\n').append(DiagnosticReporterFactory.this.dependencyRequestFormatter.format(dependencyRequest));
            }
            trace.append('\n').append(DiagnosticReporterFactory.this.dependencyRequestFormatter.format(entryPoint.dependencyRequest()));
            return trace;
        }

        private void printAtEntryPoint(Diagnostic.Kind diagnosticKind, CharSequence message, BindingGraph.DependencyEdge entryPoint) {
            Preconditions.checkArgument((boolean)entryPoint.isEntryPoint());
            Element entryPointElement = (Element)entryPoint.dependencyRequest().requestElement().get();
            StringBuilder messageBuilder = new StringBuilder(message);
            BindingGraph.Node component = (BindingGraph.Node)this.graph.incidentNodes((Object)entryPoint).source();
            if (!component.equals(this.graph.rootComponentNode())) {
                this.appendComponentPath(messageBuilder, component);
            }
            if (this.rootComponent.getEnclosedElements().contains(entryPointElement)) {
                this.printMessage(diagnosticKind, messageBuilder, entryPointElement);
            } else {
                this.printMessage(diagnosticKind, this.insertBracketPrefix(messageBuilder, DaggerElements.elementToString(entryPointElement)), this.rootComponent);
            }
        }

        private void printMessage(Diagnostic.Kind diagnosticKind, StringBuilder message, Element elementToReport) {
            this.reportedDiagnosticKinds.add((Object)diagnosticKind);
            DiagnosticReporterFactory.this.messager.printMessage(diagnosticKind, this.insertBracketPrefix(message, this.plugin), elementToReport);
        }

        @CanIgnoreReturnValue
        private StringBuilder appendComponentPath(StringBuilder message, BindingGraph.Node node) {
            return message.append("\ncomponent path: ").append(node.componentPath());
        }

        @CanIgnoreReturnValue
        private StringBuilder insertBracketPrefix(StringBuilder messageBuilder, String prefix) {
            return messageBuilder.insert(0, String.format("[%s] ", prefix));
        }
    }
}

