/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.collect.ImmutableSet;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.AssistedInjectionAnnotations;
import dagger.internal.codegen.binding.InjectionAnnotations;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.validation.TypeCheckingProcessingStep;
import dagger.internal.codegen.validation.ValidationReport;
import dagger.shaded.auto.common.MoreElements;
import java.lang.annotation.Annotation;
import javax.annotation.processing.Messager;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

final class AssistedProcessingStep
extends TypeCheckingProcessingStep<VariableElement> {
    private final KotlinMetadataUtil kotlinMetadataUtil;
    private final InjectionAnnotations injectionAnnotations;
    private final DaggerElements elements;
    private final Messager messager;

    @Inject
    AssistedProcessingStep(KotlinMetadataUtil kotlinMetadataUtil, InjectionAnnotations injectionAnnotations, DaggerElements elements, Messager messager) {
        super(MoreElements::asVariable);
        this.kotlinMetadataUtil = kotlinMetadataUtil;
        this.injectionAnnotations = injectionAnnotations;
        this.elements = elements;
        this.messager = messager;
    }

    public ImmutableSet<Class<? extends Annotation>> annotations() {
        return ImmutableSet.of(Assisted.class);
    }

    @Override
    protected void process(VariableElement assisted, ImmutableSet<Class<? extends Annotation>> annotations) {
        new AssistedValidator().validate(assisted).printMessagesTo(this.messager);
    }

    private boolean isAssistedInjectConstructor(Element element) {
        return element.getKind() == ElementKind.CONSTRUCTOR && MoreElements.isAnnotationPresent(element, AssistedInject.class);
    }

    private boolean isAssistedFactoryCreateMethod(Element element) {
        if (element.getKind() == ElementKind.METHOD) {
            TypeElement enclosingElement = DaggerElements.closestEnclosingTypeElement(element);
            return AssistedInjectionAnnotations.isAssistedFactoryType(enclosingElement) && AssistedInjectionAnnotations.assistedFactoryMethod(enclosingElement, this.elements).equals(element);
        }
        return false;
    }

    private boolean isKotlinDataClassCopyMethod(Element element) {
        return element.getKind() == ElementKind.METHOD && element.getSimpleName().contentEquals("copy") && this.kotlinMetadataUtil.isDataClass(DaggerElements.closestEnclosingTypeElement(element));
    }

    private final class AssistedValidator {
        private AssistedValidator() {
        }

        ValidationReport<VariableElement> validate(VariableElement assisted) {
            ValidationReport.Builder<VariableElement> report = ValidationReport.about(assisted);
            Element enclosingElement = assisted.getEnclosingElement();
            if (!(AssistedProcessingStep.this.isAssistedInjectConstructor(enclosingElement) || AssistedProcessingStep.this.isAssistedFactoryCreateMethod(enclosingElement) || AssistedProcessingStep.this.isKotlinDataClassCopyMethod(enclosingElement))) {
                report.addError("@Assisted parameters can only be used within an @AssistedInject-annotated constructor.", assisted);
            }
            AssistedProcessingStep.this.injectionAnnotations.getQualifiers(assisted).forEach(qualifier -> report.addError("Qualifiers cannot be used with @Assisted parameters.", assisted, (AnnotationMirror)qualifier));
            return report.build();
        }
    }
}

