/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.componentgenerator;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.base.SourceFileGenerator;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.componentgenerator.ComponentImplementationFactory;
import dagger.internal.codegen.langmodel.DaggerElements;
import dagger.internal.codegen.writing.ComponentImplementation;
import javax.annotation.processing.Filer;
import javax.inject.Inject;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

final class ComponentGenerator
extends SourceFileGenerator<BindingGraph> {
    private final ComponentImplementationFactory componentImplementationFactory;

    @Inject
    ComponentGenerator(Filer filer, DaggerElements elements, SourceVersion sourceVersion, ComponentImplementationFactory componentImplementationFactory) {
        super(filer, elements, sourceVersion);
        this.componentImplementationFactory = componentImplementationFactory;
    }

    static ClassName componentName(TypeElement componentDefinitionType) {
        ClassName componentName = ClassName.get((TypeElement)componentDefinitionType);
        return ClassName.get((String)componentName.packageName(), (String)("Dagger" + SourceFiles.classFileName(componentName)), (String[])new String[0]);
    }

    @Override
    public Element originatingElement(BindingGraph input) {
        return input.componentTypeElement();
    }

    @Override
    public ImmutableList<TypeSpec.Builder> topLevelTypes(BindingGraph bindingGraph) {
        ComponentImplementation componentImplementation = this.componentImplementationFactory.createComponentImplementation(bindingGraph);
        Verify.verify((boolean)componentImplementation.name().equals((Object)ComponentGenerator.componentName(bindingGraph.componentTypeElement())));
        return ImmutableList.of((Object)componentImplementation.generate());
    }
}

