/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import dagger.internal.codegen.AbstractComponentWriter;
import dagger.internal.codegen.BindingGraph;
import dagger.internal.codegen.CompilerOptions;
import dagger.internal.codegen.ComponentDescriptor;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.TypeSpecs;
import dagger.internal.codegen.Util;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class ComponentWriter
extends AbstractComponentWriter {
    ComponentWriter(Types types, Elements elements, Key.Factory keyFactory, CompilerOptions compilerOptions, ClassName name, BindingGraph graph) {
        super(types, elements, keyFactory, compilerOptions, name, graph, (ImmutableMap<ComponentDescriptor, String>)new UniqueSubcomponentNamesGenerator(graph).generate());
    }

    @Override
    protected TypeSpec.Builder createComponentClass() {
        TypeSpec.Builder component = TypeSpec.classBuilder(this.name).addModifiers(Modifier.PUBLIC, Modifier.FINAL);
        TypeSpecs.addSupertype(component, this.componentDefinitionType());
        return component;
    }

    @Override
    protected ClassName builderName() {
        return this.name.nestedClass("Builder");
    }

    @Override
    protected TypeSpec.Builder createBuilder(String builderSimpleName) {
        TypeSpec.Builder builder = TypeSpec.classBuilder(builderSimpleName).addModifiers(Modifier.STATIC);
        MethodSpec builderFactoryMethod = MethodSpec.methodBuilder("builder").addModifiers(Modifier.PUBLIC, Modifier.STATIC).returns(this.graph.componentDescriptor().builderSpec().isPresent() ? ClassName.get(((ComponentDescriptor.BuilderSpec)this.graph.componentDescriptor().builderSpec().get()).builderDefinitionType()) : (ClassName)this.builderName.get()).addStatement("return new $T()", this.builderName.get()).build();
        this.component.addMethod(builderFactoryMethod);
        return builder;
    }

    @Override
    protected void addBuilderClass(TypeSpec builder) {
        this.component.addType(builder);
    }

    @Override
    protected void addFactoryMethods() {
        if (this.canInstantiateAllRequirements()) {
            String buildMethodName = this.graph.componentDescriptor().builderSpec().isPresent() ? ((ComponentDescriptor.BuilderSpec)this.graph.componentDescriptor().builderSpec().get()).buildMethod().getSimpleName() : "build";
            this.component.addMethod(MethodSpec.methodBuilder("create").returns(this.componentDefinitionTypeName()).addModifiers(Modifier.PUBLIC, Modifier.STATIC).addStatement("return builder().$L()", buildMethodName).build());
        }
    }

    private boolean canInstantiateAllRequirements() {
        return !Iterables.any(this.graph.componentRequirements(), (Predicate)new Predicate<TypeElement>(){

            public boolean apply(TypeElement dependency) {
                return Util.requiresAPassedInstance(ComponentWriter.this.elements, dependency);
            }
        });
    }

    private static class UniqueSubcomponentNamesGenerator {
        private static final Splitter QUALIFIED_NAME_SPLITTER = Splitter.on((char)'.');
        private static final Joiner QUALIFIED_NAME_JOINER = Joiner.on((char)'_');
        private final BindingGraph graph;
        private final ImmutableListMultimap<String, ComponentDescriptor> componentDescriptorsBySimpleName;
        private final ImmutableListMultimap<ComponentDescriptor, String> componentQualifiedNamePieces;

        private UniqueSubcomponentNamesGenerator(BindingGraph graph) {
            this.graph = graph;
            this.componentDescriptorsBySimpleName = Multimaps.index(graph.componentDescriptors(), (Function)new Function<ComponentDescriptor, String>(){

                public String apply(ComponentDescriptor componentDescriptor) {
                    return componentDescriptor.componentDefinitionType().getSimpleName().toString();
                }
            });
            this.componentQualifiedNamePieces = UniqueSubcomponentNamesGenerator.qualifiedNames(graph.componentDescriptors());
        }

        private ImmutableBiMap<ComponentDescriptor, String> generate() {
            LinkedHashMap<ComponentDescriptor, String> subcomponentImplSimpleNames = new LinkedHashMap<ComponentDescriptor, String>();
            for (Map.Entry componentEntry : this.componentDescriptorsBySimpleName.asMap().entrySet()) {
                Collection components = (Collection)componentEntry.getValue();
                subcomponentImplSimpleNames.putAll((Map<ComponentDescriptor, String>)this.disambiguateConflictingSimpleNames(components));
            }
            subcomponentImplSimpleNames.remove(this.graph.componentDescriptor());
            return ImmutableBiMap.copyOf(subcomponentImplSimpleNames);
        }

        private ImmutableBiMap<ComponentDescriptor, String> disambiguateConflictingSimpleNames(Collection<ComponentDescriptor> components) {
            LinkedHashMap<String, ComponentDescriptor> generatedSimpleNames = new LinkedHashMap<String, ComponentDescriptor>();
            int levels = 0;
            while (generatedSimpleNames.size() != components.size()) {
                ComponentDescriptor component;
                ImmutableList pieces;
                String simpleName;
                ComponentDescriptor conflict;
                generatedSimpleNames.clear();
                Iterator<ComponentDescriptor> iterator = components.iterator();
                while (iterator.hasNext() && (conflict = generatedSimpleNames.put(simpleName = QUALIFIED_NAME_JOINER.join((pieces = this.componentQualifiedNamePieces.get((Object)(component = iterator.next()))).subList(Math.max(0, pieces.size() - levels - 1), pieces.size())), component)) == null) {
                }
                ++levels;
            }
            return ImmutableBiMap.copyOf(generatedSimpleNames).inverse();
        }

        private static ImmutableListMultimap<ComponentDescriptor, String> qualifiedNames(Iterable<ComponentDescriptor> componentDescriptors) {
            ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
            for (ComponentDescriptor component : componentDescriptors) {
                Name qualifiedName = component.componentDefinitionType().getQualifiedName();
                builder.putAll((Object)component, QUALIFIED_NAME_SPLITTER.split((CharSequence)qualifiedName));
            }
            return builder.build();
        }
    }
}

