/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import dagger.Binds;
import dagger.Module;
import dagger.Multibindings;
import dagger.Provides;
import dagger.internal.codegen.AutoValue_ModuleDescriptor;
import dagger.internal.codegen.ConfigurationAnnotations;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.DelegateDeclaration;
import dagger.internal.codegen.MultibindingDeclaration;
import dagger.internal.codegen.ProductionBinding;
import dagger.internal.codegen.ProvisionBinding;
import dagger.multibindings.Multibinds;
import dagger.producers.ProducerModule;
import dagger.producers.Produces;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.lang.annotation.Annotation;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

abstract class ModuleDescriptor {
    ModuleDescriptor() {
    }

    static final Function<ModuleDescriptor, TypeElement> getModuleElement() {
        return new Function<ModuleDescriptor, TypeElement>(){

            public TypeElement apply(ModuleDescriptor input) {
                return input.moduleElement();
            }
        };
    }

    abstract TypeElement moduleElement();

    abstract ImmutableSet<ModuleDescriptor> includedModules();

    abstract ImmutableSet<ContributionBinding> bindings();

    abstract ImmutableSet<MultibindingDeclaration> multibindingDeclarations();

    abstract ImmutableSet<DelegateDeclaration> delegateDeclarations();

    static final class Factory {
        private final Elements elements;
        private final ProvisionBinding.Factory provisionBindingFactory;
        private final ProductionBinding.Factory productionBindingFactory;
        private final MultibindingDeclaration.Factory multibindingDeclarationFactory;
        private final DelegateDeclaration.Factory bindingDelegateDeclarationFactory;

        Factory(Elements elements, ProvisionBinding.Factory provisionBindingFactory, ProductionBinding.Factory productionBindingFactory, MultibindingDeclaration.Factory multibindingDeclarationFactory, DelegateDeclaration.Factory bindingDelegateDeclarationFactory) {
            this.elements = elements;
            this.provisionBindingFactory = provisionBindingFactory;
            this.productionBindingFactory = productionBindingFactory;
            this.multibindingDeclarationFactory = multibindingDeclarationFactory;
            this.bindingDelegateDeclarationFactory = bindingDelegateDeclarationFactory;
        }

        ModuleDescriptor create(TypeElement moduleElement) {
            Preconditions.checkState((boolean)Factory.getModuleAnnotation(moduleElement).isPresent(), (String)"%s did not have an AnnotationMirror for @Module", (Object[])new Object[]{moduleElement.getQualifiedName()});
            ImmutableSet.Builder bindings = ImmutableSet.builder();
            ImmutableSet.Builder delegates = ImmutableSet.builder();
            ImmutableSet.Builder multibindingDeclarations = ImmutableSet.builder();
            for (ExecutableElement moduleMethod : ElementFilter.methodsIn(this.elements.getAllMembers(moduleElement))) {
                if (MoreElements.isAnnotationPresent(moduleMethod, Provides.class)) {
                    bindings.add((Object)this.provisionBindingFactory.forProvidesMethod(moduleMethod, moduleElement));
                }
                if (MoreElements.isAnnotationPresent(moduleMethod, Produces.class)) {
                    bindings.add((Object)this.productionBindingFactory.forProducesMethod(moduleMethod, moduleElement));
                }
                if (MoreElements.isAnnotationPresent(moduleMethod, Binds.class)) {
                    delegates.add((Object)this.bindingDelegateDeclarationFactory.create(moduleMethod, moduleElement));
                }
                if (!MoreElements.isAnnotationPresent(moduleMethod, Multibinds.class)) continue;
                multibindingDeclarations.add((Object)this.multibindingDeclarationFactory.forMultibindsMethod(moduleMethod, moduleElement));
            }
            for (TypeElement memberType : ElementFilter.typesIn(this.elements.getAllMembers(moduleElement))) {
                if (!MoreElements.isAnnotationPresent(memberType, Multibindings.class)) continue;
                multibindingDeclarations.addAll(this.multibindingDeclarationFactory.forMultibindingsInterface(memberType));
            }
            return new AutoValue_ModuleDescriptor(moduleElement, (ImmutableSet<ModuleDescriptor>)ImmutableSet.copyOf(this.collectIncludedModules(new LinkedHashSet<ModuleDescriptor>(), moduleElement)), (ImmutableSet<ContributionBinding>)bindings.build(), (ImmutableSet<MultibindingDeclaration>)multibindingDeclarations.build(), (ImmutableSet<DelegateDeclaration>)delegates.build());
        }

        private static Optional<AnnotationMirror> getModuleAnnotation(TypeElement moduleElement) {
            return MoreElements.getAnnotationMirror(moduleElement, Module.class).or(MoreElements.getAnnotationMirror(moduleElement, ProducerModule.class));
        }

        @CanIgnoreReturnValue
        private Set<ModuleDescriptor> collectIncludedModules(Set<ModuleDescriptor> includedModules, TypeElement moduleElement) {
            Optional<AnnotationMirror> moduleAnnotation;
            TypeMirror superclass = moduleElement.getSuperclass();
            if (!superclass.getKind().equals((Object)TypeKind.NONE)) {
                Verify.verify((boolean)superclass.getKind().equals((Object)TypeKind.DECLARED));
                TypeElement superclassElement = MoreTypes.asTypeElement(superclass);
                if (!superclassElement.getQualifiedName().contentEquals(Object.class.getCanonicalName())) {
                    this.collectIncludedModules(includedModules, superclassElement);
                }
            }
            if ((moduleAnnotation = Factory.getModuleAnnotation(moduleElement)).isPresent()) {
                for (TypeMirror moduleIncludesType : ConfigurationAnnotations.getModuleIncludes((AnnotationMirror)moduleAnnotation.get())) {
                    includedModules.add(this.create(MoreTypes.asTypeElement(moduleIncludesType)));
                }
            }
            return includedModules;
        }
    }

    static enum Kind {
        MODULE(Module.class, Provides.class, (ImmutableSet<? extends Class<? extends Annotation>>)ImmutableSet.of(Module.class)),
        PRODUCER_MODULE(ProducerModule.class, Produces.class, (ImmutableSet<? extends Class<? extends Annotation>>)ImmutableSet.of(Module.class, ProducerModule.class));

        private final Class<? extends Annotation> moduleAnnotation;
        private final Class<? extends Annotation> methodAnnotation;
        private final ImmutableSet<? extends Class<? extends Annotation>> includesTypes;

        static Optional<Kind> forAnnotatedElement(TypeElement element) {
            EnumSet<Kind> kinds = EnumSet.noneOf(Kind.class);
            for (Kind kind : Kind.values()) {
                if (!MoreElements.isAnnotationPresent(element, kind.moduleAnnotation())) continue;
                kinds.add(kind);
            }
            Preconditions.checkArgument((kinds.size() <= 1 ? 1 : 0) != 0, (String)"%s cannot be annotated with more than one of %s", (Object[])new Object[]{element, kinds});
            return Optional.fromNullable((Object)Iterables.getOnlyElement(kinds, null));
        }

        private Kind(Class<? extends Annotation> moduleAnnotation, Class<? extends Annotation> methodAnnotation, ImmutableSet<? extends Class<? extends Annotation>> includesTypes) {
            this.moduleAnnotation = moduleAnnotation;
            this.methodAnnotation = methodAnnotation;
            this.includesTypes = includesTypes;
        }

        Class<? extends Annotation> moduleAnnotation() {
            return this.moduleAnnotation;
        }

        Class<? extends Annotation> methodAnnotation() {
            return this.methodAnnotation;
        }

        ImmutableSet<? extends Class<? extends Annotation>> includesTypes() {
            return this.includesTypes;
        }
    }
}

