/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import dagger.internal.codegen.AutoValue_ProductionBinding;
import dagger.internal.codegen.BindingType;
import dagger.internal.codegen.ContributionBinding;
import dagger.internal.codegen.ContributionType;
import dagger.internal.codegen.DelegateDeclaration;
import dagger.internal.codegen.DependencyRequest;
import dagger.internal.codegen.Key;
import dagger.internal.codegen.MapKeys;
import dagger.internal.codegen.MoreAnnotationMirrors;
import dagger.producers.Producer;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

abstract class ProductionBinding
extends ContributionBinding {
    ProductionBinding() {
    }

    @Override
    public BindingType bindingType() {
        return BindingType.PRODUCTION;
    }

    Optional<ProductionBinding> unresolved() {
        return Optional.absent();
    }

    @Override
    Set<DependencyRequest> implicitDependencies() {
        if (!this.executorRequest().isPresent() && !this.monitorRequest().isPresent()) {
            return super.implicitDependencies();
        }
        return Sets.union((Set)Sets.union((Set)this.executorRequest().asSet(), (Set)this.monitorRequest().asSet()), super.implicitDependencies());
    }

    abstract ImmutableList<? extends TypeMirror> thrownTypes();

    abstract Optional<DependencyRequest> executorRequest();

    abstract Optional<DependencyRequest> monitorRequest();

    static final class Factory {
        private final Types types;
        private final Key.Factory keyFactory;
        private final DependencyRequest.Factory dependencyRequestFactory;

        Factory(Types types, Key.Factory keyFactory, DependencyRequest.Factory dependencyRequestFactory) {
            this.types = types;
            this.keyFactory = keyFactory;
            this.dependencyRequestFactory = dependencyRequestFactory;
        }

        ProductionBinding forProducesMethod(ExecutableElement producesMethod, TypeElement contributedBy) {
            Preconditions.checkArgument((boolean)producesMethod.getKind().equals((Object)ElementKind.METHOD));
            Key key = this.keyFactory.forProducesMethod(producesMethod, contributedBy);
            ExecutableType resolvedMethod = MoreTypes.asExecutable(this.types.asMemberOf(MoreTypes.asDeclared(contributedBy.asType()), producesMethod));
            ImmutableSet<DependencyRequest> dependencies = this.dependencyRequestFactory.forRequiredResolvedVariables(producesMethod.getParameters(), resolvedMethod.getParameterTypes());
            DependencyRequest executorRequest = this.dependencyRequestFactory.forProductionImplementationExecutor();
            DependencyRequest monitorRequest = this.dependencyRequestFactory.forProductionComponentMonitorProvider();
            ContributionBinding.Kind kind = MoreTypes.isTypeOf(ListenableFuture.class, producesMethod.getReturnType()) ? ContributionBinding.Kind.FUTURE_PRODUCTION : ContributionBinding.Kind.IMMEDIATE;
            return new AutoValue_ProductionBinding(ContributionType.fromBindingMethod(producesMethod), producesMethod, (Optional<TypeElement>)Optional.of((Object)contributedBy), key, dependencies, (Optional<DeclaredType>)Optional.absent(), (Optional<DependencyRequest>)Optional.absent(), MoreAnnotationMirrors.wrapOptionalInEquivalence(MapKeys.getMapKey(producesMethod)), kind, (ImmutableList<? extends TypeMirror>)ImmutableList.copyOf(producesMethod.getThrownTypes()), (Optional<DependencyRequest>)Optional.of((Object)executorRequest), (Optional<DependencyRequest>)Optional.of((Object)monitorRequest));
        }

        ProductionBinding syntheticMapOfValuesOrProducedBinding(DependencyRequest requestForMapOfValuesOrProduced) {
            Preconditions.checkNotNull((Object)requestForMapOfValuesOrProduced);
            Optional<Key> mapOfProducersKey = this.keyFactory.implicitMapProducerKeyFrom(requestForMapOfValuesOrProduced.key());
            Preconditions.checkArgument((boolean)mapOfProducersKey.isPresent(), (String)"%s is not for a Map<K, V>", (Object[])new Object[]{requestForMapOfValuesOrProduced});
            DependencyRequest requestForMapOfProducers = this.dependencyRequestFactory.forImplicitMapBinding(requestForMapOfValuesOrProduced, (Key)mapOfProducersKey.get());
            return new AutoValue_ProductionBinding(ContributionType.UNIQUE, requestForMapOfProducers.requestElement(), (Optional<TypeElement>)Optional.absent(), requestForMapOfValuesOrProduced.key(), (ImmutableSet<DependencyRequest>)ImmutableSet.of((Object)requestForMapOfProducers), (Optional<DeclaredType>)Optional.absent(), (Optional<DependencyRequest>)Optional.absent(), MoreAnnotationMirrors.wrapOptionalInEquivalence(MapKeys.getMapKey(requestForMapOfProducers.requestElement())), ContributionBinding.Kind.SYNTHETIC_MAP, (ImmutableList<? extends TypeMirror>)ImmutableList.of(), (Optional<DependencyRequest>)Optional.absent(), (Optional<DependencyRequest>)Optional.absent());
        }

        ProductionBinding syntheticMultibinding(DependencyRequest request, Iterable<ContributionBinding> multibindingContributions) {
            return new AutoValue_ProductionBinding(ContributionType.UNIQUE, request.requestElement(), (Optional<TypeElement>)Optional.absent(), request.key(), this.dependencyRequestFactory.forMultibindingContributions(request, multibindingContributions), (Optional<DeclaredType>)Optional.absent(), (Optional<DependencyRequest>)Optional.absent(), (Optional<Equivalence.Wrapper<AnnotationMirror>>)Optional.absent(), ContributionBinding.Kind.forMultibindingRequest(request), (ImmutableList<? extends TypeMirror>)ImmutableList.of(), (Optional<DependencyRequest>)Optional.absent(), (Optional<DependencyRequest>)Optional.absent());
        }

        ProductionBinding forComponentMethod(ExecutableElement componentMethod) {
            Preconditions.checkNotNull((Object)componentMethod);
            Preconditions.checkArgument((boolean)componentMethod.getKind().equals((Object)ElementKind.METHOD));
            Preconditions.checkArgument((boolean)componentMethod.getParameters().isEmpty());
            Preconditions.checkArgument((boolean)MoreTypes.isTypeOf(ListenableFuture.class, componentMethod.getReturnType()));
            return new AutoValue_ProductionBinding(ContributionType.UNIQUE, componentMethod, (Optional<TypeElement>)Optional.absent(), this.keyFactory.forProductionComponentMethod(componentMethod), (ImmutableSet<DependencyRequest>)ImmutableSet.of(), (Optional<DeclaredType>)Optional.absent(), (Optional<DependencyRequest>)Optional.absent(), (Optional<Equivalence.Wrapper<AnnotationMirror>>)Optional.absent(), ContributionBinding.Kind.COMPONENT_PRODUCTION, (ImmutableList<? extends TypeMirror>)ImmutableList.copyOf(componentMethod.getThrownTypes()), (Optional<DependencyRequest>)Optional.absent(), (Optional<DependencyRequest>)Optional.absent());
        }

        ProductionBinding delegate(DelegateDeclaration delegateDeclaration, ProductionBinding delegateBinding) {
            Key key = this.keyFactory.forDelegateBinding(delegateDeclaration, Producer.class);
            return new AutoValue_ProductionBinding(delegateDeclaration.contributionType(), delegateDeclaration.bindingElement(), delegateDeclaration.contributingModule(), key, (ImmutableSet<DependencyRequest>)ImmutableSet.of((Object)delegateDeclaration.delegateRequest()), delegateBinding.nullableType(), (Optional<DependencyRequest>)Optional.absent(), delegateDeclaration.wrappedMapKey(), ContributionBinding.Kind.SYNTHETIC_DELEGATE_BINDING, (ImmutableList<? extends TypeMirror>)ImmutableList.of(), (Optional<DependencyRequest>)Optional.absent(), (Optional<DependencyRequest>)Optional.absent());
        }
    }
}

