/*
 * Decompiled with CFR 0.152.
 */
package dagger.spi.model;

import com.google.auto.value.AutoValue;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import dagger.spi.model.AutoValue_DaggerExecutableElement;
import dagger.spi.model.DaggerProcessingEnv;
import javax.annotation.Nullable;
import javax.lang.model.element.ExecutableElement;

@AutoValue
public abstract class DaggerExecutableElement {
    public static DaggerExecutableElement fromJava(ExecutableElement executableElement) {
        return new AutoValue_DaggerExecutableElement(executableElement, null);
    }

    public static DaggerExecutableElement fromKsp(KSFunctionDeclaration declaration) {
        return new AutoValue_DaggerExecutableElement(null, declaration);
    }

    @Nullable
    public abstract ExecutableElement java();

    @Nullable
    public abstract KSFunctionDeclaration ksp();

    public DaggerProcessingEnv.Backend backend() {
        if (this.java() != null) {
            return DaggerProcessingEnv.Backend.JAVAC;
        }
        if (this.ksp() != null) {
            return DaggerProcessingEnv.Backend.KSP;
        }
        throw new AssertionError((Object)"Unexpected backend");
    }

    public final String toString() {
        switch (this.backend()) {
            case JAVAC: {
                return this.java().toString();
            }
            case KSP: {
                return this.ksp().toString();
            }
        }
        throw new IllegalStateException(String.format("Backend %s not supported yet.", new Object[]{this.backend()}));
    }

    String simpleName() {
        switch (this.backend()) {
            case JAVAC: {
                return this.java().getSimpleName().toString();
            }
            case KSP: {
                return this.ksp().getSimpleName().toString();
            }
        }
        throw new IllegalStateException(String.format("Backend %s not supported yet.", new Object[]{this.backend()}));
    }
}

