/*
 * Decompiled with CFR 0.152.
 */
package dagger.spi.model;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import dagger.spi.model.AutoValue_Scope;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.DaggerTypeElement;

@AutoValue
public abstract class Scope {
    private static final String PRODUCTION_SCOPE = "dagger.producers.ProductionScope";
    private static final String SINGLETON = "jakarta.inject.Singleton";
    private static final String SINGLETON_JAVAX = "javax.inject.Singleton";
    private static final String REUSABLE = "dagger.Reusable";
    private static final String SCOPE = "jakarta.inject.Scope";
    private static final String SCOPE_JAVAX = "javax.inject.Scope";

    public static Scope scope(DaggerAnnotation scopeAnnotation) {
        Preconditions.checkArgument((boolean)Scope.isScope(scopeAnnotation));
        return new AutoValue_Scope(scopeAnnotation);
    }

    public static boolean isScope(DaggerAnnotation scopeAnnotation) {
        return Scope.isScope(scopeAnnotation.annotationTypeElement());
    }

    public static boolean isScope(DaggerTypeElement scopeAnnotationType) {
        return scopeAnnotationType.hasAnnotation(SCOPE) || scopeAnnotationType.hasAnnotation(SCOPE_JAVAX);
    }

    private boolean isScope(String annotationName) {
        return this.scopeAnnotation().toString().equals(annotationName);
    }

    public abstract DaggerAnnotation scopeAnnotation();

    public final boolean isSingleton() {
        return this.isScope(SINGLETON) || this.isScope(SINGLETON_JAVAX);
    }

    public final boolean isReusable() {
        return this.isScope(REUSABLE);
    }

    public final boolean isProductionScope() {
        return this.isScope(PRODUCTION_SCOPE);
    }

    public final String toString() {
        return this.scopeAnnotation().toString();
    }
}

