/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash.plugin;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.google.firebase.crash.plugin.FirebaseCrashPluginUtil;
import com.google.firebase.crash.plugin.UploadProguardMappingTask;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;

public class FirebaseCrashPlugin
implements Plugin<Project> {
    public static final String JSON_FILE_NAME = "google-services.json";
    private static final String SERVICE_ACCOUNT_PROJECT_PROPERTY = "FirebaseServiceAccountFilePath";
    private static final String FIREBASE_CRASH_TAG = "Firebase Crash Plugin";
    public static final String MAPPING_FILE_PATH_PROJECT_PROPERTY = "FirebaseCrashMappingFilePath";
    public static final String VERSION_PROJECT_PROPERTY = "FirebaseCrashVersionCode";
    public static final String PACKAGE_NAME_PROPERTY = "FirebaseCrashPackageName";
    public static final String API_KEY = "FirebaseCrashApiKey";
    public static final String APP_ID = "FirebaseCrashAppId";

    public void apply(Project project) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                block7: {
                    try {
                        Object ext;
                        String serviceAccountFilePath = null;
                        if (project.hasProperty(FirebaseCrashPlugin.SERVICE_ACCOUNT_PROJECT_PROPERTY)) {
                            serviceAccountFilePath = project.property(FirebaseCrashPlugin.SERVICE_ACCOUNT_PROJECT_PROPERTY).toString();
                        }
                        if ((ext = project.getExtensions().findByName("android")) instanceof AppExtension) {
                            AppExtension androidExt = (AppExtension)ext;
                            boolean firstVariant = true;
                            for (ApplicationVariant variant : androidExt.getApplicationVariants()) {
                                if (firstVariant) {
                                    FirebaseCrashPlugin.this.createArchivedTask(project, serviceAccountFilePath, variant);
                                    firstVariant = false;
                                }
                                if (!variant.getBuildType().isMinifyEnabled()) continue;
                                HashMap<String, Integer> versionCodes = new HashMap<String, Integer>();
                                versionCodes.put(variant.getName(), variant.getVersionCode());
                                File googleServicesJsonFile = FirebaseCrashPluginUtil.getGoogleServicesJsonFile(variant, project);
                                FirebaseCrashPlugin.this.createUploadMappingTask(project, variant, serviceAccountFilePath, versionCodes, googleServicesJsonFile);
                            }
                            break block7;
                        }
                        if (ext instanceof LibraryExtension) {
                            throw new RuntimeException("Firebase Crash Plugin cannot be applied to a library project.  It must only be used with an Android application project.");
                        }
                        throw new RuntimeException("Firebase Crash Plugin may only be applied to Android projects");
                    }
                    catch (Exception e) {
                        project.getLogger().error("Cannot create tasks to upload Proguard Mapping File." + e);
                    }
                }
            }
        });
    }

    private void createUploadMappingTask(Project project, ApplicationVariant variant, String serviceAccountFilePath, Map<String, Integer> versionCodes, File googleServicesJsonFile) throws InvalidUserDataException, IOException {
        String variantName = variant.getName().substring(0, 1).toUpperCase() + variant.getName().substring(1);
        UploadProguardMappingTask uploadTask = (UploadProguardMappingTask)project.getTasks().create("firebaseUpload" + variantName + "ProguardMapping", UploadProguardMappingTask.class);
        uploadTask.dependsOn(new Object[]{variant.getAssemble()});
        uploadTask.setDescription("Uploads the Proguard mapping file for the " + variantName + " build to the Firebase Crash Service");
        uploadTask.init(googleServicesJsonFile, variant.getMappingFile().getPath(), variant.getApplicationId(), versionCodes, project, serviceAccountFilePath, variant);
    }

    private void createArchivedTask(Project project, String serviceAccountFilePath, ApplicationVariant variant) {
        UploadProguardMappingTask uploadTask = (UploadProguardMappingTask)project.getTasks().create("firebaseUploadArchivedProguardMapping", UploadProguardMappingTask.class);
        uploadTask.setDescription("Uploads the Proguard mapping file for archived applications by specifying properties FirebaseCrashMappingFilePath, FirebaseCrashVersionCode, FirebaseCrashPackageName, and optionally both FirebaseCrashAppId and FirebaseCrashApiKey");
        String mappingFilePath = null;
        String packageName = null;
        HashMap<String, Integer> versionMap = null;
        String apiKey = null;
        String appId = null;
        if (project.hasProperty(MAPPING_FILE_PATH_PROJECT_PROPERTY)) {
            mappingFilePath = project.property(MAPPING_FILE_PATH_PROJECT_PROPERTY).toString();
        }
        if (project.hasProperty(PACKAGE_NAME_PROPERTY)) {
            packageName = project.property(PACKAGE_NAME_PROPERTY).toString();
        }
        if (project.hasProperty(VERSION_PROJECT_PROPERTY)) {
            try {
                int version = Integer.valueOf(project.property(VERSION_PROJECT_PROPERTY).toString());
                versionMap = new HashMap<String, Integer>();
                versionMap.put("archivedApp", version);
            }
            catch (NumberFormatException e) {
                versionMap = null;
            }
        }
        if (project.hasProperty(API_KEY)) {
            apiKey = String.valueOf(project.property(API_KEY));
        }
        if (project.hasProperty(APP_ID)) {
            appId = String.valueOf(project.property(APP_ID));
        }
        uploadTask.init(project.file((Object)JSON_FILE_NAME), mappingFilePath, packageName, versionMap, project, serviceAccountFilePath, variant, apiKey, appId);
    }
}

