/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash.plugin;

import com.android.build.gradle.api.ApplicationVariant;
import java.io.File;
import java.util.ArrayList;
import org.gradle.api.Project;

public final class FirebaseCrashPluginUtil {
    public static File getGoogleServicesJsonFile(ApplicationVariant variant, Project project) {
        File googleServicesFile = null;
        String flavorName = variant.getFlavorName();
        String buildType = variant.getBuildType().getName();
        ArrayList<String> checkLocations = new ArrayList<String>();
        if (flavorName != null && buildType != null) {
            checkLocations.add("src/" + flavorName + "/" + buildType);
            checkLocations.add("src/" + buildType + "/" + flavorName);
            checkLocations.add("src/" + flavorName);
            checkLocations.add("src/" + buildType);
            checkLocations.add("src/" + flavorName + buildType.substring(0, 1).toUpperCase() + buildType.substring(1));
        } else if (buildType != null) {
            checkLocations.add("src/" + buildType);
        }
        for (String location : checkLocations) {
            File jsonFile = project.file((Object)(location + "/" + "google-services.json"));
            if (!jsonFile.isFile()) continue;
            googleServicesFile = jsonFile;
            break;
        }
        if (googleServicesFile == null) {
            googleServicesFile = project.file((Object)"google-services.json");
        }
        return googleServicesFile;
    }
}

