/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash.plugin;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.GradleException;

public class NetworkConnectionProvider {
    private static final String SCOPE = "https://www.googleapis.com/auth/mobilecrashreporting";
    private static final String ERROR_MESSAGE = "Unable to upload mapping file. ";
    private static final String ERROR_MESSAGE_INVALID_SERVICE_FILE = "Unexpected exception reading PKCS data";

    public String getSignedUrlKey(URL inputUrl, File serviceAccountFile) throws GradleException {
        try {
            HttpRequestFactory requestFactory = this.newHttpRequestFactory(serviceAccountFile);
            GenericUrl url = new GenericUrl(inputUrl);
            HttpRequest request = requestFactory.buildPostRequest(url, (HttpContent)new EmptyContent());
            return request.execute().parseAsString();
        }
        catch (IOException e) {
            throw new GradleException(this.getErrorMessage(e), (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new GradleException(ERROR_MESSAGE, (Throwable)e);
        }
    }

    public void uploadFile(URL inputUrl, File mappingFile, File serviceAccountFile) throws GradleException {
        try {
            HttpRequestFactory requestFactory = this.newHttpRequestFactory(serviceAccountFile);
            GenericUrl url = new GenericUrl(inputUrl);
            HttpRequest request = requestFactory.buildPutRequest(url, (HttpContent)new FileContent("text/plain", mappingFile));
            request.execute();
        }
        catch (IOException e) {
            throw new GradleException(this.getErrorMessage(e), (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new GradleException(ERROR_MESSAGE, (Throwable)e);
        }
    }

    public String updateMapping(URL inputUrl, String proguardMapping, File serviceAccountFile) throws GradleException {
        try {
            HttpRequestFactory requestFactory = this.newHttpRequestFactory(serviceAccountFile);
            GenericUrl url = new GenericUrl(inputUrl);
            HttpRequest request = requestFactory.buildPostRequest(url, (HttpContent)ByteArrayContent.fromString((String)"application/json", (String)proguardMapping));
            return request.execute().parseAsString();
        }
        catch (IOException e) {
            throw new GradleException(this.getErrorMessage(e), (Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new GradleException(ERROR_MESSAGE, (Throwable)e);
        }
    }

    private HttpRequestFactory newHttpRequestFactory(File serviceAccountFile) throws IOException, GeneralSecurityException {
        FileInputStream stream = new FileInputStream(serviceAccountFile);
        Set<String> scopes = Collections.singleton(SCOPE);
        GoogleCredential credential = GoogleCredential.fromStream((InputStream)stream).createScoped(scopes);
        NetHttpTransport transport = GoogleNetHttpTransport.newTrustedTransport();
        return transport.createRequestFactory((HttpRequestInitializer)credential);
    }

    public String getErrorMessage(IOException e) throws GradleException {
        int index;
        String exceptionMessage = e.getMessage();
        if (exceptionMessage.equals(ERROR_MESSAGE_INVALID_SERVICE_FILE)) {
            return "Unable to upload mapping file. Check that service account file is valid.";
        }
        if (exceptionMessage != null && (index = exceptionMessage.indexOf(123)) != -1) {
            String message = exceptionMessage.substring(index);
            try {
                JsonParser parser = new JsonParser();
                JsonElement jsonElement = parser.parse(message);
                String errorMessage = jsonElement.getAsJsonObject().getAsJsonObject("error").get("message").getAsString();
                return ERROR_MESSAGE + errorMessage;
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
        return ERROR_MESSAGE;
    }
}

