/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash.plugin;

import com.google.common.base.Strings;
import com.google.firebase.crash.plugin.googleserviceobjects.AndroidClientInfo;
import com.google.firebase.crash.plugin.googleserviceobjects.ApiKeyObj;
import com.google.firebase.crash.plugin.googleserviceobjects.ClientInfoObj;
import com.google.firebase.crash.plugin.googleserviceobjects.ClientObj;
import com.google.firebase.crash.plugin.googleserviceobjects.GoogleServicesRootObj;
import org.gradle.api.GradleException;

public class ParseJSON {
    public static ClientObj getClientForPackageName(GoogleServicesRootObj root, String packageName) {
        if (root != null) {
            ClientObj[] clientArray = root.getClients();
            for (int i = 0; i < clientArray.length; ++i) {
                String clientPackageName;
                AndroidClientInfo androidClientInfo;
                ClientInfoObj clientInfo;
                ClientObj client = clientArray[i];
                if (client == null || (clientInfo = client.getClientInfoObj()) == null || (androidClientInfo = clientInfo.getAndroidClientInfo()) == null || (clientPackageName = androidClientInfo.getPackageName()) == null || !packageName.equals(clientPackageName)) continue;
                return client;
            }
        }
        return null;
    }

    public static String parseGoogleAppId(ClientObj clientObject) throws GradleException {
        ClientInfoObj clientInfo = clientObject.getClientInfoObj();
        String googleAppId = clientInfo.getAppId();
        if (googleAppId == null || Strings.isNullOrEmpty((String)googleAppId)) {
            throw new GradleException("There is no valid app id in the google-services.json file!");
        }
        return googleAppId;
    }

    public static String parseGoogleApiKey(ClientObj clientObject) throws GradleException {
        ApiKeyObj[] keyObj = clientObject.getApiKeyObj();
        if (keyObj != null) {
            for (int i = 0; i < keyObj.length; ++i) {
                String currentKey;
                if (keyObj[i] == null || (currentKey = keyObj[i].getCurrentKey()) == null) continue;
                return currentKey;
            }
        }
        throw new GradleException("Missing api_key/current_key object in google-services.json");
    }
}

