/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crash.plugin;

import com.google.firebase.crash.plugin.NetworkConnectionProvider;
import com.google.firebase.crash.plugin.logging.Logging;
import com.google.firebase.crash.plugin.mappingfileobjects.SignedObject;
import com.google.firebase.crash.plugin.mappingfileobjects.UploadMappingResponse;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.gradle.api.GradleException;

public class SingleVersionMappingFileUploader {
    private static final String BASE_URL = "https://mobilecrashreporting.googleapis.com";
    private static final int PG_SYMBOL_TYPE = 1;
    private static final String VERSION_NUM = "/v1/";
    private Map<String, String> mResValues;
    private int mAppVersion;
    private String mMappingFilePath;
    private Logging mLogger;
    private File mServiceAccountFile;
    private String mVariantName;
    private NetworkConnectionProvider mNetworkConnectionProvider;

    public SingleVersionMappingFileUploader(Map<String, String> resValues, String mappingFilePath, Logging logging, File serviceAccountFile, NetworkConnectionProvider networkConnectionProvider) {
        this.mResValues = resValues;
        this.mMappingFilePath = mappingFilePath;
        this.mLogger = logging;
        this.mServiceAccountFile = serviceAccountFile;
        this.mNetworkConnectionProvider = networkConnectionProvider;
    }

    public void uploadMappingFile(int appVersion, String variantName) {
        this.mAppVersion = appVersion;
        this.mVariantName = variantName;
        URL url = this.constructSignedUrlConnectionUrl();
        String signedUrlRes = this.mNetworkConnectionProvider.getSignedUrlKey(url, this.mServiceAccountFile);
        this.parseSignedUrlResponse(signedUrlRes);
        url = this.constructUploadMappingConnectionUrl();
        File file = new File(this.mMappingFilePath);
        this.mNetworkConnectionProvider.uploadFile(url, file, this.mServiceAccountFile);
        url = this.constructUpdateMappingConnectionUrl();
        String proguardMapping = this.constructUpsertJSON();
        String response = this.mNetworkConnectionProvider.updateMapping(url, proguardMapping, this.mServiceAccountFile);
        this.parseUpdateMapping(response);
    }

    private String constructUpsertJSON() {
        JsonObject upsertObject = new JsonObject();
        JsonObject symbolFileMappingObject = new JsonObject();
        symbolFileMappingObject.addProperty("symbol_type", (Number)1);
        symbolFileMappingObject.addProperty("app_version", String.valueOf(this.mAppVersion));
        upsertObject.addProperty("upload_key", this.mResValues.get("upload_key"));
        upsertObject.add("symbol_file_mapping", (JsonElement)symbolFileMappingObject);
        return upsertObject.toString();
    }

    private URL constructSignedUrlConnectionUrl() throws GradleException {
        URL fullUrl;
        try {
            String encodedApiKey = URLEncoder.encode(this.mResValues.get("api_key"), "UTF-8");
            fullUrl = new URL("https://mobilecrashreporting.googleapis.com/v1/" + this.mResValues.get("app_name") + "/symbolFileUploadLocation?key=" + encodedApiKey);
        }
        catch (IOException e) {
            throw new GradleException("Unable to construct signed url to upload mapping file", (Throwable)e);
        }
        return fullUrl;
    }

    private void parseSignedUrlResponse(String response) throws GradleException {
        SignedObject obj = null;
        try {
            Gson gson = new Gson();
            obj = (SignedObject)gson.fromJson(response.toString(), SignedObject.class);
        }
        catch (JsonSyntaxException e) {
            throw new GradleException("Did not receive json signed url response from server", (Throwable)e);
        }
        if (obj == null) {
            throw new GradleException("Did not receive json signed url response from server");
        }
        this.mResValues.put("upload_url", obj.getUploadUrl());
        this.mResValues.put("upload_key", obj.getUploadKey());
    }

    private URL constructUploadMappingConnectionUrl() {
        URL url;
        try {
            url = new URL(this.mResValues.get("upload_url"));
        }
        catch (IOException e) {
            throw new GradleException("Unable to construct url to upload mapping file", (Throwable)e);
        }
        return url;
    }

    private void parseUpdateMapping(String response) throws GradleException {
        UploadMappingResponse responseObj = null;
        try {
            Gson gson = new Gson();
            responseObj = (UploadMappingResponse)gson.fromJson(response.toString(), UploadMappingResponse.class);
        }
        catch (JsonSyntaxException e) {
            throw new GradleException("Did not receive json response from server after uploading Proguard mapping file", (Throwable)e);
        }
        if (responseObj == null) {
            throw new GradleException("Did not receive json response from server after uploading Proguard mapping file");
        }
        String createTime = responseObj.getSymbolFileMapping().getCreateTime();
        if (createTime == null) {
            throw new GradleException("Unable to update mapping file");
        }
        this.mLogger.logQuiet("Successfully uploaded proguard mapping file for app " + this.mVariantName + " with versionCode: " + this.mAppVersion + "!");
    }

    private URL constructUpdateMappingConnectionUrl() {
        URL upsertUploadUrl;
        try {
            String encodedApiKey = URLEncoder.encode(this.mResValues.get("api_key"), "UTF-8");
            upsertUploadUrl = new URL("https://mobilecrashreporting.googleapis.com/v1/" + this.mResValues.get("app_name") + "/symbolFileMappings:upsert?key=" + encodedApiKey);
        }
        catch (IOException e) {
            throw new GradleException("Unable to construct url to upsert mapping file", (Throwable)e);
        }
        return upsertUploadUrl;
    }
}

